/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.io.InputStream;
import org.simpleframework.http.ContentType;
import org.simpleframework.http.Part;
import org.simpleframework.http.core.EmptyInputStream;
import org.simpleframework.http.core.PartList;
import org.simpleframework.http.core.Segment;
import org.simpleframework.http.core.UpdateConsumer;
import org.simpleframework.transport.Cursor;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.Buffer;

class ContentConsumer
extends UpdateConsumer
implements Part {
    private static final byte[] START = new byte[]{13, 10, 45, 45};
    private Allocator allocator;
    private Buffer buffer;
    private Segment segment;
    private PartList list;
    private byte[] boundary;
    private int start;
    private int seek;

    public ContentConsumer(Allocator allocator, Segment segment, PartList list, byte[] boundary) {
        this.allocator = allocator;
        this.boundary = boundary;
        this.segment = segment;
        this.list = list;
    }

    public boolean isFile() {
        return this.segment.isFile();
    }

    public String getName() {
        return this.segment.getName();
    }

    public String getFileName() {
        return this.segment.getFileName();
    }

    public String getHeader(String name) {
        return this.segment.getValue(name);
    }

    public ContentType getContentType() {
        return this.segment.getContentType();
    }

    public String getContent() throws IOException {
        return this.getContent("ISO-8859-1");
    }

    public String getContent(String charset) throws IOException {
        if (this.buffer == null) {
            return new String();
        }
        return this.buffer.encode(charset);
    }

    public InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            return new EmptyInputStream();
        }
        return this.buffer.getInputStream();
    }

    protected void commit(Cursor cursor) throws IOException {
        cursor.push(this.boundary);
        cursor.push(START);
    }

    protected int update(byte[] array, int off, int size) throws IOException {
        int excess;
        int skip = this.start + this.seek;
        int last = off + size;
        int next = this.start;
        int mark = off;
        while (off < last) {
            byte octet;
            if (this.start == START.length) {
                if (array[off++] != this.boundary[this.seek++]) {
                    if (skip > 0) {
                        this.append(START, 0, next);
                        this.append(this.boundary, 0, skip - next);
                    }
                    this.seek = 0;
                    this.start = 0;
                    skip = 0;
                }
                if (this.seek != this.boundary.length) continue;
                excess = this.seek + this.start;
                int total = off - mark;
                int valid = total - excess;
                this.finished = true;
                this.list.add(this);
                if (valid > 0) {
                    this.append(array, mark, valid);
                }
                return size - total;
            }
            if ((octet = array[off++]) == START[this.start++]) continue;
            if (skip > 0) {
                this.append(START, 0, next);
            }
            this.start = 0;
            skip = 0;
            if (octet != START[0]) continue;
            ++this.start;
        }
        int total = off - mark;
        excess = this.seek + this.start;
        int valid = total - excess;
        if (valid > 0) {
            this.append(array, mark, valid);
        }
        return 0;
    }

    protected Buffer allocate() throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate();
        }
        return this.buffer;
    }

    public String toString() {
        return this.segment.toString();
    }
}

