/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import javax.annotation.Nullable;
import org.gradle.cache.CacheDecorator;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Serializer;

public class PersistentIndexedCacheParameters<K, V> {
    private static final BaseSerializerFactory SERIALIZER_FACTORY = new BaseSerializerFactory();
    private final String cacheName;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private CacheDecorator cacheDecorator;

    public PersistentIndexedCacheParameters(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.cacheName = cacheName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public static <K, V> PersistentIndexedCacheParameters<K, V> of(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new PersistentIndexedCacheParameters<K, V>(cacheName, keySerializer, valueSerializer);
    }

    public PersistentIndexedCacheParameters(String cacheName, Class<K> keyType, Serializer<V> valueSerializer) {
        this(cacheName, SERIALIZER_FACTORY.getSerializerFor(keyType), valueSerializer);
    }

    public PersistentIndexedCacheParameters(String cacheName, Class<K> keyType, Class<V> valueType) {
        this(cacheName, keyType, SERIALIZER_FACTORY.getSerializerFor(valueType));
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Nullable
    public CacheDecorator getCacheDecorator() {
        return this.cacheDecorator;
    }

    public PersistentIndexedCacheParameters<K, V> cacheDecorator(CacheDecorator cacheDecorator) {
        assert (cacheDecorator != null);
        this.cacheDecorator = cacheDecorator;
        return this;
    }
}

