/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.symbols.JsSymbolBuilder;
import org.jetbrains.kotlin.ir.backend.js.symbols.SymbolBuilderKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrSymbolBase;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003?@AB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J6\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130&2\u0006\u0010'\u001a\u00020\u00182\u001e\u0010(\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0&\u0012\u0004\u0012\u00020,0*0)H\u0002J.\u0010-\u001a\b\u0012\u0004\u0012\u00020.0&2\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u0002022\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0010\u00103\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u000206H\u0016J\u001e\u00107\u001a\b\u0012\u0004\u0012\u00020\u00130&2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u00108\u001a\u000209H\u0002J\u001e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00130&2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\rH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "callableNameConst", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "callableToGetterFunction", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceKey;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "collectedReferenceMap", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getterConst", "newDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "setterConst", "buildClosureFunction", "declaration", "refGetFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "reference", "buildClosures", "", "buildGetFunction", "getterName", "createClosureInstanceName", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "createFunctionClosureGetterName", "createHelperFunctionName", "suffix", "createPropertyClosureGetterName", "generateGetterBodyWithGuard", "", "getterFunction", "builder", "Lkotlin/Function0;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "generateSignatureForClosure", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "callable", "getter", "closure", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getReferenceName", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerKFunctionReference", "functionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "lowerKPropertyReference", "getterDeclaration", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "makeCallableKey", "CallableReferenceCollector", "CallableReferenceKey", "CallableReferenceTransformer", "backend.js"})
public final class CallableReferenceLowering
implements FileLoweringPass {
    private final Map<CallableReferenceKey, IrFunction> callableToGetterFunction;
    private final Map<CallableReferenceKey, IrCallableReference> collectedReferenceMap;
    private final IrConstImpl<String> callableNameConst;
    private final IrConstImpl<String> getterConst;
    private final IrConstImpl<String> setterConst;
    private final List<IrDeclaration> newDeclarations;
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementVisitorVoidKt.acceptVoid(irFile, new CallableReferenceCollector());
        this.buildClosures();
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new CallableReferenceTransformer());
        Collection collection = irFile.getDeclarations();
        Iterable iterable = this.newDeclarations;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }

    private final CallableReferenceKey makeCallableKey(IrFunction declaration, IrCallableReference reference) {
        return new CallableReferenceKey(declaration, reference.getDispatchReceiver() != null, reference.getExtensionReceiver() != null);
    }

    private final void buildClosures() {
        for (IrCallableReference v : this.collectedReferenceMap.values()) {
            Collection collection = this.newDeclarations;
            Iterable iterable = (Iterable)v.accept(new IrElementVisitor(this){
                final /* synthetic */ CallableReferenceLowering this$0;

                @NotNull
                public Void visitElement(@NotNull IrElement element, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    String string = "Unreachable execution";
                    throw (Throwable)new IllegalStateException(string.toString());
                }

                @NotNull
                public List<IrDeclaration> visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return CallableReferenceLowering.access$lowerKFunctionReference(this.this$0, expression2.getSymbol().getOwner(), expression2);
                }

                @NotNull
                public List<IrDeclaration> visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrFunctionSymbol irFunctionSymbol = expression2.getGetter();
                    if (irFunctionSymbol == null) {
                        Intrinsics.throwNpe();
                    }
                    return CallableReferenceLowering.access$lowerKPropertyReference(this.this$0, irFunctionSymbol.getOwner(), expression2);
                }
                {
                    this.this$0 = $outer;
                }

                @NotNull
                public List<IrDeclaration> visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    return (List)IrElementVisitor.DefaultImpls.visitBlockBody(this, body, data);
                }

                @NotNull
                public List<IrDeclaration> visitBody(@NotNull IrBody body, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    return (List)IrElementVisitor.DefaultImpls.visitBody(this, body, data);
                }

                @NotNull
                public List<IrDeclaration> visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                    return (List)IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
                }

                @NotNull
                public List<IrDeclaration> visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    return (List)IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
                }

                @NotNull
                public List<IrDeclaration> visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    return (List)IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                @NotNull
                public List<IrDeclaration> visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                    return (List)IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
                }

                @NotNull
                public List<IrDeclaration> visitClass(@NotNull IrClass declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitClass(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
                }

                @NotNull
                public <T> List<IrDeclaration> visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    return (List)IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
                }

                @NotNull
                public List<IrDeclaration> visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    return (List)IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                @NotNull
                public List<IrDeclaration> visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                    return (List)IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
                }

                @NotNull
                public List<IrDeclaration> visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    return (List)IrElementVisitor.DefaultImpls.visitExpressionBody(this, body, data);
                }

                @NotNull
                public List<IrDeclaration> visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitField(@NotNull IrField declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitField(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitFile(@NotNull IrFile declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitFile(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitFunction(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    return (List)IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data);
                }

                @NotNull
                public List<IrDeclaration> visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitSetVariable(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                    return (List)IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                @NotNull
                public List<IrDeclaration> visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    return (List)IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body, data);
                }

                @NotNull
                public List<IrDeclaration> visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                    return (List)IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
                }

                @NotNull
                public List<IrDeclaration> visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return (List)IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data);
                }

                @NotNull
                public List<IrDeclaration> visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    return (List)IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
                }

                @NotNull
                public List<IrDeclaration> visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    return (List)IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            }, null);
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
    }

    private final String createFunctionClosureGetterName(CallableDescriptor descriptor2) {
        return this.createHelperFunctionName(descriptor2, "KReferenceGet");
    }

    private final String createPropertyClosureGetterName(CallableDescriptor descriptor2) {
        return this.createHelperFunctionName(descriptor2, "KPropertyGet");
    }

    private final String createClosureInstanceName(CallableDescriptor descriptor2) {
        return this.createHelperFunctionName(descriptor2, "KReferenceClosure");
    }

    private final String createHelperFunctionName(CallableDescriptor descriptor2, String suffix) {
        StringBuilder nameBuilder = new StringBuilder();
        if (descriptor2 instanceof ClassConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ClassConstructorDescriptor)descriptor2).getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"descriptor.constructedClass");
            nameBuilder.append(DescriptorUtilsKt.getFqNameSafe(classDescriptor));
            nameBuilder.append('_');
        }
        nameBuilder.append(descriptor2.getName());
        nameBuilder.append('_');
        nameBuilder.append(suffix);
        String string = nameBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nameBuilder.toString()");
        return string;
    }

    private final String getReferenceName(CallableDescriptor descriptor2) {
        if (descriptor2 instanceof ClassConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ClassConstructorDescriptor)descriptor2).getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"descriptor.constructedClass");
            Name name = classDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.constructedClass.name");
            String string = name.getIdentifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.constructedClass.name.identifier");
            return string;
        }
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.name");
        String string = name.getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name.identifier");
        return string;
    }

    private final List<IrDeclaration> lowerKFunctionReference(IrFunction declaration, IrFunctionReference functionReference) {
        IrSimpleFunction refGetFunction = this.buildGetFunction(declaration, functionReference, this.createFunctionClosureGetterName(declaration.getDescriptor()));
        IrFunction refClosureFunction = this.buildClosureFunction(declaration, refGetFunction, functionReference);
        List<IrDeclaration> additionalDeclarations2 = this.generateGetterBodyWithGuard(refGetFunction, (Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>)((Function0)new Function0<Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>(this, functionReference, refClosureFunction, refGetFunction, declaration){
            final /* synthetic */ CallableReferenceLowering this$0;
            final /* synthetic */ IrFunctionReference $functionReference;
            final /* synthetic */ IrFunction $refClosureFunction;
            final /* synthetic */ IrSimpleFunction $refGetFunction;
            final /* synthetic */ IrFunction $declaration;

            @NotNull
            public final Pair<List<IrStatement>, IrValueSymbol> invoke() {
                IrCallImpl irCallImpl;
                IrFunctionReferenceImpl irClosureReference = JsIrBuilder.INSTANCE.buildFunctionReference(this.$functionReference.getType(), this.$refClosureFunction.getSymbol());
                IrVariableSymbolImpl irVarSymbol = JsSymbolBuilder.buildTempVar$default(JsSymbolBuilder.INSTANCE, this.$refGetFunction.getSymbol(), irClosureReference.getType(), null, false, 12, null);
                IrVariableImpl irVar = JsIrBuilder.INSTANCE.buildVar(irVarSymbol, irClosureReference);
                IrCallImpl $receiver = irCallImpl = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                $receiver.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                $receiver.putValueArgument(1, CallableReferenceLowering.access$getCallableNameConst$p(this.this$0));
                $receiver.putValueArgument(2, JsIrBuilder.INSTANCE.buildString(this.this$0.getContext().getIrBuiltIns().getString(), CallableReferenceLowering.access$getReferenceName(this.this$0, this.$declaration.getDescriptor())));
                IrCallImpl irSetName = irCallImpl;
                return new Pair((Object)CollectionsKt.listOf((Object[])new IrElement[]{irVar, irSetName}), (Object)irVarSymbol);
            }
            {
                this.this$0 = callableReferenceLowering;
                this.$functionReference = irFunctionReference;
                this.$refClosureFunction = irFunction;
                this.$refGetFunction = irSimpleFunction;
                this.$declaration = irFunction2;
                super(0);
            }
        }));
        Map<CallableReferenceKey, IrFunction> map2 = this.callableToGetterFunction;
        CallableReferenceKey callableReferenceKey = this.makeCallableKey(declaration, functionReference);
        IrSimpleFunction irSimpleFunction = refGetFunction;
        map2.put(callableReferenceKey, irSimpleFunction);
        return CollectionsKt.plus((Collection)additionalDeclarations2, (Iterable)CollectionsKt.listOf((Object)refGetFunction));
    }

    private final List<IrDeclaration> lowerKPropertyReference(IrFunction getterDeclaration, IrPropertyReference propertyReference) {
        IrFunction irFunction;
        IrFunction irFunction2;
        IrFunctionSymbol it;
        String getterName = this.createPropertyClosureGetterName(propertyReference.getDescriptor());
        IrFunctionSymbol irFunctionSymbol = propertyReference.getGetter();
        if (irFunctionSymbol == null) {
            Intrinsics.throwNpe();
        }
        IrSimpleFunction refGetFunction = this.buildGetFunction(irFunctionSymbol.getOwner(), propertyReference, getterName);
        IrFunctionSymbol irFunctionSymbol2 = propertyReference.getGetter();
        if (irFunctionSymbol2 != null) {
            IrFunctionSymbol irFunctionSymbol3;
            it = irFunctionSymbol3 = irFunctionSymbol2;
            irFunction2 = this.buildClosureFunction(it.getOwner(), refGetFunction, propertyReference);
        } else {
            irFunction2 = null;
        }
        if (irFunction2 == null) {
            Intrinsics.throwNpe();
        }
        IrFunction getterFunction = irFunction2;
        IrFunctionSymbol irFunctionSymbol4 = propertyReference.getSetter();
        if (irFunctionSymbol4 != null) {
            IrFunctionSymbol it2 = it = irFunctionSymbol4;
            irFunction = this.buildClosureFunction(it2.getOwner(), refGetFunction, propertyReference);
        } else {
            irFunction = null;
        }
        IrFunction setterFunction = irFunction;
        List<IrDeclaration> additionalDeclarations2 = this.generateGetterBodyWithGuard(refGetFunction, (Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>)((Function0)new Function0<Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>>(this, getterFunction, refGetFunction, setterFunction, propertyReference){
            final /* synthetic */ CallableReferenceLowering this$0;
            final /* synthetic */ IrFunction $getterFunction;
            final /* synthetic */ IrSimpleFunction $refGetFunction;
            final /* synthetic */ IrFunction $setterFunction;
            final /* synthetic */ IrPropertyReference $propertyReference;

            @NotNull
            public final Pair<List<IrStatement>, IrValueSymbol> invoke() {
                ClassDescriptor getterFunctionType;
                List statements = new ArrayList<E>();
                ClassDescriptor classDescriptor = getterFunctionType = this.this$0.getContext().getBuiltIns().getFunction(this.$getterFunction.getValueParameters().size() + 1);
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"getterFunctionType");
                SimpleType simpleType2 = classDescriptor.getDefaultType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"getterFunctionType.defaultType");
                IrFunctionReferenceImpl irGetReference = JsIrBuilder.INSTANCE.buildFunctionReference(simpleType2, this.$getterFunction.getSymbol());
                IrSymbol irSymbol = this.$refGetFunction.getSymbol();
                SimpleType simpleType3 = getterFunctionType.getDefaultType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"getterFunctionType.defaultType");
                IrVariableSymbolImpl irVarSymbol = JsSymbolBuilder.buildTempVar$default(JsSymbolBuilder.INSTANCE, irSymbol, (KotlinType)simpleType3, null, false, 12, null);
                Collection collection = statements;
                IrElementBase irElementBase = JsIrBuilder.INSTANCE.buildVar(irVarSymbol, irGetReference);
                collection.add(irElementBase);
                collection = statements;
                irElementBase = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                Object $receiver = irElementBase;
                ((IrCallWithIndexedArgumentsBase)$receiver).putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                ((IrCallWithIndexedArgumentsBase)$receiver).putValueArgument(1, CallableReferenceLowering.access$getGetterConst$p(this.this$0));
                ((IrCallWithIndexedArgumentsBase)$receiver).putValueArgument(2, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                collection.add(irElementBase);
                if (this.$setterFunction != null) {
                    IrCallImpl $i$a$1$apply;
                    ClassDescriptor setterFunctionType;
                    ClassDescriptor classDescriptor2 = setterFunctionType = this.this$0.getContext().getBuiltIns().getFunction(this.$setterFunction.getValueParameters().size() + 1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"setterFunctionType");
                    SimpleType simpleType4 = classDescriptor2.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"setterFunctionType.defaultType");
                    IrFunctionReferenceImpl irSetReference = JsIrBuilder.INSTANCE.buildFunctionReference(simpleType4, this.$setterFunction.getSymbol());
                    $receiver = statements;
                    IrCallImpl $receiver2 = $i$a$1$apply = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                    $receiver2.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                    $receiver2.putValueArgument(1, CallableReferenceLowering.access$getSetterConst$p(this.this$0));
                    $receiver2.putValueArgument(2, irSetReference);
                    $receiver.add($i$a$1$apply);
                }
                collection = statements;
                irElementBase = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsSetJSField().getSymbol(), null, null, 6, null);
                $receiver = irElementBase;
                ((IrCallWithIndexedArgumentsBase)$receiver).putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irVarSymbol));
                ((IrCallWithIndexedArgumentsBase)$receiver).putValueArgument(1, CallableReferenceLowering.access$getCallableNameConst$p(this.this$0));
                ((IrCallWithIndexedArgumentsBase)$receiver).putValueArgument(2, JsIrBuilder.INSTANCE.buildString(this.this$0.getContext().getIrBuiltIns().getString(), CallableReferenceLowering.access$getReferenceName(this.this$0, this.$propertyReference.getDescriptor())));
                collection.add(irElementBase);
                return new Pair((Object)statements, (Object)irVarSymbol);
            }
            {
                this.this$0 = callableReferenceLowering;
                this.$getterFunction = irFunction;
                this.$refGetFunction = irSimpleFunction;
                this.$setterFunction = irFunction2;
                this.$propertyReference = irPropertyReference;
                super(0);
            }
        }));
        Map<CallableReferenceKey, IrFunction> map2 = this.callableToGetterFunction;
        CallableReferenceKey callableReferenceKey = this.makeCallableKey(getterDeclaration, propertyReference);
        IrSimpleFunction irSimpleFunction = refGetFunction;
        map2.put(callableReferenceKey, irSimpleFunction);
        return CollectionsKt.plus((Collection)additionalDeclarations2, (Iterable)CollectionsKt.listOf((Object)refGetFunction));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> generateGetterBodyWithGuard(IrSimpleFunction getterFunction, Function0<? extends Pair<? extends List<? extends IrStatement>, ? extends IrValueSymbol>> builder) {
        Collection collection;
        List returnStatements;
        IrExpression returnValue2;
        void bodyStatements;
        Pair pair = (Pair)builder.invoke();
        List list2 = (List)pair.component1();
        IrValueSymbol varSymbol = (IrValueSymbol)pair.component2();
        List statements = new ArrayList();
        if (getterFunction.getValueParameters().isEmpty()) {
            List $i$a$1$apply;
            IrCallImpl irCallImpl;
            String cacheName = getterFunction.getName() + '_' + Namer.INSTANCE.getKCALLABLE_CACHE_SUFFIX();
            DeclarationDescriptor declarationDescriptor = getterFunction.getDescriptor().getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"getterFunction.descriptor.containingDeclaration");
            IrVariableSymbolImpl cacheVarSymbol = JsSymbolBuilder.INSTANCE.buildVar(declarationDescriptor, getterFunction.getReturnType(), cacheName, true);
            KotlinType kotlinType = ((VariableDescriptor)cacheVarSymbol.getDescriptor()).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"cacheVarSymbol.descriptor.type");
            IrConstImpl irNull = JsIrBuilder.INSTANCE.buildNull(kotlinType);
            IrVariableImpl irCacheDeclaration = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, cacheVarSymbol, null, 2, null);
            IrGetValueImpl irCacheValue = JsIrBuilder.INSTANCE.buildGetValue(cacheVarSymbol);
            IrCallImpl $receiver = irCallImpl = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getEqeqSymbol(), null, null, 6, null);
            $receiver.putValueArgument(0, irCacheValue);
            $receiver.putValueArgument(1, irNull);
            IrCallImpl irIfCondition = irCallImpl;
            IrSetVariableImpl irSetCache = JsIrBuilder.INSTANCE.buildSetVariable(cacheVarSymbol, JsIrBuilder.INSTANCE.buildGetValue(varSymbol));
            List $receiver2 = $i$a$1$apply = (List)new ArrayList();
            $receiver2.addAll((Collection)bodyStatements);
            $receiver2.add(irSetCache);
            List thenStatements = $i$a$1$apply;
            IrBlockImpl irThenBranch = JsIrBuilder.INSTANCE.buildBlock(this.context.getIrBuiltIns().getUnit(), thenStatements);
            IrIfThenElseImpl irIfNode = JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.context.getIrBuiltIns().getUnit(), irIfCondition, irThenBranch, null, 8, null);
            Collection collection2 = statements;
            collection2.add(irIfNode);
            returnValue2 = irCacheValue;
            returnStatements = CollectionsKt.listOf((Object)irCacheDeclaration);
        } else {
            collection = statements;
            CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)bodyStatements));
            returnValue2 = JsIrBuilder.INSTANCE.buildGetValue(varSymbol);
            returnStatements = CollectionsKt.emptyList();
        }
        collection = statements;
        IrReturnImpl irReturnImpl = JsIrBuilder.INSTANCE.buildReturn(getterFunction.getSymbol(), returnValue2);
        collection.add(irReturnImpl);
        getterFunction.setBody(JsIrBuilder.INSTANCE.buildBlockBody(statements));
        return returnStatements;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrValueParameterSymbol> generateSignatureForClosure(IrFunction callable, IrFunction getter2, IrSimpleFunctionSymbol closure, IrCallableReference reference) {
        List result2 = new ArrayList();
        if (callable.getDispatchReceiverParameter() != null && reference.getDispatchReceiver() == null) {
            int n = result2.size();
            IrValueParameter irValueParameter = callable.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            result2.add(JsSymbolBuilder.buildValueParameter$default(JsSymbolBuilder.INSTANCE, closure, n, irValueParameter.getType(), null, 8, null));
        }
        if (callable.getExtensionReceiverParameter() != null && reference.getExtensionReceiver() == null) {
            int n = result2.size();
            IrValueParameter irValueParameter = callable.getExtensionReceiverParameter();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            result2.add(JsSymbolBuilder.buildValueParameter$default(JsSymbolBuilder.INSTANCE, closure, n, irValueParameter.getType(), null, 8, null));
        }
        int n = getter2.getValueParameters().size();
        int n2 = callable.getValueParameters().size();
        while (n < n2) {
            void i;
            IrValueParameter param = callable.getValueParameters().get((int)i);
            Object object = param.getName();
            Object $receiver = object;
            String paramName = !((Name)$receiver).isSpecial() ? ((Name)$receiver).getIdentifier() : null;
            object = result2;
            IrValueParameterSymbolImpl irValueParameterSymbolImpl = JsSymbolBuilder.INSTANCE.buildValueParameter(closure, result2.size(), param.getType(), paramName);
            object.add(irValueParameterSymbolImpl);
            ++i;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction buildGetFunction(IrFunction declaration, IrCallableReference reference, String getterName) {
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv22;
        Object object;
        IrValueParameter irValueParameter;
        Collection collection2;
        boolean bl;
        KotlinType callableType = reference.getType();
        List closureParams = CollectionsKt.dropLast(callableType.getArguments(), (int)1);
        int kFunctionValueParamsCount = closureParams.size();
        if (declaration.getDispatchReceiverParameter() != null && reference.getDispatchReceiver() == null) {
            --kFunctionValueParamsCount;
        }
        if (declaration.getExtensionReceiverParameter() != null && reference.getExtensionReceiver() == null) {
            --kFunctionValueParamsCount;
        }
        boolean bl2 = bl = kFunctionValueParamsCount >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List receivers = new ArrayList();
        if (reference.getDispatchReceiver() != null) {
            collection2 = receivers;
            IrValueParameter irValueParameter2 = declaration.getDispatchReceiverParameter();
            if (irValueParameter2 == null) {
                Intrinsics.throwNpe();
            }
            irValueParameter = irValueParameter2;
            collection2.add(irValueParameter);
        }
        if (reference.getExtensionReceiver() != null) {
            collection2 = receivers;
            IrValueParameter irValueParameter3 = declaration.getExtensionReceiverParameter();
            if (irValueParameter3 == null) {
                Intrinsics.throwNpe();
            }
            irValueParameter = irValueParameter3;
            collection2.add(irValueParameter);
        }
        List getterValueParameters = CollectionsKt.plus((Collection)receivers, (Iterable)CollectionsKt.dropLast(declaration.getValueParameters(), (int)kFunctionValueParamsCount));
        DeclarationDescriptor declarationDescriptor = declaration.getDescriptor().getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"declaration.descriptor.containingDeclaration");
        Object $receiver = object = JsSymbolBuilder.buildSimpleFunction$default(JsSymbolBuilder.INSTANCE, declarationDescriptor, getterName, null, null, null, 28, null);
        Iterable iterable = getterValueParameters;
        List list2 = null;
        ReceiverParameterDescriptor receiverParameterDescriptor = null;
        Collection collection3 = null;
        Object object2 = (IrSimpleFunctionSymbol)$receiver;
        void var17_21 = $receiver$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv22, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void i;
            void p;
            int n = index$iv$iv++;
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            ValueParameterDescriptor valueParameterDescriptor = LowerUtilsKt.copyAsValueParameter(p.getDescriptor(), (CallableDescriptor)((IrSymbolBase)$receiver).getDescriptor(), (int)i);
            collection.add(valueParameterDescriptor);
        }
        collection = (List)destination$iv$iv;
        SymbolBuilderKt.initialize$default((IrSimpleFunctionSymbol)object2, collection3, receiverParameterDescriptor, list2, (List)collection, callableType, null, null, 103, null);
        IrSimpleFunctionSymbolImpl refGetSymbol = object;
        $receiver = object = JsIrBuilder.INSTANCE.buildFunction(refGetSymbol);
        int $receiver$iv22 = 0;
        int n = getterValueParameters.size();
        while ($receiver$iv22 < n) {
            void i;
            IrValueParameter p = (IrValueParameter)getterValueParameters.get((int)i);
            collection3 = ((IrFunctionBase)$receiver).getValueParameters();
            int n3 = p.getStartOffset();
            int n4 = p.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = p.getOrigin();
            ValueParameterDescriptor valueParameterDescriptor = ((FunctionDescriptor)refGetSymbol.getDescriptor()).getValueParameters().get((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"refGetSymbol.descriptor.valueParameters[i]");
            object2 = new IrValueParameterImpl(n3, n4, irDeclarationOrigin, valueParameterDescriptor);
            collection3.add(object2);
            ++i;
        }
        return (IrSimpleFunction)object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction buildClosureFunction(IrFunction declaration, IrSimpleFunction refGetFunction, IrCallableReference reference) {
        int i;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        String closureName = this.createClosureInstanceName(declaration.getDescriptor());
        IrSimpleFunctionSymbolImpl refClosureSymbol = JsSymbolBuilder.buildSimpleFunction$default(JsSymbolBuilder.INSTANCE, refGetFunction.getDescriptor(), closureName, null, null, null, 28, null);
        List<IrValueParameterSymbol> closureParamSymbols = this.generateSignatureForClosure(declaration, refGetFunction, refClosureSymbol, reference);
        Iterable iterable = $receiver$iv = (Iterable)closureParamSymbols;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            IrValueParameterSymbol irValueParameterSymbol = (IrValueParameterSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object d = it.getDescriptor();
            if (d == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ValueParameterDescriptor");
            }
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)d;
            collection.add(valueParameterDescriptor);
        }
        List closureParamDescriptors = (List)destination$iv$iv;
        SymbolBuilderKt.initialize$default(refClosureSymbol, null, null, null, closureParamDescriptors, declaration.getReturnType(), null, null, 103, null);
        IrFunctionImpl closureFunction = JsIrBuilder.INSTANCE.buildFunction(refClosureSymbol);
        for (IrValueParameterSymbol it : closureParamSymbols) {
            Object item$iv$iv;
            Collection collection = closureFunction.getValueParameters();
            item$iv$iv = JsIrBuilder.INSTANCE.buildValueParameter(it);
            collection.add(item$iv$iv);
        }
        IrCallImpl irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, declaration.getSymbol(), null, null, 6, null);
        int cp = 0;
        int gp = 0;
        if (declaration.getDispatchReceiverParameter() != null) {
            IrValueParameterSymbol dispatchReceiverDeclaration = reference.getDispatchReceiver() != null ? (IrValueParameterSymbol)refGetFunction.getValueParameters().get(gp++).getSymbol() : closureParamSymbols.get(cp++);
            irCall.setDispatchReceiver(JsIrBuilder.INSTANCE.buildGetValue(dispatchReceiverDeclaration));
        }
        if (declaration.getExtensionReceiverParameter() != null) {
            IrValueParameterSymbol extensionReceiverDeclaration = reference.getExtensionReceiver() != null ? (IrValueParameterSymbol)refGetFunction.getValueParameters().get(gp++).getSymbol() : closureParamSymbols.get(cp++);
            irCall.setExtensionReceiver(JsIrBuilder.INSTANCE.buildGetValue(extensionReceiverDeclaration));
        }
        int j = 0;
        int it = gp;
        int n = refGetFunction.getValueParameters().size();
        while (it < n) {
            irCall.putValueArgument(j++, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)refGetFunction.getValueParameters().get(i).getSymbol()));
            ++i;
        }
        n = closureParamSymbols.size();
        for (i = cp; i < n; ++i) {
            irCall.putValueArgument(j++, JsIrBuilder.INSTANCE.buildGetValue(closureParamSymbols.get(i)));
        }
        IrReturnImpl irClosureReturn = JsIrBuilder.INSTANCE.buildReturn(closureFunction.getSymbol(), irCall);
        closureFunction.setBody(JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.listOf((Object)irClosureReturn)));
        return closureFunction;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public CallableReferenceLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        CallableReferenceLowering callableReferenceLowering = this;
        Object object = new LinkedHashMap();
        callableReferenceLowering.callableToGetterFunction = object;
        callableReferenceLowering = this;
        object = new LinkedHashMap();
        callableReferenceLowering.collectedReferenceMap = object;
        this.callableNameConst = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getString(), Namer.INSTANCE.getKCALLABLE_NAME());
        this.getterConst = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getString(), Namer.INSTANCE.getKPROPERTY_GET());
        this.setterConst = JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getString(), Namer.INSTANCE.getKPROPERTY_SET());
        callableReferenceLowering = this;
        callableReferenceLowering.newDeclarations = object = (List)new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ List access$lowerKFunctionReference(CallableReferenceLowering $this, @NotNull IrFunction declaration, @NotNull IrFunctionReference functionReference) {
        return $this.lowerKFunctionReference(declaration, functionReference);
    }

    @NotNull
    public static final /* synthetic */ List access$lowerKPropertyReference(CallableReferenceLowering $this, @NotNull IrFunction getterDeclaration, @NotNull IrPropertyReference propertyReference) {
        return $this.lowerKPropertyReference(getterDeclaration, propertyReference);
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getCallableNameConst$p(CallableReferenceLowering $this) {
        return $this.callableNameConst;
    }

    @NotNull
    public static final /* synthetic */ String access$getReferenceName(CallableReferenceLowering $this, @NotNull CallableDescriptor descriptor2) {
        return $this.getReferenceName(descriptor2);
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getGetterConst$p(CallableReferenceLowering $this) {
        return $this.getterConst;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getSetterConst$p(CallableReferenceLowering $this) {
        return $this.setterConst;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceKey;", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "hasDispatchReference", "", "hasExtensionReceiver", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;ZZ)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getHasDispatchReference", "()Z", "getHasExtensionReceiver", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "backend.js"})
    private static final class CallableReferenceKey {
        @NotNull
        private final IrFunction declaration;
        private final boolean hasDispatchReference;
        private final boolean hasExtensionReceiver;

        @NotNull
        public final IrFunction getDeclaration() {
            return this.declaration;
        }

        public final boolean getHasDispatchReference() {
            return this.hasDispatchReference;
        }

        public final boolean getHasExtensionReceiver() {
            return this.hasExtensionReceiver;
        }

        public CallableReferenceKey(@NotNull IrFunction declaration, boolean hasDispatchReference, boolean hasExtensionReceiver) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            this.declaration = declaration;
            this.hasDispatchReference = hasDispatchReference;
            this.hasExtensionReceiver = hasExtensionReceiver;
        }

        @NotNull
        public final IrFunction component1() {
            return this.declaration;
        }

        public final boolean component2() {
            return this.hasDispatchReference;
        }

        public final boolean component3() {
            return this.hasExtensionReceiver;
        }

        @NotNull
        public final CallableReferenceKey copy(@NotNull IrFunction declaration, boolean hasDispatchReference, boolean hasExtensionReceiver) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return new CallableReferenceKey(declaration, hasDispatchReference, hasExtensionReceiver);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CallableReferenceKey copy$default(CallableReferenceKey callableReferenceKey, IrFunction irFunction, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                irFunction = callableReferenceKey.declaration;
            }
            if ((n & 2) != 0) {
                bl = callableReferenceKey.hasDispatchReference;
            }
            if ((n & 4) != 0) {
                bl2 = callableReferenceKey.hasExtensionReceiver;
            }
            return callableReferenceKey.copy(irFunction, bl, bl2);
        }

        public String toString() {
            return "CallableReferenceKey(declaration=" + this.declaration + ", hasDispatchReference=" + this.hasDispatchReference + ", hasExtensionReceiver=" + this.hasExtensionReceiver + ")";
        }

        public int hashCode() {
            IrFunction irFunction = this.declaration;
            int n = (irFunction != null ? irFunction.hashCode() : 0) * 31;
            int n2 = this.hasDispatchReference ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.hasExtensionReceiver ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CallableReferenceKey)) break block3;
                    CallableReferenceKey callableReferenceKey = (CallableReferenceKey)object;
                    if (!Intrinsics.areEqual((Object)this.declaration, (Object)callableReferenceKey.declaration) || !(this.hasDispatchReference == callableReferenceKey.hasDispatchReference) || !(this.hasExtensionReceiver == callableReferenceKey.hasExtensionReceiver)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceCollector;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFunctionReference", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "backend.js"})
    public final class CallableReferenceCollector
    implements IrElementVisitorVoid {
        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Map map2 = CallableReferenceLowering.this.collectedReferenceMap;
            CallableReferenceKey callableReferenceKey = CallableReferenceLowering.this.makeCallableKey(expression2.getSymbol().getOwner(), expression2);
            IrFunctionReference irFunctionReference = expression2;
            map2.put(callableReferenceKey, irFunctionReference);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Map map2 = CallableReferenceLowering.this.collectedReferenceMap;
            IrFunctionSymbol irFunctionSymbol = expression2.getGetter();
            if (irFunctionSymbol == null) {
                Intrinsics.throwNpe();
            }
            CallableReferenceKey callableReferenceKey = CallableReferenceLowering.this.makeCallableKey(irFunctionSymbol.getOwner(), expression2);
            IrPropertyReference irPropertyReference = expression2;
            map2.put(callableReferenceKey, irPropertyReference);
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
        }

        @Override
        public void visitBody(@NotNull IrBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;)V", "redirectToFunction", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "callable", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "newTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "backend.js"})
    public final class CallableReferenceTransformer
    extends IrElementTransformerVoid {
        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            IrFunction irFunction;
            IrFunction it;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrStatement irStatement = (IrFunction)CallableReferenceLowering.this.callableToGetterFunction.get(CallableReferenceLowering.this.makeCallableKey(expression2.getSymbol().getOwner(), expression2));
            return irStatement != null && (irStatement = this.redirectToFunction(expression2, it = (irFunction = irStatement))) != null ? (IrExpression)irStatement : (IrExpression)expression2;
        }

        @Override
        @NotNull
        public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2) {
            IrFunction irFunction;
            IrFunction it;
            IrStatement irStatement;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Map map2 = CallableReferenceLowering.this.callableToGetterFunction;
            IrFunctionSymbol irFunctionSymbol = expression2.getGetter();
            if (irFunctionSymbol == null) {
                Intrinsics.throwNpe();
            }
            return (irStatement = (IrFunction)map2.get(CallableReferenceLowering.this.makeCallableKey(irFunctionSymbol.getOwner(), expression2))) != null && (irStatement = this.redirectToFunction(expression2, it = (irFunction = irStatement))) != null ? (IrExpression)irStatement : (IrExpression)expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrCallImpl redirectToFunction(IrCallableReference callable, IrFunction newTarget) {
            int n;
            IrExpression it;
            IrExpression irExpression;
            IrCallImpl irCallImpl;
            IrCallImpl $receiver = irCallImpl = new IrCallImpl(callable.getStartOffset(), callable.getEndOffset(), newTarget.getSymbol(), callable.getOrigin());
            IrMemberAccessExpressionKt.copyTypeArgumentsFrom((IrMemberAccessExpression)$receiver, callable);
            int index2 = 0;
            IrExpression irExpression2 = callable.getDispatchReceiver();
            if (irExpression2 != null) {
                it = irExpression = irExpression2;
                n = index2;
                index2 = n + 1;
                $receiver.putValueArgument(n, it);
            }
            IrExpression irExpression3 = callable.getExtensionReceiver();
            if (irExpression3 != null) {
                it = irExpression = irExpression3;
                n = index2;
                index2 = n + 1;
                $receiver.putValueArgument(n, it);
            }
            int n2 = 0;
            int n3 = callable.getValueArgumentsCount();
            while (n2 < n3) {
                void i;
                IrExpression arg = callable.getValueArgument((int)i);
                if (arg != null) {
                    int n4 = index2;
                    index2 = n4 + 1;
                    $receiver.putValueArgument(n4, arg);
                }
                ++i;
            }
            return irCallImpl;
        }
    }
}

