/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.util.ArrayList;
import java.util.Iterator;
import megamek.client.bot.CEntity;
import megamek.client.bot.MoveOption;
import megamek.client.bot.TestBot;
import megamek.client.bot.ga.Chromosome;
import megamek.client.bot.ga.GA;
import megamek.common.Compute;
import megamek.common.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GALance
extends GA {
    protected ArrayList<MoveOption[]> moves;
    protected TestBot tb;
    protected Object[] enemy_array;

    public GALance(TestBot testBot, ArrayList<MoveOption[]> arrayList, int n, int n2) {
        super(arrayList.size(), n, 0.7, 0.05, n2, 0.5);
        System.gc();
        System.out.println("Generated move lance with population=" + n + " and generations=" + n2);
        this.tb = testBot;
        this.moves = arrayList;
        this.enemy_array = testBot.getEnemyEntities().toArray();
    }

    @Override
    protected void initPopulation() {
        try {
            int n;
            for (n = 0; n < this.chromosomeDim; ++n) {
                this.chromosomes[0].genes[n] = 0;
            }
            for (n = 1; n < this.populationDim; ++n) {
                for (int i = 0; i < this.chromosomeDim; ++i) {
                    this.chromosomes[n].genes[i] = Compute.randomInt(this.moves.get(i).length);
                }
                this.chromosomes[n].fitness = this.getFitness(n);
            }
        }
        catch (Exception exception) {
            System.out.println("Error occured with " + this.populationDim + " pop " + this.chromosomeDim + " chromDim");
            Iterator<MoveOption[]> iterator = this.moves.iterator();
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
        }
    }

    @Override
    protected double getFitness(int n) {
        int n2;
        Object object;
        int n3;
        MoveOption moveOption;
        Chromosome chromosome = this.chromosomes[n];
        ArrayList<MoveOption> arrayList = new ArrayList<MoveOption>();
        for (int i = 0; i < this.chromosomeDim; ++i) {
            arrayList.add(new MoveOption(this.moves.get(i)[chromosome.genes[i]]));
        }
        Object[] objectArray = arrayList.toArray();
        for (int i = 0; i < this.enemy_array.length; ++i) {
            CEntity cEntity = this.tb.centities.get((Entity)this.enemy_array[i]);
            moveOption = (MoveOption)objectArray[0];
            for (n3 = 1; n3 < objectArray.length; ++n3) {
                if (((MoveOption)objectArray[n3]).getThreat(cEntity) > moveOption.getThreat(cEntity)) {
                    moveOption = (MoveOption)objectArray[n3];
                }
                if (!(((MoveOption)(object = (MoveOption)objectArray[n3])).getThreat(cEntity) > 0.0)) continue;
                if (((MoveOption)object).getThreat(cEntity) < 0.25 * moveOption.getThreat(cEntity)) {
                    ((MoveOption)object).setThreat(cEntity, 0.0);
                    continue;
                }
                ((MoveOption)object).setThreat(cEntity, Math.pow(((MoveOption)object).getThreat(cEntity) / moveOption.getThreat(cEntity), 2.0) * ((MoveOption)object).getThreat(cEntity));
            }
        }
        double[] dArray = new double[this.enemy_array.length];
        for (int i = 0; i < objectArray.length; ++i) {
            moveOption = (MoveOption)objectArray[i];
            moveOption.threat = 0.0;
            for (n3 = 0; n3 < this.enemy_array.length; ++n3) {
                object = this.tb.centities.get((Entity)this.enemy_array[n3]);
                moveOption.threat += moveOption.getThreat((CEntity)object);
                dArray[n3] = (moveOption.getMinDamage((CEntity)object) + moveOption.getDamage((CEntity)object)) / 2.0;
            }
        }
        double d = 0.0;
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            object = (MoveOption)objectArray[n3];
            if (this.moves.get(n3).length <= 1) continue;
            MoveOption moveOption2 = this.moves.get(n3)[0];
            if (!(moveOption2.damage > 2.0 * ((MoveOption)object).damage) || !(moveOption2.getUtility() < 0.5 * ((MoveOption)object).getUtility())) continue;
            d += (double)((MoveOption)object).getCEntity().bv;
            if (n3 <= 0) continue;
            int n4 = n3;
            chromosome.genes[n4] = chromosome.genes[n4] - 1;
        }
        double d2 = 0.0;
        try {
            int n5 = 4;
            for (int i = 0; i < objectArray.length; ++i) {
                MoveOption moveOption3 = (MoveOption)objectArray[i];
                moveOption3.getUtility();
                for (int j = 0; j < objectArray.length; ++j) {
                    MoveOption moveOption4 = (MoveOption)objectArray[j];
                    if (i == j) continue;
                    int n6 = moveOption4.getFinalCoords().distance(moveOption3.getFinalCoords());
                    if (n6 > n5) {
                        d2 += Math.pow(n6 - n5, 2.0);
                        continue;
                    }
                    if (n6 > 3) continue;
                    CEntity cEntity = null;
                    for (int k = 0; k < this.enemy_array.length; ++k) {
                        CEntity cEntity2 = this.tb.centities.get((Entity)this.enemy_array[k]);
                        if (cEntity2.canMove() || moveOption3.getFinalCoords() == null || moveOption4.getFinalCoords() == null || cEntity2.current.getFinalCoords() == null || (cEntity2.current.getFinalCoords().distance(moveOption3.getFinalCoords()) != 1 || cEntity2.current.getFinalCoords().distance(moveOption4.getFinalCoords()) != 1) && (cEntity2.current.getFinalCoords().distance(moveOption3.getFinalCoords()) > 3 || cEntity2.current.getFinalCoords().distance(moveOption4.getFinalCoords()) > 3 || !cEntity2.current.getFinalProne() || moveOption3.inDanger || moveOption3.getFinalProne())) continue;
                        cEntity = cEntity2;
                    }
                    if (cEntity == null) continue;
                    if (cEntity.entity.isProne()) {
                        d2 -= (double)(cEntity.bv / 100);
                    }
                    d2 -= (double)(cEntity.bv / 50);
                    moveOption3.setDamage(cEntity, moveOption3.getDamage(cEntity) * 1.2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d3 = 0.0;
        for (n2 = 0; n2 < this.enemy_array.length; ++n2) {
            CEntity cEntity = this.tb.centities.get((Entity)this.enemy_array[n2]);
            if (dArray[n2] > cEntity.avg_armor) {
                if (dArray[n2] > 4.0 * cEntity.avg_armor) {
                    d3 += (double)(cEntity.bv / 5);
                    continue;
                }
                d3 += (double)(cEntity.bv / 50);
                continue;
            }
            if (!(dArray[n2] > 40.0)) continue;
            d3 += (1.0 - cEntity.base_psr_odds) * (double)cEntity.entity.getWeight();
        }
        if (d3 == 0.0) {
            for (n2 = 0; n2 < this.enemy_array.length; ++n2) {
                if (!(dArray[n2] > d3)) continue;
                d3 = dArray[n2];
            }
        }
        d2 /= (double)(objectArray.length * objectArray.length);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            MoveOption moveOption5 = (MoveOption)objectArray[n2];
            if (moveOption5.inDanger) {
                if (moveOption5.doomed) {
                    if (moveOption5.getCEntity().last != null && moveOption5.getCEntity().last.doomed) {
                        d -= moveOption5.damage - 0.5 * moveOption5.getUtility();
                        continue;
                    }
                    if (moveOption5.getCEntity().last != null && !moveOption5.getCEntity().last.doomed) {
                        d += moveOption5.getUtility() + 2.0 * moveOption5.damage;
                        continue;
                    }
                    d += moveOption5.getUtility();
                    continue;
                }
                if (moveOption5.getCEntity().last != null && !moveOption5.getCEntity().last.inDanger) {
                    d += moveOption5.getUtility() + moveOption5.damage;
                    continue;
                }
                d += moveOption5.getUtility();
                continue;
            }
            d += moveOption5.getUtility();
        }
        return -d + (d3 - d2);
    }

    public MoveOption getResult() {
        Chromosome chromosome = this.chromosomes[this.best];
        ArrayList<MoveOption> arrayList = new ArrayList<MoveOption>();
        for (int i = 0; i < this.chromosomeDim; ++i) {
            arrayList.add(new MoveOption(this.moves.get(i)[chromosome.genes[i]]));
        }
        Object[] objectArray = arrayList.toArray();
        MoveOption moveOption = null;
        for (int i = 0; i < objectArray.length; ++i) {
            MoveOption moveOption2 = (MoveOption)objectArray[i];
            CEntity cEntity = this.tb.centities.get(moveOption2.getEntity());
            if (cEntity.moved || moveOption != null && !(moveOption2.getUtility() < moveOption.getUtility())) continue;
            moveOption = moveOption2;
        }
        return moveOption;
    }

    @Override
    protected void doRandomMutation(int n) {
        int n2;
        Chromosome chromosome = this.chromosomes[n];
        if (chromosome.genes.length < 1) {
            return;
        }
        int n3 = n2 = chromosome.genes.length > 2 ? Compute.randomInt(chromosome.genes.length - 1) : 0;
        if (n2 % 2 == 1) {
            chromosome.genes[n2] = Compute.randomInt(this.moves.get(n2).length);
            return;
        }
        for (int i = 1; i < chromosome.genes.length; ++i) {
            int n4 = (i + n2 - 1) % (chromosome.genes.length - 1);
            if (this.moves.get(n4).length <= 1) continue;
            chromosome.genes[n4] = Compute.randomInt(this.moves.get(n4).length);
            return;
        }
    }
}

