/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;

public class TargetRoll
implements Serializable {
    private static final long serialVersionUID = -7453086182585457422L;
    public static final int IMPOSSIBLE = Integer.MAX_VALUE;
    public static final int AUTOMATIC_FAIL = 0x7FFFFFFE;
    public static final int AUTOMATIC_SUCCESS = Integer.MIN_VALUE;
    public static final int CHECK_FALSE = -2147483647;
    private ArrayList<Modifier> modifiers = new ArrayList();
    private int total;

    public TargetRoll() {
    }

    public TargetRoll(int n, String string) {
        this.addModifier(n, string);
    }

    public TargetRoll(int n, String string, boolean bl) {
        this.addModifier(n, string, bl);
    }

    public int getValue() {
        return this.total;
    }

    public String getValueAsString() {
        switch (this.total) {
            case 0x7FFFFFFF: {
                return "Impossible";
            }
            case 0x7FFFFFFE: {
                return "Automatic Failure";
            }
            case -2147483648: {
                return "Automatic Success";
            }
            case -2147483647: {
                return "Did not need to roll";
            }
        }
        return Integer.toString(this.total);
    }

    public String getDesc() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (Modifier modifier : this.modifiers) {
            if (modifier.value == Integer.MAX_VALUE || modifier.value == 0x7FFFFFFE || modifier.value == Integer.MIN_VALUE || modifier.value == -2147483647) {
                return modifier.desc;
            }
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(modifier.value < 0 ? " - " : " + ");
            }
            stringBuffer.append(Math.abs(modifier.value));
            stringBuffer.append(" (");
            stringBuffer.append(modifier.desc);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getPlainDesc() {
        return this.modifiers.get((int)0).desc;
    }

    public String getCumulativePlainDesc() {
        for (Modifier modifier : this.modifiers) {
            if (!modifier.cumulative) continue;
            return modifier.desc;
        }
        return "";
    }

    public String getLastPlainDesc() {
        Modifier modifier = this.modifiers.get(this.modifiers.size() - 1);
        return modifier.desc;
    }

    public void addModifier(int n, String string) {
        this.addModifier(new Modifier(n, string));
    }

    public void addModifier(int n, String string, boolean bl) {
        this.addModifier(new Modifier(n, string, bl));
    }

    public void addModifier(Modifier modifier) {
        if (modifier.value == -2147483647) {
            this.removeAutos(true);
        }
        this.modifiers.add(modifier);
        this.recalculate();
    }

    public void append(TargetRoll targetRoll) {
        this.append(targetRoll, true);
    }

    public void append(TargetRoll targetRoll, boolean bl) {
        if (targetRoll == null) {
            return;
        }
        for (Modifier modifier : targetRoll.modifiers) {
            if (!bl && !modifier.cumulative) continue;
            this.addModifier(modifier);
        }
    }

    public void removeAutos() {
        this.removeAutos(false);
    }

    public void removeAutos(boolean bl) {
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
        for (Modifier modifier : this.modifiers) {
            if (!bl) {
                if (modifier.value == 0x7FFFFFFE || modifier.value == Integer.MIN_VALUE) continue;
                arrayList.add(modifier);
                continue;
            }
            if (modifier.value == 0x7FFFFFFE || modifier.value == Integer.MIN_VALUE || modifier.value == Integer.MAX_VALUE) continue;
            arrayList.add(modifier);
        }
        this.modifiers = arrayList;
        this.recalculate();
    }

    private void recalculate() {
        this.total = 0;
        for (Modifier modifier : this.modifiers) {
            if (modifier.value == Integer.MAX_VALUE || modifier.value == 0x7FFFFFFE || modifier.value == Integer.MIN_VALUE || modifier.value == -2147483647) {
                this.total = modifier.value;
                break;
            }
            this.total += modifier.value;
        }
    }

    private class Modifier
    implements Serializable {
        private static final long serialVersionUID = -7228584817530534507L;
        int value;
        String desc;
        boolean cumulative = true;

        public Modifier(int n, String string) {
            this.value = n;
            this.desc = string;
        }

        public Modifier(int n, String string, boolean bl) {
            this.value = n;
            this.desc = string;
            this.cumulative = bl;
        }
    }
}

