/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MGHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 5635871269404561702L;
    private int nRapidDamHeatPerHit;

    public MGHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.damageType = Server.DamageType.ANTI_INFANTRY;
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.weapon.isRapidfire() && (!(this.target instanceof Infantry) || this.target instanceof BattleArmor)) {
            if (this.bGlancing) {
                this.nDamPerHit = (int)Math.floor((double)this.nDamPerHit / 2.0);
            }
        } else if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            this.nDamPerHit = Compute.d6(this.wtype.getDamage());
            if (this.bGlancing) {
                this.nDamPerHit = (int)Math.floor((double)this.nDamPerHit / 2.0);
            }
            if (this.bDirect) {
                this.nDamPerHit += this.toHit.getMoS() / 3;
            }
        } else {
            this.nDamPerHit = super.calcDamagePerHit();
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            float f = this.nDamPerHit;
            f = (float)((double)f * 0.75);
            this.nDamPerHit = (int)Math.floor(f);
        }
        return this.nDamPerHit;
    }

    @Override
    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE) {
            this.ae.heatBuildup = this.weapon.isRapidfire() ? (this.ae.heatBuildup += this.nRapidDamHeatPerHit) : (this.ae.heatBuildup += this.wtype.getHeat());
        }
    }

    @Override
    protected void reportMiss(Vector<Report> vector) {
        this.r = new Report(3220);
        this.r.subject = this.subjectId;
        if (this.weapon.isRapidfire()) {
            this.r.messageId = 3225;
            this.r.add(this.nDamPerHit * 3);
        }
        vector.add(this.r);
    }

    @Override
    protected void useAmmo() {
        if (this.weapon.isRapidfire()) {
            switch (this.wtype.getAmmoType()) {
                case 3: {
                    this.nDamPerHit = Compute.d6();
                    break;
                }
                case 4: {
                    this.nDamPerHit = Compute.d6() + 1;
                    break;
                }
                case 5: {
                    this.nDamPerHit = Math.max(1, Compute.d6() - 1);
                }
            }
            this.nRapidDamHeatPerHit = this.nDamPerHit;
            this.checkAmmo();
            int n = 3 * this.nRapidDamHeatPerHit;
            for (int i = 0; i < n; ++i) {
                if (this.ammo.getShotsLeft() <= 0) {
                    this.ae.loadWeapon(this.weapon);
                    this.ammo = this.weapon.getLinked();
                }
                this.ammo.setShotsLeft(this.ammo.getShotsLeft() - 1);
            }
            this.setDone();
        } else {
            super.useAmmo();
        }
    }
}

