/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.SRMHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRMFragHandler
extends SRMHandler {
    private static final long serialVersionUID = -2281133981582906299L;

    public SRMFragHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " fragmentation missile(s) ";
        this.damageType = Server.DamageType.FRAGMENTATION;
    }

    @Override
    protected int calcDamagePerHit() {
        float f = 2.0f;
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() == this.target.getTargetId()) {
            f *= (float)((BattleArmor)this.ae).getShootingStrength();
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f *= (float)this.wtype.getRackSize();
            if (this.bDirect) {
                f += (float)(this.toHit.getMoS() / 3);
            }
            if (this.bGlancing) {
                f = (int)Math.floor((double)f / 2.0);
            }
        }
        if (this.target instanceof Entity && !(this.target instanceof Infantry) || this.target instanceof BattleArmor) {
            f = 0.0f;
        }
        return (int)Math.ceil(f);
    }

    @Override
    protected void handleClearDamage(Vector<Report> vector, Building building, int n, boolean bl) {
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3385);
        this.r.indent();
        this.r.subject = this.subjectId;
        this.r.add(n *= 2);
        vector.addElement(this.r);
        if (building != null && this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, false, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 5, vector)) {
            return;
        }
        vector.addAll(this.server.tryClearHex(this.target.getPosition(), n, this.subjectId));
    }

    @Override
    protected void handleBuildingDamage(Vector<Report> vector, Building building, int n, boolean bl, Coords coords) {
    }
}

