/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import java.util.Enumeration;
import megamek.common.net.IConnection;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class TeamCommand
extends ServerCommand {
    public TeamCommand(Server server) {
        super(server, "t", "Allows players on the same team to chat with each other in the game.");
    }

    public void run(int n, String[] stringArray) {
        if (stringArray.length > 1) {
            int n2 = this.server.getPlayer(n).getTeam();
            if (n2 < 1 || n2 > 8) {
                this.server.sendServerChat(n, "You are not on a team!");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = "Team Chat[" + this.server.getPlayer(n).getName() + "]";
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(" ");
                stringBuilder.append(stringArray[i]);
            }
            Enumeration<IConnection> enumeration = this.server.getConnections();
            while (enumeration.hasMoreElements()) {
                IConnection iConnection = enumeration.nextElement();
                if (this.server.getPlayer(iConnection.getId()).getTeam() != n2) continue;
                this.server.sendChat(iConnection.getId(), string, stringBuilder.toString());
            }
        }
    }
}

