/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.J2ktIncompatible;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@GwtIncompatible(value="JUnit4")
@J2ktIncompatible
public final class Expect
extends StandardSubjectBuilder
implements TestRule {
    private final ExpectationGatherer gatherer;

    public static Expect create() {
        return new Expect(new ExpectationGatherer());
    }

    private Expect(ExpectationGatherer gatherer) {
        super(FailureMetadata.forFailureStrategy(gatherer));
        this.gatherer = (ExpectationGatherer)Preconditions.checkNotNull((Object)gatherer);
    }

    public boolean hasFailures() {
        return this.gatherer.hasFailures();
    }

    @Override
    void checkStatePreconditions() {
        this.gatherer.checkInRuleContext();
    }

    public Statement apply(final Statement base, Description description) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)description);
        return new Statement(){

            public void evaluate() throws Throwable {
                Expect.this.gatherer.enterRuleContext();
                Throwable caught = null;
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    caught = t;
                }
                finally {
                    Expect.this.gatherer.leaveRuleContext(caught);
                }
            }
        };
    }

    static enum TestPhase {
        BEFORE,
        DURING,
        AFTER;

    }

    private static final class ExpectationGatherer
    implements FailureStrategy {
        @GuardedBy(value="this")
        private final List<AssertionError> failures = new ArrayList<AssertionError>();
        @GuardedBy(value="this")
        private TestPhase inRuleContext = TestPhase.BEFORE;

        ExpectationGatherer() {
        }

        @Override
        public synchronized void fail(AssertionError failure) {
            this.record(failure);
        }

        synchronized void enterRuleContext() {
            Preconditions.checkState((this.inRuleContext == TestPhase.BEFORE ? 1 : 0) != 0);
            this.inRuleContext = TestPhase.DURING;
        }

        synchronized void leaveRuleContext(@Nullable Throwable caught) throws Throwable {
            try {
                if (caught == null) {
                    this.doLeaveRuleContext();
                } else {
                    this.doLeaveRuleContext(caught);
                }
                Preconditions.checkState((this.inRuleContext == TestPhase.DURING ? 1 : 0) != 0);
            }
            finally {
                this.inRuleContext = TestPhase.AFTER;
            }
        }

        synchronized void checkInRuleContext() {
            this.doCheckInRuleContext(null);
        }

        synchronized boolean hasFailures() {
            return !this.failures.isEmpty();
        }

        public synchronized String toString() {
            if (this.failures.isEmpty()) {
                return "No expectation failed.";
            }
            int numFailures = this.failures.size();
            StringBuilder message = new StringBuilder().append(numFailures).append(numFailures > 1 ? " expectations" : " expectation").append(" failed:\n");
            int countLength = String.valueOf(this.failures.size() + 1).length();
            int count = 0;
            for (AssertionError failure : this.failures) {
                message.append("  ");
                message.append(Strings.padStart((String)String.valueOf(++count), (int)countLength, (char)' '));
                message.append(". ");
                if (count == 1) {
                    ExpectationGatherer.appendIndented(countLength, message, Throwables.getStackTraceAsString((Throwable)((Object)failure)));
                } else {
                    ExpectationGatherer.appendIndented(countLength, message, this.printSubsequentFailure(((Throwable)((Object)this.failures.get(0))).getStackTrace(), failure));
                }
                message.append("\n");
            }
            return message.toString();
        }

        private static void appendIndented(int countLength, StringBuilder builder, String toAppend) {
            int indent = countLength + 4;
            builder.append(toAppend.replace("\n", "\n" + Strings.repeat((String)" ", (int)indent)));
        }

        private String printSubsequentFailure(StackTraceElement[] baseTraceFrames, AssertionError toPrint) {
            RuntimeException e = new RuntimeException("__EXCEPTION_MARKER__", (Throwable)((Object)toPrint));
            e.setStackTrace(baseTraceFrames);
            String s = Throwables.getStackTraceAsString((Throwable)e);
            return s.replaceFirst("(?s)^.*?__EXCEPTION_MARKER__.*?Caused by:\\s+", "");
        }

        @GuardedBy(value="this")
        private void doCheckInRuleContext(@Nullable AssertionError failure) {
            switch (this.inRuleContext) {
                case BEFORE: {
                    throw new IllegalStateException("assertion made on Expect instance, but it's not enabled as a @Rule.", (Throwable)((Object)failure));
                }
                case DURING: {
                    return;
                }
                case AFTER: {
                    throw new IllegalStateException("assertion made on Expect instance, but its @Rule has already completed. Maybe you're making assertions from a background thread and not waiting for them to complete, or maybe you've shared an Expect instance across multiple tests? We're throwing this exception to warn you that your assertion would have been ignored. However, this exception might not cause any test to fail, or it might cause some subsequent test to fail rather than the test that caused the problem.", (Throwable)((Object)failure));
                }
            }
            throw new AssertionError();
        }

        @GuardedBy(value="this")
        private void doLeaveRuleContext() {
            if (this.hasFailures()) {
                throw Truth.SimpleAssertionError.createWithNoStack(this.toString());
            }
        }

        @GuardedBy(value="this")
        private void doLeaveRuleContext(Throwable caught) throws Throwable {
            if (this.hasFailures()) {
                String message = caught instanceof AssumptionViolatedException ? "Also, after those failures, an assumption was violated:" : "Also, after those failures, an exception was thrown:";
                this.record(Truth.SimpleAssertionError.createWithNoStack(message, caught));
                throw Truth.SimpleAssertionError.createWithNoStack(this.toString());
            }
            throw caught;
        }

        @GuardedBy(value="this")
        private void record(AssertionError failure) {
            this.doCheckInRuleContext(failure);
            this.failures.add(failure);
        }
    }
}

