#include "translate.h"

static const t_unicode cp874_c1_chars[] = {
0x20AC, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2026, 0xfffd, 0xfffd, /* 0x80-0x87 */
0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,	/* 0x88-0x8F */
0xfffd, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014, /* 0x90-0x97 */
0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 0x98-0x9F */
};
struct char_set cp874_c1 = {
	1,
	CHARS(cp874_c1_chars),
	0, "", 0, 32,
};

static const t_unicode cp874_g1_chars[] = {
0x00A0, 0x0E01, 0x0E02, 0x0E03, 0x0E04, 0x0E05, 0x0E06, 0x0E07, /* 0xA0-0xA7 */
0x0E08, 0x0E09, 0x0E0A, 0x0E0B, 0x0E0C, 0x0E0D, 0x0E0E, 0x0E0F, /* 0xA8-0xAF */
0x0E10, 0x0E11, 0x0E12, 0x0E13, 0x0E14, 0x0E15, 0x0E16, 0x0E17, /* 0xB0-0xB7 */
0x0E18, 0x0E19, 0x0E1A, 0x0E1B, 0x0E1C, 0x0E1D, 0x0E1E, 0x0E1F, /* 0xB8-0xBF */
0x0E20, 0x0E21, 0x0E22, 0x0E23, 0x0E24, 0x0E25, 0x0E26, 0x0E27, /* 0xC0-0xC7 */
0x0E28, 0x0E29, 0x0E2A, 0x0E2B, 0x0E2C, 0x0E2D, 0x0E2E, 0x0E2F, /* 0xC8-0xCF */
0x0E30, 0x0E31, 0x0E32, 0x0E33, 0x0E34, 0x0E35, 0x0E36, 0x0E37, /* 0xD0-0xD7 */
0x0E38, 0x0E39, 0x0E3A, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0E3F, /* 0xD8-0xDF */
0x0E40, 0x0E41, 0x0E42, 0x0E43, 0x0E44, 0x0E45, 0x0E46, 0x0E47, /* 0xE0-0xE7 */
0x0E48, 0x0E49, 0x0E4A, 0x0E4B, 0x0E4C, 0x0E4D, 0x0E4E, 0x0E4F, /* 0xE8-0xEF */
0x0E50, 0x0E51, 0x0E52, 0x0E53, 0x0E54, 0x0E55, 0x0E56, 0x0E57, /* 0xF0-0xF7 */
0x0E58, 0x0E59, 0x0E5A, 0x0E5B, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 0xF8-0xFF */
};
struct char_set cp874_g1 = {
	1,
	CHARS(cp874_g1_chars),
	0, "", 0, 96,
};

struct char_set cp874 = {
	.c0 = &ibm_ascii_c0,
	.g0 = &ibm_ascii_g0,
	.c1 = &cp874_c1,
	.g1 = &cp874_g1,
	.names = { "cp874", 0 },
};

CONSTRUCTOR(static void init(void))
{
	register_charset(&cp874);
}
