/*
 * Decompiled with CFR 0.152.
 */
package jrm.digest;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import jrm.digest.CRCDigest;
import jrm.digest.MsgDigest;

public abstract class MDigest {
    public abstract void update(byte[] var1, int var2, int var3);

    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public abstract String getAlgorithm();

    public abstract void reset();

    public abstract String toString();

    public static MDigest getAlgorithm(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm.equalsIgnoreCase("CRC")) {
            return new CRCDigest();
        }
        return new MsgDigest(algorithm);
    }

    public static MDigest[] computeHash(InputStream in, MDigest[] md) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(in, 0x100000);){
            byte[] buffer = new byte[8192];
            int len = ((InputStream)is).read(buffer);
            while (len != -1) {
                for (MDigest m : md) {
                    m.update(buffer, 0, len);
                }
                len = ((InputStream)is).read(buffer);
            }
        }
        return md;
    }
}

