/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.xml.stream.XMLStreamException;
import jrm.profile.data.AnywareListList;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.ByName;
import jrm.profile.data.NameBase;
import jrm.profile.data.SoftwareList;
import jrm.profile.manager.Export;
import jrm.ui.profile.data.AnywareListListRenderer;
import jrm.ui.progress.ProgressHandler;
import jrm.xml.EnhancedXMLStreamWriter;
import org.apache.commons.io.IOUtils;

public final class SoftwareListList
extends AnywareListList<SoftwareList>
implements Serializable,
ByName<SoftwareList> {
    private final ArrayList<SoftwareList> sl_list = new ArrayList();
    private final HashMap<String, SoftwareList> sl_byname = new HashMap();
    private transient Map<String, SoftwareList> sl_filtered_byname = null;

    public SoftwareListList() {
        this.initTransient();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransient();
    }

    @Override
    protected void initTransient() {
        super.initTransient();
    }

    @Override
    public int getColumnCount() {
        return AnywareListListRenderer.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return AnywareListListRenderer.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return AnywareListListRenderer.columnsTypes[columnIndex];
    }

    @Override
    public TableCellRenderer getColumnRenderer(int columnIndex) {
        return AnywareListListRenderer.columnsRenderers[columnIndex] != null ? AnywareListListRenderer.columnsRenderers[columnIndex] : new DefaultTableCellRenderer();
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return AnywareListListRenderer.columnsWidths[columnIndex];
    }

    @Override
    public void reset() {
        this.filtered_list = null;
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void setFilter(EnumSet<AnywareStatus> filter) {
    }

    @Override
    public int getRowCount() {
        return this.getFilteredList().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getFilteredList().get(rowIndex);
            }
            case 1: {
                return this.getFilteredList().get((int)rowIndex).description.toString();
            }
            case 2: {
                return String.format("%d/%d", this.getFilteredList().get(rowIndex).countHave(), this.getFilteredList().get(rowIndex).countAll());
            }
        }
        return null;
    }

    @Override
    public List<SoftwareList> getList() {
        return this.sl_list;
    }

    @Override
    public Stream<SoftwareList> getFilteredStream() {
        return this.getList().stream().filter(t -> t.getSystem().isSelected());
    }

    @Override
    protected List<SoftwareList> getFilteredList() {
        if (this.filtered_list == null) {
            this.filtered_list = this.getFilteredStream().filter(t -> AnywareListList.filter.contains(t.getStatus())).sorted().collect(Collectors.toList());
        }
        return this.filtered_list;
    }

    public void export(EnhancedXMLStreamWriter writer, ProgressHandler progress, boolean filtered, SoftwareList selection) throws XMLStreamException, IOException {
        List<SoftwareList> lists;
        List<SoftwareList> list = selection != null ? Collections.singletonList(selection) : (lists = filtered ? this.getFilteredStream().collect(Collectors.toList()) : this.getList());
        if (lists.size() > 0) {
            writer.writeStartDocument("UTF-8", "1.0");
            if (lists.size() > 1) {
                writer.writeDTD("<!DOCTYPE softwarelists [\n" + IOUtils.toString(Export.class.getResourceAsStream("/jrm/resources/dtd/softwarelists.dtd"), Charset.forName("UTF-8")) + "\n]>\n");
                writer.writeStartElement("softwarelists");
            } else {
                writer.writeDTD("<!DOCTYPE softwarelist [\n" + IOUtils.toString(Export.class.getResourceAsStream("/jrm/resources/dtd/softwarelist.dtd"), Charset.forName("UTF-8")) + "\n]>\n");
            }
            progress.setProgress("Exporting", 0, lists.stream().flatMapToInt(sl -> IntStream.of(sl.size())).sum());
            progress.setProgress2(String.format("%d/%d", 0, lists.size()), 0, lists.size());
            for (SoftwareList list2 : lists) {
                list2.export(writer, filtered, progress);
                progress.setProgress2(String.format("%d/%d", progress.getValue2() + 1, lists.size()), progress.getValue2() + 1);
            }
            writer.writeEndDocument();
        }
    }

    @Override
    public boolean containsName(String name) {
        return this.sl_byname.containsKey(name);
    }

    @Override
    public SoftwareList getByName(String name) {
        return this.sl_byname.get(name);
    }

    @Override
    public SoftwareList putByName(SoftwareList t) {
        return this.sl_byname.put(t.name, t);
    }

    @Override
    public void resetFilteredName() {
        this.sl_filtered_byname = this.getFilteredStream().collect(Collectors.toMap(NameBase::getBaseName, Function.identity()));
    }

    @Override
    public boolean containsFilteredName(String name) {
        if (this.sl_filtered_byname == null) {
            this.resetFilteredName();
        }
        return this.sl_filtered_byname.containsKey(name);
    }

    @Override
    public SoftwareList getFilteredByName(String name) {
        if (this.sl_filtered_byname == null) {
            this.resetFilteredName();
        }
        return this.sl_filtered_byname.get(name);
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return AnywareListListRenderer.columnsRenderers;
    }
}

