/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import jrm.locale.Messages;
import jrm.profile.data.PropertyStub;
import org.apache.commons.lang3.StringUtils;

public final class NPlayers
extends AbstractListModel<NPlayer>
implements Iterable<NPlayer> {
    private final List<NPlayer> list_nplayers = new ArrayList<NPlayer>();
    public final File file;

    private NPlayers(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            TreeMap<String, NPlayer> nplayers = new TreeMap<String, NPlayer>();
            this.file = file;
            boolean in_section = false;
            while (null != (line = reader.readLine())) {
                NPlayer nplayer;
                String[] kv;
                if (line.equalsIgnoreCase("[NPlayers]")) {
                    in_section = true;
                    continue;
                }
                if (line.startsWith("[") && in_section) break;
                if (!in_section || (kv = StringUtils.split((String)line, (char)'=')).length != 2) continue;
                String k = kv[0].trim();
                String v = kv[1].trim();
                if (!nplayers.containsKey(v)) {
                    nplayer = new NPlayer(v);
                    nplayers.put(v, nplayer);
                } else {
                    nplayer = (NPlayer)nplayers.get(v);
                }
                nplayer.add(k);
            }
            this.list_nplayers.addAll(nplayers.values());
            if (this.list_nplayers.isEmpty()) {
                throw new IOException(Messages.getString("NPlayers.NoNPlayersData"));
            }
        }
    }

    public static NPlayers read(File file) throws IOException {
        return new NPlayers(file);
    }

    @Override
    public int getSize() {
        return this.list_nplayers.size();
    }

    @Override
    public NPlayer getElementAt(int index) {
        return this.list_nplayers.get(index);
    }

    @Override
    public Iterator<NPlayer> iterator() {
        return this.list_nplayers.iterator();
    }

    public final class NPlayer
    implements List<String>,
    PropertyStub {
        private final String name;
        private final List<String> games = new ArrayList<String>();

        public NPlayer(String name) {
            this.name = name;
        }

        @Override
        public int size() {
            return this.games.size();
        }

        @Override
        public boolean isEmpty() {
            return this.games.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.games.contains(o);
        }

        @Override
        public Iterator<String> iterator() {
            return this.games.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.games.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.games.toArray(a);
        }

        @Override
        public boolean add(String e) {
            return this.games.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.games.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.games.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return this.games.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends String> c) {
            return this.games.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.games.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.games.retainAll(c);
        }

        @Override
        public void clear() {
            this.games.clear();
        }

        @Override
        public String get(int index) {
            return this.games.get(index);
        }

        @Override
        public String set(int index, String element) {
            return this.games.set(index, element);
        }

        @Override
        public void add(int index, String element) {
            this.games.add(index, element);
        }

        @Override
        public String remove(int index) {
            return this.games.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.games.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.games.lastIndexOf(o);
        }

        @Override
        public ListIterator<String> listIterator() {
            return this.games.listIterator();
        }

        @Override
        public ListIterator<String> listIterator(int index) {
            return this.games.listIterator(index);
        }

        @Override
        public List<String> subList(int fromIndex, int toIndex) {
            return this.games.subList(fromIndex, toIndex);
        }

        public String toString() {
            return this.name + " (" + this.games.size() + ")";
        }

        @Override
        public String getPropertyName() {
            return "filter.nplayer." + this.name;
        }
    }
}

