/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import java.io.IOException;
import jrm.locale.Messages;
import jrm.profile.data.Container;
import jrm.profile.fix.actions.ContainerAction;
import jrm.profile.scan.options.FormatOptions;
import jrm.ui.progress.ProgressHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.StringEscapeUtils;

public class DeleteContainer
extends ContainerAction {
    public DeleteContainer(Container container, FormatOptions format) {
        super(container, format);
    }

    public static DeleteContainer getInstance(DeleteContainer action, Container container, FormatOptions format) {
        if (action == null) {
            action = new DeleteContainer(container, format);
        }
        return action;
    }

    @Override
    public boolean doAction(ProgressHandler handler) {
        handler.setProgress(this.toHTML(this.toNoBR(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("DeleteContainer.Deleting")), this.toBlue(this.container.file.getName())))));
        if (this.container.getType() == Container.Type.ZIP) {
            return this.container.file.delete();
        }
        if (this.container.getType() == Container.Type.SEVENZIP) {
            return this.container.file.delete();
        }
        if (this.container.getType() == Container.Type.DIR) {
            try {
                FileUtils.deleteDirectory(this.container.file);
                return true;
            }
            catch (IOException e) {
                System.err.println("failed to delete " + this.container.file.getName());
                return false;
            }
        }
        if (this.container.getType() == Container.Type.UNK) {
            return this.container.file.delete();
        }
        return false;
    }

    public String toString() {
        return String.format(Messages.getString("DeleteContainer.Delete"), this.container);
    }
}

