/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.scan.options;

import java.util.EnumSet;
import jrm.locale.Messages;

public enum FormatOptions {
    DIR(Messages.getString("FormatOptions.Directories"), Ext.DIR),
    ZIP(Messages.getString("FormatOptions.Zip"), Ext.ZIP),
    ZIPE(Messages.getString("FormatOptions.ZipExternal"), Ext.ZIP),
    SEVENZIP(Messages.getString("FormatOptions.SevenZip"), Ext.SEVENZIP),
    TZIP(Messages.getString("FormatOptions.TorrentZip"), Ext.ZIP);

    private String desc;
    private Ext ext;

    private FormatOptions(String desc, Ext ext) {
        this.desc = desc;
        this.ext = ext;
    }

    public Ext getExt() {
        return this.ext;
    }

    public String getDesc() {
        return this.desc;
    }

    public EnumSet<FormatOptions> allExcept() {
        return EnumSet.complementOf(EnumSet.of(this, DIR));
    }

    public static enum Ext {
        DIR(""),
        ZIP(".zip"),
        SEVENZIP(".7z");

        private String ext;

        private Ext(String ext) {
            this.ext = ext;
        }

        public String toString() {
            return this.ext;
        }

        public EnumSet<Ext> allExcept() {
            return EnumSet.complementOf(EnumSet.of(this, DIR));
        }

        public boolean isDir() {
            return this == DIR;
        }
    }
}

