/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jrm.ui.basic.EnhTableModel;

public abstract class SDRTableModel
implements EnhTableModel {
    private List<SrcDstResult> data = new ArrayList<SrcDstResult>();
    private final EventListenerList listenerList = new EventListenerList();
    private FileFilter srcFilter = null;
    private FileFilter dstFilter = null;
    private int current_row;
    private int current_col;

    public int getCurrentRow() {
        return this.current_row;
    }

    public int setCurrentRow(int current_row) {
        this.current_row = current_row;
        return current_row;
    }

    public int getCurrentCol() {
        return this.current_col;
    }

    public int setCurrentCol(int current_col) {
        this.current_col = current_col;
        return current_col;
    }

    public List<SrcDstResult> getData() {
        return this.data;
    }

    public void setData(List<SrcDstResult> data) {
        this.current_row = -1;
        this.data = data;
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public FileFilter getSrcFilter() {
        return this.srcFilter;
    }

    public void setSrcFilter(FileFilter srcFilter) {
        this.srcFilter = srcFilter;
    }

    public FileFilter getDstFilter() {
        return this.dstFilter;
    }

    public void setDstFilter(FileFilter dstFilter) {
        this.dstFilter = dstFilter;
    }

    public static class SrcDstResult {
        public File src = null;
        public File dst = null;
        public String result = "";
        public boolean selected = true;
    }
}

