/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.util.NumericConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooManyFields
extends AbstractRule {
    private static final int DEFAULT_MAXFIELDS = 15;
    private Map<String, Integer> stats;
    private Map<String, ASTClassOrInterfaceDeclaration> nodes;
    private int maxFields;
    private static final PropertyDescriptor maxFieldsDescriptor = new IntegerProperty("maxfields", "Maximum allowable fields per class", 15, 1.0f);
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = TooManyFields.asFixedMap(maxFieldsDescriptor);

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.maxFields = this.getIntProperty(maxFieldsDescriptor);
        this.stats = new HashMap<String, Integer>(5);
        this.nodes = new HashMap<String, ASTClassOrInterfaceDeclaration>(5);
        List<ASTFieldDeclaration> l = node.findChildrenOfType(ASTFieldDeclaration.class);
        for (ASTFieldDeclaration fd : l) {
            ASTClassOrInterfaceDeclaration clazz;
            if (fd.isFinal() && fd.isStatic() || (clazz = fd.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) == null || clazz.isInterface()) continue;
            this.bumpCounterFor(clazz);
        }
        for (String k : this.stats.keySet()) {
            int val = this.stats.get(k);
            SimpleNode n = this.nodes.get(k);
            if (val <= this.maxFields) continue;
            this.addViolation(data, n);
        }
        return data;
    }

    private void bumpCounterFor(ASTClassOrInterfaceDeclaration clazz) {
        String key = clazz.getImage();
        if (!this.stats.containsKey(key)) {
            this.stats.put(key, NumericConstants.ZERO);
            this.nodes.put(key, clazz);
        }
        Integer i = this.stats.get(key) + 1;
        this.stats.put(key, i);
    }

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }
}

