/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.BorderLayout;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.Main;
import net.charabia.jsmoothgen.application.gui.util.RegExDocument;

public class InitialMemoryHeap
extends Editor {
    private JTextField m_args = new JTextField();
    private JComboBox m_units = new JComboBox();

    public InitialMemoryHeap() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.m_args);
        this.m_args.setDocument(new RegExDocument("[0-9]+"));
        this.m_args.setHorizontalAlignment(4);
        Vector<String> u = new Vector<String>();
        u.add(Main.local("UNIT_MB"));
        u.add(Main.local("UNIT_KB"));
        u.add(Main.local("UNIT_BYTE"));
        DefaultComboBoxModel mod = new DefaultComboBoxModel(u);
        this.m_units.setModel(mod);
        this.add("East", this.m_units);
    }

    public void dataChanged() {
        this.setValueCombo(this.m_model.getInitialMemoryHeap(), this.m_args, this.m_units);
    }

    public void updateModel() {
        int value;
        try {
            value = Integer.parseInt(this.m_args.getText());
        }
        catch (Exception exc) {
            this.m_model.setInitialMemoryHeap(-1);
            return;
        }
        switch (this.m_units.getSelectedIndex()) {
            case 0: {
                if (value > 2047) {
                    value = 2047;
                }
                this.m_model.setInitialMemoryHeap(value * 1024 * 1024);
                break;
            }
            case 1: {
                this.m_model.setInitialMemoryHeap(value * 1024);
                break;
            }
            case 2: {
                this.m_model.setInitialMemoryHeap(value);
            }
        }
    }

    public String getLabel() {
        return "INITIALMEMORY_LABEL";
    }

    public String getDescription() {
        return "INITIALMEMORY_HELP";
    }

    public void setValueCombo(int value, JTextField num, JComboBox box) {
        if (value >= 0x100000) {
            num.setText(new Integer(value / 0x100000).toString());
            box.setSelectedIndex(0);
        } else if (value >= 1024) {
            num.setText(new Integer(value / 1024).toString());
            box.setSelectedIndex(1);
        } else if (value > 0) {
            num.setText(new Integer(value).toString());
            box.setSelectedIndex(2);
        } else {
            num.setText("");
            box.setSelectedIndex(0);
        }
    }
}

