/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.Main;
import net.charabia.jsmoothgen.application.gui.skeleditors.AutoDownloadURLEditor;
import net.charabia.jsmoothgen.application.gui.skeleditors.CheckBoxEditor;
import net.charabia.jsmoothgen.application.gui.skeleditors.SkelPanel;
import net.charabia.jsmoothgen.application.gui.skeleditors.SkelPropEditor;
import net.charabia.jsmoothgen.application.gui.skeleditors.StringEditor;
import net.charabia.jsmoothgen.application.gui.skeleditors.TextAreaEditor;
import net.charabia.jsmoothgen.application.gui.util.HelpButton;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import net.charabia.jsmoothgen.skeleton.SkeletonProperty;
import se.datadosen.component.RiverLayout;

public class SkeletonPropertiesEditor
extends Editor
implements JSmoothModelBean.SkeletonChangedListener {
    private String m_currentSkelName = null;
    private SkeletonBean m_skel = null;
    private SkelPanel m_panel = new SkelPanel();
    private Vector m_editors = new Vector();

    public SkeletonPropertiesEditor() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_panel, "Center");
    }

    public void rebuildProperties() {
        this.m_skel = null;
        if (this.m_currentSkelName != null) {
            this.m_skel = Main.SKELETONS.getSkeleton(this.m_currentSkelName);
        }
        SkeletonProperty[] sprops = null;
        sprops = this.m_skel != null ? this.m_skel.getSkeletonProperties() : new SkeletonProperty[]{};
        this.m_panel.removeAll();
        this.m_panel.setLayout((LayoutManager)new RiverLayout());
        this.m_editors.clear();
        for (int i = 0; i < sprops.length; ++i) {
            SkelPropEditor spe = null;
            if (sprops[i].getType().equalsIgnoreCase(SkeletonProperty.TYPE_STRING)) {
                spe = new StringEditor();
            } else if (sprops[i].getType().equalsIgnoreCase(SkeletonProperty.TYPE_TEXTAREA)) {
                spe = new TextAreaEditor();
            } else if (sprops[i].getType().equalsIgnoreCase(SkeletonProperty.TYPE_BOOLEAN)) {
                spe = new CheckBoxEditor();
            } else if (sprops[i].getType().equalsIgnoreCase(SkeletonProperty.TYPE_AUTODOWNLOADURL)) {
                spe = new AutoDownloadURLEditor();
            }
            if (spe == null) {
                spe = new StringEditor();
            }
            this.m_editors.add(spe);
            spe.bind(sprops[i]);
            if (spe.labelAtLeft()) {
                this.m_panel.add("br", new JLabel(Main.local(sprops[i].getLabel())));
                this.m_panel.add("tab", new HelpButton(Main.local(sprops[i].getDescription())));
                this.m_panel.add("tab hfill", spe.getGUI());
                continue;
            }
            this.m_panel.add("br right", spe.getGUI());
            this.m_panel.add("tab", new HelpButton(Main.local(sprops[i].getDescription())));
            this.m_panel.add("tab hfill", new JLabel(Main.local(sprops[i].getLabel())));
        }
        this.revalidate();
        this.m_panel.revalidate();
        this.doLayout();
        this.m_panel.doLayout();
    }

    public void dataChanged() {
        block7: {
            block6: {
                JSmoothModelBean.Property[] jsprop;
                if (this.m_model.getSkeletonName() == null) {
                    this.m_currentSkelName = null;
                    this.rebuildProperties();
                }
                if (this.m_model != null && this.m_model.getSkeletonName() != null && !this.m_model.getSkeletonName().equalsIgnoreCase(this.m_currentSkelName)) {
                    this.m_currentSkelName = this.m_model.getSkeletonName();
                    this.rebuildProperties();
                }
                if ((jsprop = this.m_model.getSkeletonProperties()) == null) break block6;
                Enumeration e = this.m_editors.elements();
                while (e.hasMoreElements()) {
                    SkelPropEditor spe = (SkelPropEditor)e.nextElement();
                    JSmoothModelBean.Property p = this.getPropertyInstance(spe.getIdName());
                    if (p == null) continue;
                    spe.valueChanged(p.getValue());
                }
                break block7;
            }
            SkeletonBean skel = Main.SKELETONS.getSkeleton(this.m_model.getSkeletonName());
            SkeletonProperty[] sprops = null;
            if (skel != null) {
                sprops = skel.getSkeletonProperties();
            }
            if (sprops == null) break block7;
            Enumeration e = this.m_editors.elements();
            while (e.hasMoreElements()) {
                SkelPropEditor spe = (SkelPropEditor)e.nextElement();
                for (int i = 0; i < sprops.length; ++i) {
                    if (!sprops[i].getIdName().equals(spe.getIdName())) continue;
                    spe.valueChanged(sprops[i].getValue());
                }
            }
        }
    }

    JSmoothModelBean.Property getPropertyInstance(String name) {
        JSmoothModelBean.Property[] jsprop = this.m_model.getSkeletonProperties();
        for (int i = 0; i < jsprop.length; ++i) {
            if (!jsprop[i].getKey().equals(name)) continue;
            return jsprop[i];
        }
        return null;
    }

    public void updateModel() {
        if (this.m_skel != null) {
            JSmoothModelBean.Property[] props = new JSmoothModelBean.Property[this.m_editors.size()];
            int index = 0;
            Enumeration e = this.m_editors.elements();
            while (e.hasMoreElements()) {
                SkelPropEditor spe = (SkelPropEditor)e.nextElement();
                props[index] = new JSmoothModelBean.Property();
                props[index].setKey(spe.getIdName());
                props[index].setValue(spe.get());
                ++index;
            }
            this.m_model.setSkeletonProperties(props);
        }
    }

    public void skeletonChanged() {
        this.rebuildProperties();
        this.dataChanged();
    }

    public String getLabel() {
        return "SKELETONPROPERTIES_LABEL";
    }

    public String getDescription() {
        return "SKELETONPROPERTIES_HELP";
    }

    public boolean needsBigSpace() {
        return true;
    }
}

