/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class ArcCosineH
extends PostfixMathCommand {
    public ArcCosineH() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        stack.push(this.acosh(e));
    }

    public Object acosh(Object object) throws ParseException {
        if (object instanceof Complex) {
            return ((Complex)object).acosh();
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 1.0) {
                double d2 = Math.log(d + Math.sqrt(d * d - 1.0));
                return new Double(d2);
            }
            Complex complex = new Complex(((Number)object).doubleValue(), 0.0);
            return complex.acosh();
        }
        throw new ParseException("Invalid parameter type");
    }
}

