/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;

public class SpellCasterChoiceSet
extends ChoiceSet<PCClass>
implements PrimitiveChoiceSet<PCClass> {
    private static final PrimitiveChoiceSet<PCClass> EMPTY_CHOICE_SET = new PrimitiveChoiceSet<PCClass>(){

        @Override
        public Class<PCClass> getChoiceClass() {
            return PCClass.class;
        }

        @Override
        public String getLSTformat(boolean useAny) {
            return "";
        }

        @Override
        public Set<PCClass> getSet(PlayerCharacter pc) {
            return Collections.emptySet();
        }

        @Override
        public GroupingState getGroupingState() {
            return GroupingState.ANY;
        }
    };
    private final CDOMGroupRef<PCClass> allClasses;
    private final List<String> spelltypes;
    private final PrimitiveChoiceSet<PCClass> types;
    private final PrimitiveChoiceSet<PCClass> primitives;

    public SpellCasterChoiceSet(CDOMGroupRef<PCClass> allRef, List<String> spelltype, PrimitiveChoiceSet<PCClass> typePCS, PrimitiveChoiceSet<PCClass> primPCS) {
        super("SPELLCASTER", typePCS == null ? EMPTY_CHOICE_SET : typePCS);
        this.types = typePCS;
        this.primitives = primPCS;
        this.spelltypes = new ArrayList<String>(spelltype);
        this.allClasses = allRef;
    }

    @Override
    public String getLSTformat() {
        return this.getLSTformat(true);
    }

    @Override
    public String getLSTformat(boolean useAny) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.primitives != null) {
            list.add(this.primitives.getLSTformat(useAny));
        }
        if (this.types != null) {
            list.add(this.types.getLSTformat(useAny));
        }
        if (!this.spelltypes.isEmpty()) {
            list.addAll(this.spelltypes);
        }
        return StringUtil.join(list, (String)",");
    }

    @Override
    public Class<PCClass> getChoiceClass() {
        return PCClass.class;
    }

    @Override
    public Set<PCClass> getSet(PlayerCharacter pc) {
        FactKey fk = FactKey.valueOf("SpellType");
        HashSet<PCClass> returnSet = new HashSet<PCClass>();
        if (this.types != null) {
            for (PCClass pcc : this.types.getSet(pc)) {
                if (pcc.get(fk) == null || pc.getClassKeyed(pcc.getKeyName()) == null) continue;
                returnSet.add(pcc);
            }
        }
        if (this.primitives != null) {
            returnSet.addAll(this.primitives.getSet(pc));
        }
        if (this.spelltypes != null) {
            block1: for (PCClass pcc : this.allClasses.getContainedObjects()) {
                for (String type : this.spelltypes) {
                    String spelltype;
                    if (!type.equalsIgnoreCase(spelltype = (String)pcc.getResolved(fk)) || pc.getClassKeyed(pcc.getKeyName()) == null) continue;
                    returnSet.add(pcc);
                    continue block1;
                }
            }
        }
        return returnSet;
    }

    @Override
    public int hashCode() {
        return (this.types == null ? 0 : this.types.hashCode() * 29) + (this.primitives == null ? 0 : this.primitives.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SpellCasterChoiceSet) {
            SpellCasterChoiceSet other = (SpellCasterChoiceSet)obj;
            if (this.types == null ? other.types != null : !this.types.equals(other.types)) {
                return false;
            }
            if (this.primitives == null) {
                return other.primitives == null;
            }
            return this.primitives.equals(other.primitives);
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState state = GroupingState.EMPTY;
        if (this.primitives != null) {
            state = this.primitives.getGroupingState().add(state);
        }
        if (this.types != null) {
            state = this.types.getGroupingState().add(state);
        }
        if (!this.spelltypes.isEmpty()) {
            state = GroupingState.ANY.add(state);
        }
        return state;
    }
}

