/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.QualifyingObject;

public class DamageReduction
extends ConcretePrereqObject
implements QualifyingObject {
    private final Formula theReduction;
    private final String theBypass;

    public DamageReduction(Formula aReduction, String aBypass) {
        this.theReduction = aReduction;
        this.theBypass = aBypass;
    }

    public String getBypass() {
        return this.theBypass;
    }

    public Formula getReduction() {
        return this.theReduction;
    }

    public int getRawReductionValue() {
        return this.theReduction.isStatic() ? this.theReduction.resolveStatic().intValue() : -1;
    }

    public Collection<String> getBypassList() {
        StringTokenizer tok = new StringTokenizer(this.theBypass, " ");
        HashSet<String> ret = new HashSet<String>();
        while (tok.hasMoreTokens()) {
            String val = tok.nextToken();
            if ("or".equalsIgnoreCase(val) || "and".equalsIgnoreCase(val)) continue;
            ret.add(val.toLowerCase());
        }
        return Collections.unmodifiableSet(ret);
    }

    public String toString() {
        String reductionString = this.theReduction.toString();
        int val = this.getRawReductionValue();
        if (val < 0) {
            reductionString = "variable";
        }
        return reductionString + "/" + this.theBypass;
    }

    public boolean equals(Object other) {
        Collection<String> coll2;
        if (!(other instanceof DamageReduction)) {
            return false;
        }
        Collection<String> coll1 = this.getBypassList();
        if (coll1.containsAll(coll2 = ((DamageReduction)other).getBypassList()) && coll2.containsAll(coll1)) {
            return this.theReduction.equals(((DamageReduction)other).theReduction);
        }
        return false;
    }

    public int hashCode() {
        ArrayList<String> list = new ArrayList<String>(this.getBypassList());
        Collections.sort(list);
        int hash = 0;
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            hash += i.next().hashCode();
        }
        return this.theReduction.hashCode() + hash;
    }

    public String getLSTformat() {
        StringBuilder result = new StringBuilder();
        result.append(this.theReduction);
        result.append('/');
        result.append(this.theBypass);
        return result.toString();
    }
}

