/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.factset;

import java.util.List;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.factset.FactSetInfo;
import pcgen.cdom.enumeration.FactSetKey;
import pcgen.persistence.lst.LstToken;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;

public class FactSetDefinitionEnforcer<T extends CDOMObject, F>
implements DeferredToken<T>,
LstToken {
    private final FactSetInfo<T, F> def;

    public FactSetDefinitionEnforcer(FactSetInfo<T, F> fsi) {
        if (fsi == null) {
            throw new IllegalArgumentException("FactSet Info cannot be null");
        }
        this.def = fsi;
    }

    @Override
    public boolean process(LoadContext context, T obj) {
        FactSetKey<F> fk = this.def.getFactSetKey();
        List<ObjectContainer<F>> list = ((CDOMObject)obj).getSetFor(fk);
        if (list != null && !list.isEmpty()) {
            return true;
        }
        Logging.errorPrint("FACTSET " + this.def.getFactSetName() + " was required but not set in " + obj.getClass().getSimpleName() + " " + ((CDOMObject)obj).getKeyName());
        return false;
    }

    @Override
    public Class<T> getDeferredTokenClass() {
        return this.def.getUsableLocation();
    }

    @Override
    public String getTokenName() {
        return "FACTSETENFORCE";
    }
}

