/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.EqModSpellInfo;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;

public enum EqModNameOpt {
    NORMAL{

        @Override
        public String returnName(Equipment parent, EquipmentModifier mod) {
            StringBuilder sb = new StringBuilder(100);
            sb.append(mod.getDisplayName());
            if (!parent.getAssociationList(mod).isEmpty()) {
                sb.append(" (");
                sb.append(this.associatedList(parent.getAssociationList(mod)));
                sb.append(')');
            }
            return sb.toString().trim().replace('|', ' ');
        }
    }
    ,
    NOLIST{

        @Override
        public String returnName(Equipment parent, EquipmentModifier mod) {
            return mod.getDisplayName().trim().replace('|', ' ');
        }
    }
    ,
    NONAME{

        @Override
        public String returnName(Equipment parent, EquipmentModifier mod) {
            StringBuilder sb = new StringBuilder(100);
            sb.append(this.associatedList(parent.getAssociationList(mod)));
            return sb.toString().trim().replace('|', ' ');
        }
    }
    ,
    NOTHING{

        @Override
        public String returnName(Equipment parent, EquipmentModifier mod) {
            return "";
        }
    }
    ,
    SPELL{

        @Override
        public String returnName(Equipment parent, EquipmentModifier mod) {
            StringBuilder sb = new StringBuilder(100);
            boolean first = true;
            for (String listEntry : parent.getAssociationList(mod)) {
                String metaFeat;
                List<String> metaFeats;
                Spell aSpell;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                String spellName = EqModSpellInfo.getSpellInfoString(listEntry, "SPELLNAME");
                if (SettingsHandler.guiUsesOutputNameSpells() && (aSpell = Globals.getSpellKeyed(spellName)) != null) {
                    spellName = aSpell.getOutputName();
                }
                sb.append(spellName);
                String info = EqModSpellInfo.getSpellInfoString(listEntry, "VARIANT");
                if (info.length() != 0) {
                    sb.append(" (").append(info).append(')');
                }
                if (!(metaFeats = CoreUtility.split(metaFeat = EqModSpellInfo.getSpellInfoString(listEntry, "METAFEATS"), ',')).isEmpty()) {
                    sb.append('/').append(StringUtil.join(metaFeats, (String)"/"));
                }
                sb.append('/').append(EqModSpellInfo.getSpellInfoString(listEntry, "CASTER"));
                sb.append('/').append(CoreUtility.ordinal(EqModSpellInfo.getSpellInfo(listEntry, "CASTERLEVEL")));
            }
            return sb.toString().trim().replace('|', ' ');
        }
    }
    ,
    TEXT{

        @Override
        public String returnName(Equipment parent, EquipmentModifier mod) {
            return mod.get(StringKey.NAME_TEXT);
        }
    };

    private static CaseInsensitiveMap<EqModNameOpt> typeMap;

    public abstract String returnName(Equipment var1, EquipmentModifier var2);

    public static EqModNameOpt valueOfIgnoreCase(String optName) {
        EqModNameOpt eqmno;
        if (typeMap == null) {
            EqModNameOpt.buildMap();
        }
        if ((eqmno = (EqModNameOpt)((Object)typeMap.get((Object)optName))) == null) {
            throw new IllegalArgumentException(optName + " is not a valid EqModNameOpt");
        }
        return eqmno;
    }

    private static void buildMap() {
        typeMap = new CaseInsensitiveMap();
        Class<EqModNameOpt> thisClass = EqModNameOpt.class;
        for (Field f : thisClass.getDeclaredFields()) {
            int mod = f.getModifiers();
            String name = f.getName();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod)) continue;
            try {
                Object obj = f.get(null);
                if (!thisClass.isAssignableFrom(obj.getClass())) continue;
                EqModNameOpt tObj = (EqModNameOpt)((Object)thisClass.cast(obj));
                if (typeMap.containsKey((Object)name)) {
                    throw new UnreachableError("Attempt to redefine constant value " + name + ", value was " + typeMap.get((Object)name));
                }
                typeMap.put((Object)name, (Object)tObj);
            }
            catch (IllegalArgumentException e) {
                throw new UnreachableError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UnreachableError((Throwable)e);
            }
        }
    }

    public String associatedList(List<String> associatedList) {
        if (associatedList == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        boolean first = true;
        for (String choice : associatedList) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (choice == null) {
                sb.append('*');
                continue;
            }
            sb.append(choice);
        }
        return sb.toString();
    }

    static {
        typeMap = null;
    }
}

