/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.EquipmentFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.core.Equipment;
import pcgen.core.character.SpellBook;

public class SpellBookFacet
extends AbstractStorageFacet<CharID>
implements DataFacetChangeListener<CharID, Equipment> {
    private EquipmentFacet equipmentFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, Equipment> dfce) {
        Equipment eq = dfce.getCDOMObject();
        if (eq.isType("SPELLBOOK")) {
            CharID id = dfce.getCharID();
            String baseBookname = eq.getName();
            String bookName = eq.getName();
            int qty = (int)eq.qty();
            for (int i = 0; i < qty; ++i) {
                SpellBook book;
                if (i > 0) {
                    bookName = baseBookname + " #" + (i + 1);
                }
                if ((book = this.getBookNamed(id, bookName)) == null) {
                    book = new SpellBook(bookName, 3);
                }
                book.setEquip(eq);
                if (this.containsBookNamed(id, book.getName())) continue;
                this.add(id, book);
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, Equipment> dfce) {
    }

    public void addAll(CharID id, Collection<SpellBook> list) {
        for (SpellBook sb : list) {
            this.add(id, sb);
        }
    }

    public void add(CharID id, SpellBook sb) {
        if (sb == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        Map<String, SpellBook> sbMap = this.getConstructingCachedMap(id);
        String name = sb.getName();
        sbMap.put(name, sb);
    }

    public void removeAll(CharID id) {
        this.removeCache(id);
    }

    private Map<String, SpellBook> getCachedMap(CharID id) {
        return (Map)this.getCache(id);
    }

    private Map<String, SpellBook> getConstructingCachedMap(CharID id) {
        Map<String, SpellBook> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = new LinkedHashMap<String, SpellBook>();
            this.setCache(id, componentMap);
        }
        return componentMap;
    }

    public SpellBook getBookNamed(CharID id, String name) {
        Map<String, SpellBook> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return null;
        }
        return componentMap.get(name);
    }

    public Collection<String> getBookNames(CharID id) {
        Map<String, SpellBook> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(componentMap.keySet());
    }

    public Collection<SpellBook> getBooks(CharID id) {
        Map<String, SpellBook> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(componentMap.values());
    }

    public boolean containsBookNamed(CharID id, String name) {
        Map<String, SpellBook> componentMap = this.getCachedMap(id);
        return componentMap != null && componentMap.containsKey(name);
    }

    public int getCount(CharID id) {
        Map<String, SpellBook> componentMap = this.getCachedMap(id);
        return componentMap == null ? 0 : componentMap.size();
    }

    public void removeBookNamed(CharID id, String name) {
        Map<String, SpellBook> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            componentMap.remove(name);
        }
    }

    public void setEquipmentFacet(EquipmentFacet equipmentFacet) {
        this.equipmentFacet = equipmentFacet;
    }

    public void init() {
        this.equipmentFacet.addDataFacetChangeListener(this);
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        Map<String, SpellBook> map = this.getCachedMap(source);
        if (map != null) {
            this.addAll(copy, map.values());
        }
    }
}

