/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SpellProhibitor;
import pcgen.core.SpellSupportForPCClass;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.ChooserFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentListFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.SpellFacade;
import pcgen.facade.core.SpellSupportFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.facade.CharacterFacadeImpl;
import pcgen.gui2.facade.GeneralChooserFacadeBase;
import pcgen.gui2.facade.SpellFacadeImplem;
import pcgen.gui2.facade.TodoFacadeImpl;
import pcgen.gui2.facade.TodoManager;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.HtmlInfoBuilder;
import pcgen.io.ExportUtilities;
import pcgen.system.BatchExporter;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.View;
import pcgen.util.fop.FopTask;

public class SpellSupportFacadeImpl
implements SpellSupportFacade,
EquipmentListFacade.EquipmentListListener,
ListListener<EquipmentFacade> {
    private final PlayerCharacter pc;
    private final CharacterDisplay charDisplay;
    private UIDelegate delegate;
    private DefaultListFacade<SpellSupportFacade.SpellNode> availableSpellNodes;
    private DefaultListFacade<SpellSupportFacade.SpellNode> allKnownSpellNodes;
    private DefaultListFacade<SpellSupportFacade.SpellNode> knownSpellNodes;
    private DefaultListFacade<SpellSupportFacade.SpellNode> preparedSpellNodes;
    private DefaultListFacade<SpellSupportFacade.SpellNode> bookSpellNodes;
    private List<SpellSupportFacade.SpellNode> preparedSpellLists;
    private List<SpellSupportFacade.SpellNode> spellBooks;
    private Map<String, RootNodeImpl> rootNodeMap;
    private final DataSetFacade dataSet;
    private DefaultListFacade<String> spellBookNames;
    private DefaultReferenceFacade<String> defaultSpellBook;
    private TodoManager todoManager;
    private CharacterFacadeImpl pcFacade;
    private final InfoFactory infoFactory;

    public SpellSupportFacadeImpl(PlayerCharacter pc, UIDelegate delegate, DataSetFacade dataSet, TodoManager todoManager, CharacterFacadeImpl pcFacade) {
        this.pc = pc;
        this.infoFactory = pcFacade.getInfoFactory();
        this.charDisplay = pc.getDisplay();
        this.delegate = delegate;
        this.dataSet = dataSet;
        this.todoManager = todoManager;
        this.pcFacade = pcFacade;
        this.rootNodeMap = new HashMap<String, RootNodeImpl>();
        this.spellBookNames = new DefaultListFacade();
        this.defaultSpellBook = new DefaultReferenceFacade<String>(this.charDisplay.getSpellBookNameToAutoAddKnown());
        this.availableSpellNodes = new DefaultListFacade();
        this.buildAvailableNodes();
        this.allKnownSpellNodes = new DefaultListFacade();
        this.knownSpellNodes = new DefaultListFacade();
        this.preparedSpellNodes = new DefaultListFacade();
        this.bookSpellNodes = new DefaultListFacade();
        this.preparedSpellLists = new ArrayList<SpellSupportFacade.SpellNode>();
        this.spellBooks = new ArrayList<SpellSupportFacade.SpellNode>();
        this.buildKnownPreparedNodes();
        this.updateSpellsTodo();
    }

    public ListFacade<SpellSupportFacade.SpellNode> getAvailableSpellNodes() {
        return this.availableSpellNodes;
    }

    public ListFacade<SpellSupportFacade.SpellNode> getAllKnownSpellNodes() {
        return this.allKnownSpellNodes;
    }

    public ListFacade<SpellSupportFacade.SpellNode> getKnownSpellNodes() {
        return this.knownSpellNodes;
    }

    public ListFacade<SpellSupportFacade.SpellNode> getPreparedSpellNodes() {
        return this.preparedSpellNodes;
    }

    public ListFacade<SpellSupportFacade.SpellNode> getBookSpellNodes() {
        return this.bookSpellNodes;
    }

    @Override
    public void addKnownSpell(SpellSupportFacade.SpellNode spell) {
        SpellSupportFacade.SpellNode node = this.addSpellToCharacter(spell, Globals.getDefaultSpellBook(), new ArrayList<Ability>());
        if (node != null) {
            this.allKnownSpellNodes.addElement(node);
            this.knownSpellNodes.addElement(node);
            if (!StringUtils.isEmpty(this.charDisplay.getSpellBookNameToAutoAddKnown())) {
                this.addToSpellBook(node, this.charDisplay.getSpellBookNameToAutoAddKnown());
            }
        }
        this.updateSpellsTodo();
        this.pcFacade.refreshAvailableTempBonuses();
    }

    @Override
    public void removeKnownSpell(SpellSupportFacade.SpellNode spell) {
        if (this.removeSpellFromCharacter(spell, Globals.getDefaultSpellBook())) {
            this.allKnownSpellNodes.removeElement(spell);
            this.knownSpellNodes.removeElement(spell);
        }
        this.updateSpellsTodo();
        this.pcFacade.refreshAvailableTempBonuses();
    }

    @Override
    public void addPreparedSpell(SpellSupportFacade.SpellNode spell, String spellList, boolean useMetamagic) {
        ArrayList<Ability> metamagicFeats = new ArrayList();
        if (useMetamagic && (metamagicFeats = this.queryUserForMetamagic(spell)) == null) {
            return;
        }
        SpellSupportFacade.SpellNode node = this.addSpellToCharacter(spell, spellList, metamagicFeats);
        if (node != null) {
            if (this.preparedSpellNodes.containsElement(node)) {
                SpellSupportFacade.SpellNode spellNode = this.preparedSpellNodes.getElementAt(this.preparedSpellNodes.getIndexOfElement(node));
                spellNode.addCount(1);
                this.preparedSpellNodes.removeElement(spellNode);
                this.preparedSpellNodes.addElement(spellNode);
            } else {
                this.preparedSpellNodes.addElement(node);
            }
            Iterator<SpellSupportFacade.SpellNode> iterator = this.preparedSpellNodes.iterator();
            while (iterator.hasNext()) {
                SpellSupportFacade.SpellNode sn = iterator.next();
                if (sn.getSpell() != null || !spellList.equals(sn.getRootNode().getName())) continue;
                iterator.remove();
            }
        }
    }

    private void updateSpellsTodo() {
        boolean hasFree = false;
        block0: for (PCClass aClass : this.charDisplay.getClassSet()) {
            if (!this.pc.getSpellSupport(aClass).hasKnownList() && !this.pc.getSpellSupport(aClass).hasKnownSpells(this.pc)) continue;
            int highestSpellLevel = this.pc.getSpellSupport(aClass).getHighestLevelSpell(this.pc);
            for (int i = 0; i <= highestSpellLevel; ++i) {
                if (!this.pc.availableSpells(i, aClass, Globals.getDefaultSpellBook(), true, false) && !this.pc.availableSpells(i, aClass, Globals.getDefaultSpellBook(), true, true)) continue;
                hasFree = true;
                continue block0;
            }
        }
        if (hasFree) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.SPELLS, "Known", "in_splTodoRemain", 120));
        } else {
            this.todoManager.removeTodo("in_splTodoRemain");
        }
    }

    private List<Ability> queryUserForMetamagic(SpellSupportFacade.SpellNode spellNode) {
        List<InfoFacade> availableList = this.buildAvailableMetamagicFeatList(spellNode);
        if (availableList.isEmpty()) {
            return Collections.emptyList();
        }
        String label = this.dataSet.getGameMode().getAddWithMetamagicMessage();
        if (StringUtils.isEmpty(label)) {
            label = LanguageBundle.getString("InfoSpells.add.with.metamagic");
        }
        final ArrayList<Ability> selectedList = new ArrayList<Ability>();
        GeneralChooserFacadeBase chooserFacade = new GeneralChooserFacadeBase(label, availableList, new ArrayList(), 99, this.infoFactory){

            @Override
            public void commit() {
                for (InfoFacade item : this.getSelectedList()) {
                    selectedList.add((Ability)item);
                }
            }
        };
        chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
        boolean result = this.delegate.showGeneralChooser(chooserFacade);
        return result ? selectedList : null;
    }

    private List<InfoFacade> buildAvailableMetamagicFeatList(SpellSupportFacade.SpellNode spellNode) {
        ArrayList<Ability> characterMetaMagicFeats = new ArrayList<Ability>();
        List<CNAbility> feats = this.pc.getCNAbilities(AbilityCategory.FEAT);
        for (CNAbility cna : feats) {
            Ability aFeat = cna.getAbility();
            if (!aFeat.isType("Metamagic") || aFeat.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.HIDDEN_EXPORT)) continue;
            characterMetaMagicFeats.add(aFeat);
        }
        Globals.sortPObjectListByName(characterMetaMagicFeats);
        if (!(spellNode.getSpell() instanceof SpellFacadeImplem)) {
            return Collections.emptyList();
        }
        SpellFacadeImplem spell = (SpellFacadeImplem)spellNode.getSpell();
        ArrayList<InfoFacade> availableList = new ArrayList<InfoFacade>();
        if (Globals.hasSpellPPCost()) {
            String aKey = spell.getKeyName();
            ArrayList<Ability> metamagicFeats = new ArrayList<Ability>();
            for (Ability anAbility : characterMetaMagicFeats) {
                boolean canAdd = false;
                List<BonusObj> bonusList = BonusUtilities.getBonusFromList(anAbility.getRawBonusList(this.pc), "PPCOST");
                if (bonusList.size() == 0) {
                    canAdd = true;
                } else {
                    block2: for (BonusObj aBonus : bonusList) {
                        StringTokenizer aTok = new StringTokenizer(aBonus.getBonusInfo(), ",");
                        while (aTok.hasMoreTokens()) {
                            String aBI = aTok.nextToken();
                            if (aBI.equalsIgnoreCase(aKey) || aBI.equalsIgnoreCase("ALL")) {
                                canAdd = true;
                                continue block2;
                            }
                            if (!aBI.startsWith("TYPE=") && !aBI.startsWith("TYPE.") || !spell.getSpell().isType(aBI.substring(5))) continue;
                            canAdd = true;
                            continue block2;
                        }
                    }
                }
                if (!canAdd) continue;
                metamagicFeats.add(anAbility);
            }
            availableList.addAll(metamagicFeats);
        } else {
            availableList.addAll(characterMetaMagicFeats);
        }
        return availableList;
    }

    @Override
    public void removePreparedSpell(SpellSupportFacade.SpellNode spell, String spellList) {
        if (this.removeSpellFromCharacter(spell, spellList)) {
            if (spell.getCount() > 1) {
                spell.addCount(-1);
                this.preparedSpellNodes.removeElement(spell);
                this.preparedSpellNodes.addElement(spell);
            } else {
                this.preparedSpellNodes.removeElement(spell);
            }
            this.addDummyNodeIfSpellListEmpty(spellList);
        }
    }

    private void addDummyNodeIfSpellListEmpty(String spellList) {
        boolean spellListEmpty = true;
        for (SpellSupportFacade.SpellNode node : this.preparedSpellNodes) {
            if (!spellList.equals(node.getRootNode().getName())) continue;
            spellListEmpty = false;
            break;
        }
        if (spellListEmpty) {
            for (SpellSupportFacade.SpellNode listNode : this.preparedSpellLists) {
                if (!spellList.equals(listNode.getRootNode().getName())) continue;
                this.preparedSpellNodes.addElement(listNode);
            }
        }
    }

    @Override
    public void addSpellList(String spellList) {
        if (StringUtils.isEmpty(spellList)) {
            return;
        }
        for (PCClass current : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCClass.class)) {
            if (!spellList.equals(current.getKeyName())) continue;
            JOptionPane.showMessageDialog(null, LanguageBundle.getString("in_spellbook_name_error"), "PCGen", 0);
            return;
        }
        if (!this.pc.addSpellBook(spellList)) {
            JOptionPane.showMessageDialog(null, LanguageBundle.getFormattedString("InfoPreparedSpells.add.list.fail", spellList), "PCGen", 0);
            return;
        }
        this.pc.setDirty(true);
        DummySpellNodeImpl spellListNode = new DummySpellNodeImpl(this.getRootNode(spellList));
        this.preparedSpellLists.add(spellListNode);
        this.addDummyNodeIfSpellListEmpty(spellList);
    }

    @Override
    public void removeSpellList(String spellList) {
        if (spellList.equalsIgnoreCase(Globals.getDefaultSpellBook())) {
            Logging.errorPrint(LanguageBundle.getString("InfoSpells.can.not.delete.default.spellbook"));
            return;
        }
        if (this.pc.delSpellBook(spellList)) {
            this.pc.setDirty(true);
            Iterator<SpellSupportFacade.SpellNode> iterator = this.preparedSpellLists.iterator();
            while (iterator.hasNext()) {
                SpellSupportFacade.SpellNode listNode = iterator.next();
                if (!spellList.equals(listNode.getRootNode().getName())) continue;
                iterator.remove();
            }
            iterator = this.preparedSpellNodes.iterator();
            while (iterator.hasNext()) {
                SpellSupportFacade.SpellNode spell = iterator.next();
                if (!spellList.equals(spell.getRootNode().getName())) continue;
                iterator.remove();
            }
        } else {
            Logging.errorPrint("delBookButton:failed ");
            return;
        }
    }

    @Override
    public void addToSpellBook(SpellSupportFacade.SpellNode spell, String spellBook) {
        SpellSupportFacade.SpellNode node;
        String bookName = spellBook;
        if (bookName.endsWith("]") && bookName.contains(" [")) {
            bookName = bookName.substring(0, bookName.lastIndexOf(" ["));
        }
        if ((node = this.addSpellToCharacter(spell, bookName, new ArrayList<Ability>())) != null) {
            if (this.bookSpellNodes.containsElement(node)) {
                SpellSupportFacade.SpellNode spellNode = this.bookSpellNodes.getElementAt(this.bookSpellNodes.getIndexOfElement(node));
                spellNode.addCount(1);
                this.bookSpellNodes.removeElement(spellNode);
                this.bookSpellNodes.addElement(spellNode);
            } else {
                this.bookSpellNodes.addElement(node);
            }
            Iterator<SpellSupportFacade.SpellNode> iterator = this.bookSpellNodes.iterator();
            while (iterator.hasNext()) {
                SpellSupportFacade.SpellNode sn = iterator.next();
                if (sn.getSpell() != null || !bookName.equals(sn.getRootNode().getName())) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void removeFromSpellBook(SpellSupportFacade.SpellNode spell, String spellBook) {
        if (this.removeSpellFromCharacter(spell, spellBook)) {
            if (spell.getCount() > 1) {
                spell.addCount(-1);
                this.bookSpellNodes.removeElement(spell);
                this.bookSpellNodes.addElement(spell);
            } else {
                this.bookSpellNodes.removeElement(spell);
            }
            this.addDummyNodeIfSpellBookEmpty(spellBook);
        }
    }

    private void addDummyNodeIfSpellBookEmpty(String spellBook) {
        boolean spellListEmpty = true;
        for (SpellSupportFacade.SpellNode node : this.bookSpellNodes) {
            if (!spellBook.equals(node.getRootNode().getName())) continue;
            spellListEmpty = false;
            break;
        }
        if (spellListEmpty) {
            for (SpellSupportFacade.SpellNode listNode : this.spellBooks) {
                if (!spellBook.equals(listNode.getRootNode().getName())) continue;
                this.bookSpellNodes.addElement(listNode);
            }
        }
    }

    @Override
    public void refreshAvailableKnownSpells() {
        this.buildAvailableNodes();
        this.buildKnownPreparedNodes();
        this.updateSpellsTodo();
    }

    @Override
    public String getClassInfo(ClassFacade spellcaster) {
        String bString;
        int i;
        if (!(spellcaster instanceof PCClass)) {
            return "";
        }
        PCClass aClass = (PCClass)spellcaster;
        SpellSupportForPCClass spellSupport = this.pc.getSpellSupport(aClass);
        int highestSpellLevel = spellSupport.getHighestLevelSpell(this.pc);
        HtmlInfoBuilder b = new HtmlInfoBuilder();
        b.append("<table border=1><tr><td><font size=-2><b>");
        b.append(OutputNameFormatting.piString(aClass, false)).append(" [");
        b.append(String.valueOf(this.charDisplay.getLevel(aClass) + (int)this.pc.getTotalBonusTo("PCLEVEL", aClass.getKeyName())));
        b.append("]</b></font></td>");
        for (i = 0; i <= highestSpellLevel; ++i) {
            b.append("<td><font size=-2><b><center>&nbsp;");
            b.append(String.valueOf(i));
            b.append("&nbsp;</b></center></font></td>");
        }
        b.append("</tr>");
        b.append("<tr><td><font size=-1><b>Cast</b></font></td>");
        for (i = 0; i <= highestSpellLevel; ++i) {
            b.append("<td><font size=-1><center>");
            b.append(SpellSupportFacadeImpl.getNumCast(aClass, i, this.pc));
            b.append("</center></font></td>");
        }
        b.append("</tr>");
        if (spellSupport.hasKnownList() || spellSupport.hasKnownSpells(this.pc)) {
            b.append("<tr><td><font size=-1><b>Known</b></font></td>");
            for (i = 0; i <= highestSpellLevel; ++i) {
                int a = spellSupport.getKnownForLevel(i, "null", this.pc);
                int bonus = spellSupport.getSpecialtyKnownForLevel(i, this.pc);
                b.append("<td><font size=-1><center>");
                b.append(String.valueOf(a));
                if (bonus > 0) {
                    b.append('+').append(Integer.toString(bonus));
                }
                b.append("</center></font></td>");
            }
            b.append("</tr>");
        }
        b.append("<tr><td><font size=-1><b>DC</b></font></td>");
        for (i = 0; i <= highestSpellLevel; ++i) {
            b.append("<td><font size=-1><center>");
            b.append(String.valueOf(SpellSupportFacadeImpl.getDC(aClass, i, this.pc)));
            b.append("</center></font></td>");
        }
        b.append("</tr></table>");
        b.appendI18nElement("InfoSpells.caster.type", aClass.getSpellType());
        b.appendLineBreak();
        b.appendI18nElement("InfoSpells.stat.bonus", aClass.getSpellBaseStat());
        if (this.pc.hasAssocs(aClass, AssociationKey.SPECIALTY) || this.charDisplay.hasDomains()) {
            boolean needComma = false;
            StringBuilder schoolInfo = new StringBuilder();
            String spec = this.pc.getAssoc(aClass, AssociationKey.SPECIALTY);
            if (spec != null) {
                schoolInfo.append(spec);
                needComma = true;
            }
            for (Domain d : this.charDisplay.getSortedDomainSet()) {
                if (needComma) {
                    schoolInfo.append(',');
                }
                needComma = true;
                schoolInfo.append(d.getKeyName());
            }
            b.appendLineBreak();
            b.appendI18nElement("InfoSpells.school", schoolInfo.toString());
        }
        TreeSet<String> set = new TreeSet<String>();
        for (SpellProhibitor sp : aClass.getSafeListFor(ListKey.PROHIBITED_SPELLS)) {
            set.addAll(sp.getValueList());
        }
        Collection<? extends SpellProhibitor> prohibList = this.charDisplay.getProhibitedSchools(aClass);
        if (prohibList != null) {
            for (SpellProhibitor spellProhibitor : prohibList) {
                set.addAll(spellProhibitor.getValueList());
            }
        }
        if (!set.isEmpty()) {
            b.appendLineBreak();
            b.appendI18nElement("InfoSpells.prohibited.school", StringUtil.join(set, (String)","));
        }
        if ((bString = SourceFormat.getFormattedString(aClass, Globals.getSourceDisplay(), true)).length() > 0) {
            b.appendLineBreak();
            b.appendI18nElement("in_source", bString);
        }
        return b.toString();
    }

    private static final String getNumCast(PCClass aClass, int level, PlayerCharacter pc) {
        String sbook = Globals.getDefaultSpellBook();
        String cast = pc.getSpellSupport(aClass).getCastForLevel(level, sbook, true, false, pc) + pc.getSpellSupport(aClass).getBonusCastForLevelString(level, sbook, pc);
        return cast;
    }

    private static int getDC(PCClass aClass, int level, PlayerCharacter pc) {
        return pc.getDC(new Spell(), aClass, level, 0, aClass);
    }

    private void buildAvailableNodes() {
        this.availableSpellNodes.clearContents();
        List<PCClass> classList = this.getCharactersSpellcastingClasses();
        for (PCClass pcClass : classList) {
            DoubleKeyMapToList<SpellFacade, String, SpellSupportFacade.SpellNode> existingSpells = this.buildExistingSpellMap(this.availableSpellNodes, pcClass);
            for (Spell spell : this.pc.getAllSpellsInLists(this.charDisplay.getSpellLists(pcClass))) {
                CharacterSpell charSpell = new CharacterSpell(pcClass, spell);
                SpellFacadeImplem spellImplem = new SpellFacadeImplem(this.pc, spell, charSpell, null);
                HashMapToList<CDOMList<Spell>, Integer> levelInfo = this.pc.getSpellLevelInfo(spell);
                for (CDOMList<Spell> cDOMList : this.charDisplay.getSpellLists(pcClass)) {
                    List levels = levelInfo.getListFor(cDOMList);
                    if (levels == null) continue;
                    for (Integer level : levels) {
                        SpellNodeImpl node = new SpellNodeImpl(spellImplem, pcClass, String.valueOf(level), null);
                        if (existingSpells.containsInList((Object)spellImplem, (Object)node.getSpellLevel(), (Object)node)) continue;
                        this.availableSpellNodes.addElement(node);
                    }
                }
            }
        }
    }

    private DoubleKeyMapToList<SpellFacade, String, SpellSupportFacade.SpellNode> buildExistingSpellMap(DefaultListFacade<SpellSupportFacade.SpellNode> spellNodeList, PCClass pcClass) {
        DoubleKeyMapToList spellMap = new DoubleKeyMapToList();
        for (SpellSupportFacade.SpellNode spellNode : spellNodeList) {
            if (!pcClass.equals(spellNode.getSpellcastingClass())) continue;
            spellMap.addToListFor((Object)spellNode.getSpell(), (Object)spellNode.getSpellLevel(), (Object)spellNode);
        }
        return spellMap;
    }

    private void buildKnownPreparedNodes() {
        this.allKnownSpellNodes.clearContents();
        this.knownSpellNodes.clearContents();
        this.bookSpellNodes.clearContents();
        this.preparedSpellNodes.clearContents();
        this.pc.getSpellList();
        List<PCClass> classList = this.getCharactersSpellcastingClasses();
        ArrayList<PCClass> pobjList = new ArrayList<PCClass>(classList);
        pobjList.add((PCClass)((Object)this.charDisplay.getRace()));
        for (PObject pObject : pobjList) {
            this.buildKnownPreparedSpellsForCDOMObject(pObject);
        }
        this.spellBooks.clear();
        this.spellBookNames.clearContents();
        for (SpellBook spellBook : this.charDisplay.getSpellBooks()) {
            DummySpellNodeImpl spellListNode;
            if (spellBook.getType() == 2) {
                spellListNode = new DummySpellNodeImpl(this.getRootNode(spellBook.getName()));
                this.preparedSpellLists.add(spellListNode);
                this.addDummyNodeIfSpellListEmpty(spellBook.getName());
                continue;
            }
            if (spellBook.getType() != 3) continue;
            spellListNode = new DummySpellNodeImpl(this.getRootNode(spellBook.getName()));
            this.spellBooks.add(spellListNode);
            this.addDummyNodeIfSpellBookEmpty(spellBook.getName());
            this.spellBookNames.addElement(spellBook.getName());
        }
    }

    private void buildKnownPreparedSpellsForCDOMObject(CDOMObject pObject) {
        Collection<? extends CharacterSpell> sp = this.charDisplay.getCharacterSpells(pObject);
        ArrayList<CharacterSpell> cSpells = new ArrayList<CharacterSpell>(sp);
        this.pc.addBonusKnownSpellsToList(pObject, cSpells);
        PCClass pcClass = (PCClass)(pObject instanceof PCClass ? pObject : null);
        for (CharacterSpell charSpell : cSpells) {
            for (SpellInfo spellInfo : charSpell.getInfoList()) {
                boolean isSpellBook;
                String book = spellInfo.getBook();
                boolean isKnown = Globals.getDefaultSpellBook().equals(book);
                SpellFacadeImplem spellImplem = new SpellFacadeImplem(this.pc, charSpell.getSpell(), charSpell, spellInfo);
                SpellNodeImpl node = pcClass != null ? new SpellNodeImpl(spellImplem, pcClass, String.valueOf(spellInfo.getActualLevel()), this.getRootNode(book)) : new SpellNodeImpl(spellImplem, String.valueOf(spellInfo.getActualLevel()), this.getRootNode(book));
                if (spellInfo.getTimes() > 1) {
                    node.addCount(spellInfo.getTimes() - 1);
                }
                boolean bl = isSpellBook = this.charDisplay.getSpellBookByName(book).getType() == 3;
                if (isKnown) {
                    this.allKnownSpellNodes.addElement(node);
                    this.knownSpellNodes.addElement(node);
                    continue;
                }
                if (isSpellBook) {
                    this.bookSpellNodes.addElement(node);
                    continue;
                }
                if (pObject instanceof Race) {
                    this.allKnownSpellNodes.addElement(node);
                    continue;
                }
                this.preparedSpellNodes.addElement(node);
            }
        }
    }

    private SpellSupportFacade.SpellNode addSpellToCharacter(SpellSupportFacade.SpellNode spell, String bookName, List<Ability> metamagicFeats) {
        if (!(spell.getSpell() instanceof SpellFacadeImplem)) {
            return null;
        }
        if (spell.getSpellcastingClass() == null) {
            return null;
        }
        CharacterSpell charSpell = ((SpellFacadeImplem)spell.getSpell()).getCharSpell();
        if (charSpell == null) {
            return null;
        }
        int level = Integer.parseInt(spell.getSpellLevel());
        for (Ability ability : metamagicFeats) {
            level += ability.getSafe(IntegerKey.ADD_SPELL_LEVEL);
        }
        String errorMsg = this.pc.addSpell(charSpell, metamagicFeats, spell.getSpellcastingClass().getKeyName(), bookName, level, level);
        if (!StringUtils.isEmpty(errorMsg)) {
            this.delegate.showErrorMessage("PCGen", errorMsg);
            return null;
        }
        SpellInfo spellInfo = charSpell.getSpellInfoFor(bookName, level, metamagicFeats);
        boolean isKnown = Globals.getDefaultSpellBook().equals(bookName);
        SpellFacadeImplem spellImplem = new SpellFacadeImplem(this.pc, charSpell.getSpell(), charSpell, spellInfo);
        SpellNodeImpl node = new SpellNodeImpl(spellImplem, spell.getSpellcastingClass(), String.valueOf(spellInfo.getActualLevel()), this.getRootNode(bookName));
        return node;
    }

    private RootNodeImpl getRootNode(String bookName) {
        if (Globals.getDefaultSpellBook().equals(bookName)) {
            return null;
        }
        RootNodeImpl rootNode = this.rootNodeMap.get(bookName);
        if (rootNode == null) {
            SpellBook book = this.charDisplay.getSpellBookByName(bookName);
            if (book == null) {
                return null;
            }
            rootNode = new RootNodeImpl(book);
            this.rootNodeMap.put(bookName, rootNode);
        }
        return rootNode;
    }

    private boolean removeSpellFromCharacter(SpellSupportFacade.SpellNode spell, String bookName) {
        if (!(spell.getSpell() instanceof SpellFacadeImplem)) {
            return false;
        }
        SpellFacadeImplem sfi = (SpellFacadeImplem)spell.getSpell();
        CharacterSpell charSpell = sfi.getCharSpell();
        SpellInfo spellInfo = sfi.getSpellInfo();
        if (charSpell == null || spellInfo == null) {
            return false;
        }
        String errorMsg = this.pc.delSpell(spellInfo, (PCClass)spell.getSpellcastingClass(), bookName);
        if (errorMsg.length() > 0) {
            this.delegate.showErrorMessage("PCGen", errorMsg);
            ShowMessageDelegate.showMessageDialog(errorMsg, "PCGen", MessageType.ERROR);
            return false;
        }
        return true;
    }

    private List<PCClass> getCharactersSpellcastingClasses() {
        ArrayList<PCClass> castingClasses = new ArrayList<PCClass>();
        Set<PCClass> classes = this.charDisplay.getClassSet();
        for (PCClass pcClass : classes) {
            SpellSupportForPCClass spellSupport;
            if (pcClass.get(FactKey.valueOf("SpellType")) == null || !(spellSupport = this.pc.getSpellSupport(pcClass)).canCastSpells(this.pc) && !spellSupport.hasKnownList()) continue;
            castingClasses.add(pcClass);
        }
        return castingClasses;
    }

    @Override
    public boolean isAutoSpells() {
        return this.pc.getAutoSpells();
    }

    @Override
    public void setAutoSpells(boolean autoSpells) {
        this.pc.setAutoSpells(autoSpells);
    }

    @Override
    public boolean isUseHigherKnownSlots() {
        return this.pc.getUseHigherKnownSlots();
    }

    @Override
    public void setUseHigherPreppedSlots(boolean useHigher) {
        this.pc.setUseHigherPreppedSlots(useHigher);
    }

    @Override
    public boolean isUseHigherPreppedSlots() {
        return this.pc.getUseHigherPreppedSlots();
    }

    @Override
    public void setUseHigherKnownSlots(boolean useHigher) {
        this.pc.setUseHigherKnownSlots(useHigher);
    }

    @Override
    public ListFacade<String> getSpellbooks() {
        return this.spellBookNames;
    }

    @Override
    public DefaultReferenceFacade<String> getDefaultSpellBookRef() {
        return this.defaultSpellBook;
    }

    @Override
    public void setDefaultSpellBook(String bookName) {
        SpellBook book = this.charDisplay.getSpellBookByName(bookName);
        if (book == null || book.getType() != 3) {
            return;
        }
        this.pc.setSpellBookNameToAutoAddKnown(bookName);
        this.defaultSpellBook.setReference(bookName);
    }

    @Override
    public void elementAdded(ListEvent<EquipmentFacade> e) {
        this.updateSpellBooks((Equipment)e.getElement());
    }

    @Override
    public void elementRemoved(ListEvent<EquipmentFacade> e) {
        this.updateSpellBooks((Equipment)e.getElement());
    }

    @Override
    public void elementsChanged(ListEvent<EquipmentFacade> e) {
        this.updateSpellBooks((Equipment)e.getElement());
    }

    @Override
    public void elementModified(ListEvent<EquipmentFacade> e) {
        this.updateSpellBooks((Equipment)e.getElement());
    }

    @Override
    public void quantityChanged(EquipmentListFacade.EquipmentListEvent e) {
        this.updateSpellBooks((Equipment)e.getEquipment());
    }

    private void updateSpellBooks(Equipment equip) {
        if (equip == null || equip.isType("SPELLBOOK")) {
            this.buildKnownPreparedNodes();
            Iterator<SpellSupportFacade.SpellNode> iterator = this.bookSpellNodes.iterator();
            while (iterator.hasNext()) {
                SpellSupportFacade.SpellNode spell = iterator.next();
                if (this.spellBookNames.containsElement(spell.getRootNode().getName())) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void previewSpells() {
        boolean aBool = SettingsHandler.getPrintSpellsWithPC();
        SettingsHandler.setPrintSpellsWithPC(true);
        String templateFileName = PCGenSettings.getInstance().getProperty("pcgen.files.selectedSpellOutputSheet");
        if (StringUtils.isEmpty(templateFileName)) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_spellNoSheet"));
            return;
        }
        File templateFile = new File(templateFileName);
        File outputFile = BatchExporter.getTempOutputFilename(templateFile);
        boolean success = ExportUtilities.isPdfTemplate(templateFile) ? BatchExporter.exportCharacterToPDF(this.pcFacade, outputFile, templateFile) : BatchExporter.exportCharacterToNonPDF(this.pcFacade, outputFile, templateFile);
        if (success) {
            try {
                Utility.viewInBrowser(outputFile);
            }
            catch (IOException e) {
                Logging.errorPrint("SpellSupportFacadeImpl.previewSpells failed", e);
                this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_spellPreviewFail"));
            }
        }
        SettingsHandler.setPrintSpellsWithPC(aBool);
    }

    @Override
    public void exportSpells() {
        String template = PCGenSettings.getInstance().getProperty("pcgen.files.selectedSpellOutputSheet");
        if (StringUtils.isEmpty(template)) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_spellNoSheet"));
            return;
        }
        String ext = template.substring(template.lastIndexOf(46));
        JFileChooser fcExport = new JFileChooser();
        fcExport.setCurrentDirectory(new File(PCGenSettings.getPcgDir()));
        fcExport.setDialogTitle(LanguageBundle.getString("InfoSpells.export.spells.for") + this.charDisplay.getDisplayName());
        if (fcExport.showSaveDialog(null) != 0) {
            return;
        }
        String aFileName = fcExport.getSelectedFile().getAbsolutePath();
        if (aFileName.length() < 1) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("InfoSpells.must.set.filename"));
            return;
        }
        try {
            int reallyClose;
            File outFile = new File(aFileName);
            if (outFile.isDirectory()) {
                this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("InfoSpells.can.not.overwrite.directory"));
                return;
            }
            if (outFile.exists() && (reallyClose = JOptionPane.showConfirmDialog(null, LanguageBundle.getFormattedString("InfoSpells.confirm.overwrite", outFile.getName()), LanguageBundle.getFormattedString("InfoSpells.overwriting", outFile.getName()), 0)) != 0) {
                return;
            }
            File templateFile = new File(template);
            boolean success = ExportUtilities.isPdfTemplate(templateFile) ? BatchExporter.exportCharacterToPDF(this.pcFacade, outFile, templateFile) : BatchExporter.exportCharacterToNonPDF(this.pcFacade, outFile, templateFile);
            if (!success) {
                this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("InfoSpells.export.failed", this.charDisplay.getDisplayName()));
            }
        }
        catch (Exception ex) {
            Logging.errorPrint(LanguageBundle.getFormattedString("InfoSpells.export.failed", this.charDisplay.getDisplayName()), ex);
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("InfoSpells.export.failed.retry", this.charDisplay.getDisplayName()));
        }
    }

    private void pdfExport(File outFile, File tmpFile, File xsltFile) {
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(tmpFile));
             BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outFile));){
            FopTask fopTask = FopTask.newFopTask((InputStream)input, xsltFile, output);
            fopTask.run();
            String errMessage = fopTask.getErrorMessages();
            if (errMessage.length() > 0) {
                this.delegate.showErrorMessage("PCGen", errMessage);
            }
        }
        catch (IOException ex) {
            Logging.errorPrint(LanguageBundle.getFormattedString("InfoSpells.export.failed", this.charDisplay.getDisplayName()), ex);
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("InfoSpells.export.failed.retry", this.charDisplay.getDisplayName()));
        }
        tmpFile.deleteOnExit();
    }

    public class DummySpellNodeImpl
    implements SpellSupportFacade.SpellNode {
        private final SpellSupportFacade.RootNode rootNode;

        public DummySpellNodeImpl(SpellSupportFacade.RootNode rootNode) {
            this.rootNode = rootNode;
        }

        @Override
        public ClassFacade getSpellcastingClass() {
            return null;
        }

        @Override
        public String getSpellLevel() {
            return "";
        }

        @Override
        public SpellFacade getSpell() {
            return null;
        }

        @Override
        public SpellSupportFacade.RootNode getRootNode() {
            return this.rootNode;
        }

        @Override
        public int getCount() {
            return 1;
        }

        @Override
        public void addCount(int num) {
        }

        public String toString() {
            return LanguageBundle.getString("in_spellEmptySpellList");
        }
    }

    public class SpellNodeImpl
    implements SpellSupportFacade.SpellNode {
        private final SpellFacade spell;
        private final ClassFacade cls;
        private final SpellSupportFacade.RootNode rootNode;
        private final String level;
        private int count;

        public SpellNodeImpl(SpellFacade spell, ClassFacade cls, String level, SpellSupportFacade.RootNode rootNode) {
            this.spell = spell;
            this.cls = cls;
            this.level = level;
            this.rootNode = rootNode;
            this.count = 1;
        }

        public SpellNodeImpl(SpellFacade spell, String level, SpellSupportFacade.RootNode rootNode) {
            this(spell, null, level, rootNode);
        }

        @Override
        public ClassFacade getSpellcastingClass() {
            return this.cls;
        }

        @Override
        public String getSpellLevel() {
            return this.level;
        }

        @Override
        public SpellFacade getSpell() {
            return this.spell;
        }

        @Override
        public SpellSupportFacade.RootNode getRootNode() {
            return this.rootNode;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void addCount(int num) {
            this.count += num;
        }

        public String toString() {
            String countStr = "";
            if (this.count != 1) {
                countStr = " (x" + this.count + ")";
            }
            if (this.spell != null) {
                return this.spell.toString() + countStr;
            }
            if (this.cls != null) {
                return this.cls.toString() + countStr;
            }
            if (this.rootNode != null) {
                return this.rootNode.toString() + countStr;
            }
            return LanguageBundle.getFormattedString("in_spellEmptyNode", countStr);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            result = 31 * result + (this.rootNode == null ? 0 : this.rootNode.hashCode());
            result = 31 * result + (this.spell == null ? 0 : this.spell.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpellNodeImpl other = (SpellNodeImpl)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.level == null ? other.level != null : !this.level.equals(other.level)) {
                return false;
            }
            if (this.spell == null ? other.spell != null : !this.spell.equals(other.spell)) {
                return false;
            }
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            return !(this.rootNode == null ? other.rootNode != null : !this.rootNode.equals(other.rootNode));
        }

        private SpellSupportFacadeImpl getOuterType() {
            return SpellSupportFacadeImpl.this;
        }
    }

    public class RootNodeImpl
    implements SpellSupportFacade.RootNode {
        private final String name;
        private final SpellBook book;

        public RootNodeImpl(String text) {
            this.name = text;
            this.book = null;
        }

        public RootNodeImpl(SpellBook book) {
            this.book = book;
            this.name = book.getName();
        }

        public String toString() {
            if (this.book != null) {
                return this.book.toString();
            }
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RootNodeImpl other = (RootNodeImpl)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

