/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentListFacade;
import pcgen.facade.core.GearBuySellFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.equip.EquipmentSelection;
import pcgen.gui2.tabs.models.BigDecimalFieldHandler;
import pcgen.gui2.tabs.models.CharacterComboBoxModel;
import pcgen.gui2.tabs.models.CharacterTreeCellRenderer;
import pcgen.gui2.tabs.models.ConcurrentDataView;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.SignIcon;
import pcgen.gui2.util.SortMode;
import pcgen.gui2.util.SortingPriority;
import pcgen.gui2.util.event.PopupMouseAdapter;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.CharacterManager;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class PurchaseInfoTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private static final Set<String> primaryTypes = new HashSet<String>();
    private final FilteredTreeViewTable<CharacterFacade, EquipmentFacade> availableTable = new FilteredTreeViewTable();
    private final FilteredTreeViewTable<CharacterFacade, EquipmentFacade> purchasedTable = new FilteredTreeViewTable();
    private final EquipmentRenderer equipmentRenderer = new EquipmentRenderer();
    private final JCheckBox autoResizeBox = new JCheckBox();
    private final JButton addCustomButton = new JButton();
    private final JButton addEquipmentButton = new JButton();
    private final JButton removeEquipmentButton = new JButton();
    private final InfoPane infoPane = new InfoPane();
    private final JFormattedTextField wealthLabel = new JFormattedTextField(NumberFormat.getNumberInstance());
    private final JFormattedTextField goldField = new JFormattedTextField(NumberFormat.getNumberInstance());
    private final JFormattedTextField goldModField = new JFormattedTextField(NumberFormat.getNumberInstance());
    private final JComboBox buySellRateBox = new JComboBox();
    private final JButton fundsAddButton = new JButton();
    private final JButton fundsSubtractButton = new JButton();
    private final JCheckBox allowDebt = new JCheckBox();
    private final List<JLabel> currencyLabels = new ArrayList<JLabel>();

    public PurchaseInfoTab() {
        super("Purchase");
        this.initComponents();
    }

    private void initComponents() {
        this.setOrientation(0);
        FlippingSplitPane splitPane = new FlippingSplitPane("PurchaseTop");
        splitPane.setOrientation(1);
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        FilterButton<CharacterFacade, EquipmentFacade> premadeFilter = new FilterButton<CharacterFacade, EquipmentFacade>("EqQualified");
        premadeFilter.setText(LanguageBundle.getString("in_igQualFilter"));
        premadeFilter.setFilter(new Filter<CharacterFacade, EquipmentFacade>(){

            @Override
            public boolean accept(CharacterFacade context, EquipmentFacade element) {
                return context.isQualifiedFor(element);
            }
        });
        FilterButton<CharacterFacade, EquipmentFacade> customFilter = new FilterButton<CharacterFacade, EquipmentFacade>("EqAffordable");
        customFilter.setText(LanguageBundle.getString("in_igAffordFilter"));
        customFilter.setFilter(new Filter<CharacterFacade, EquipmentFacade>(){

            @Override
            public boolean accept(CharacterFacade context, EquipmentFacade element) {
                return context.getInfoFactory().getCost(element) <= context.getFundsRef().getReference().floatValue();
            }
        });
        filterBar.addDisplayableFilter(premadeFilter);
        filterBar.addDisplayableFilter(customFilter);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(filterBar, "North");
        this.availableTable.getTree().setLargeModel(true);
        this.availableTable.setTreeCellRenderer(this.equipmentRenderer);
        this.availableTable.setDisplayableFilter(filterBar);
        this.availableTable.sortModel();
        panel.add((Component)new JScrollPane(this.availableTable), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(this.autoResizeBox);
        box.add(Box.createHorizontalGlue());
        this.addCustomButton.setHorizontalTextPosition(10);
        box.add(this.addCustomButton);
        box.add(Box.createHorizontalStrut(5));
        this.addEquipmentButton.setHorizontalTextPosition(10);
        box.add(this.addEquipmentButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        panel.add((Component)box, "South");
        splitPane.setLeftComponent(panel);
        filterBar = new FilterBar();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        panel = new JPanel(new BorderLayout());
        panel.add(filterBar, "North");
        this.purchasedTable.setDisplayableFilter(filterBar);
        this.purchasedTable.setTreeCellRenderer(this.equipmentRenderer);
        this.purchasedTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.purchasedTable.sortModel();
        panel.add((Component)new JScrollPane(this.purchasedTable), "Center");
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(this.removeEquipmentButton);
        box.add(Box.createHorizontalGlue());
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        panel.add((Component)box, "South");
        splitPane.setRightComponent(panel);
        this.setTopComponent(splitPane);
        splitPane = new FlippingSplitPane("PurchaseBottom");
        splitPane.setOrientation(1);
        JPanel panel2 = new JPanel();
        this.initMoneyPanel(panel2);
        splitPane.setLeftComponent(panel2);
        this.infoPane.setTitle(LanguageBundle.getString("in_igEqInfo"));
        splitPane.setRightComponent(this.infoPane);
        splitPane.setResizeWeight(0.25);
        this.setResizeWeight(1.0);
        this.setBottomComponent(splitPane);
    }

    private void initMoneyPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        GridBagConstraints leftGbc = new GridBagConstraints();
        Insets panelInsets = panel.getInsets();
        leftGbc.insets = new Insets(2, panelInsets.left, 2, 10);
        leftGbc.gridwidth = 2;
        leftGbc.fill = 2;
        leftGbc.anchor = 21;
        GridBagConstraints middleGbc = new GridBagConstraints();
        middleGbc.insets = new Insets(2, 5, 2, 5);
        middleGbc.gridwidth = 1;
        middleGbc.fill = 2;
        middleGbc.anchor = 22;
        GridBagConstraints rightGbc = new GridBagConstraints();
        rightGbc.insets = new Insets(2, 10, 2, panelInsets.right);
        rightGbc.gridwidth = 0;
        rightGbc.fill = 2;
        GridBagConstraints fullLineGbc = new GridBagConstraints();
        fullLineGbc.insets = new Insets(2, panelInsets.left, 2, panelInsets.right);
        fullLineGbc.gridwidth = 0;
        fullLineGbc.fill = 2;
        JLabel label = new JLabel(LanguageBundle.getString("in_igValueLabel"));
        panel.add((Component)label, leftGbc);
        this.wealthLabel.setEditable(false);
        this.wealthLabel.setColumns(10);
        this.wealthLabel.setHorizontalAlignment(4);
        panel.add((Component)this.wealthLabel, middleGbc);
        panel.add((Component)this.createCurrencyLabel(), rightGbc);
        label = new JLabel(LanguageBundle.getString("in_igFundsLabel"));
        panel.add((Component)label, leftGbc);
        this.goldField.setHorizontalAlignment(4);
        this.goldField.setColumns(10);
        this.goldField.setMinimumSize(new Dimension(50, this.goldField.getPreferredSize().height));
        panel.add((Component)this.goldField, middleGbc);
        panel.add((Component)this.createCurrencyLabel(), rightGbc);
        label = new JLabel(LanguageBundle.getString("in_igAddSubFundsLabel"));
        panel.add((Component)label, fullLineGbc);
        JPanel expmodPanel = new JPanel();
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        gbc2.insets = new Insets(0, 1, 0, 1);
        expmodPanel.add((Component)this.fundsAddButton, gbc2);
        expmodPanel.add((Component)this.fundsSubtractButton, gbc2);
        panel.add((Component)expmodPanel, leftGbc);
        this.goldModField.setHorizontalAlignment(4);
        panel.add((Component)this.goldModField, middleGbc);
        panel.add((Component)this.createCurrencyLabel(), rightGbc);
        label = new JLabel(LanguageBundle.getString("in_igBuySellRateLabel"));
        fullLineGbc.insets = new Insets(10, 2, 2, 2);
        panel.add((Component)label, fullLineGbc);
        this.buySellRateBox.setPrototypeDisplayValue("QuiteLongPrototypeDisplayValue");
        fullLineGbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.buySellRateBox, fullLineGbc);
        panel.add((Component)this.allowDebt, fullLineGbc);
        fullLineGbc.weighty = 1.0;
        panel.add((Component)new JLabel(), fullLineGbc);
    }

    private JLabel createCurrencyLabel() {
        JLabel label = new JLabel("");
        this.currencyLabels.add(label);
        return label;
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(final CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(AvailableTreeViewModel.class, new AvailableTreeViewModel(character));
        models.put(PurchasedTreeViewModel.class, new PurchasedTreeViewModel(character));
        models.put(UseAutoResizeAction.class, new UseAutoResizeAction(character));
        models.put(AddCustomAction.class, new AddCustomAction(character));
        models.put(AddAction.class, new AddAction(character));
        models.put(RemoveAction.class, new RemoveAction(character));
        models.put(DeleteCustomAction.class, new DeleteCustomAction(character));
        models.put(FundsAddAction.class, new FundsAddAction(character));
        models.put(FundsSubtractAction.class, new FundsSubtractAction(character));
        models.put(AllowDebtAction.class, new AllowDebtAction(character));
        models.put(EquipInfoHandler.class, new EquipInfoHandler(character));
        models.put(CharacterTreeCellRenderer.Handler.class, this.equipmentRenderer.createHandler(character));
        models.put(EquipmentFilterHandler.class, new EquipmentFilterHandler(character));
        models.put(EquipmentTransferHandler.class, new EquipmentTransferHandler(character));
        models.put(CurrencyLabelHandler.class, new CurrencyLabelHandler(character));
        models.put(BuyPopupMenuHandler.class, new BuyPopupMenuHandler(character));
        models.put(SellPopupMenuHandler.class, new SellPopupMenuHandler(character));
        models.put(CurrencyFieldHandler.class, new CurrencyFieldHandler(character));
        CharacterComboBoxModel<GearBuySellFacade> buySellModel = new CharacterComboBoxModel<GearBuySellFacade>(character.getDataSet().getGearBuySellSchemes(), character.getGearBuySellRef()){

            @Override
            public void setSelectedItem(Object anItem) {
                character.setGearBuySellRef((GearBuySellFacade)anItem);
            }
        };
        models.put(CharacterComboBoxModel.class, buySellModel);
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(EquipmentFilterHandler.class).install();
        models.get(CharacterTreeCellRenderer.Handler.class).install();
        models.get(AvailableTreeViewModel.class).install();
        this.purchasedTable.setTreeViewModel(models.get(PurchasedTreeViewModel.class));
        this.autoResizeBox.setAction(models.get(UseAutoResizeAction.class));
        this.addCustomButton.setAction(models.get(AddCustomAction.class));
        this.addEquipmentButton.setAction(models.get(AddAction.class));
        this.removeEquipmentButton.setAction(models.get(RemoveAction.class));
        this.fundsAddButton.setAction(models.get(FundsAddAction.class));
        this.fundsSubtractButton.setAction(models.get(FundsSubtractAction.class));
        this.buySellRateBox.setModel(models.get(CharacterComboBoxModel.class));
        this.allowDebt.setAction(models.get(AllowDebtAction.class));
        models.get(EquipInfoHandler.class).install();
        models.get(EquipmentTransferHandler.class).install();
        models.get(UseAutoResizeAction.class).install();
        models.get(AddAction.class).install();
        models.get(RemoveAction.class).install();
        models.get(CurrencyFieldHandler.class).install();
        models.get(CurrencyLabelHandler.class).install();
        models.get(BuyPopupMenuHandler.class).install();
        models.get(SellPopupMenuHandler.class).install();
        models.get(AllowDebtAction.class).install();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(AvailableTreeViewModel.class).uninstall();
        models.get(EquipInfoHandler.class).uninstall();
        models.get(AddAction.class).uninstall();
        models.get(RemoveAction.class).uninstall();
        models.get(CurrencyFieldHandler.class).uninstall();
        models.get(BuyPopupMenuHandler.class).uninstall();
        models.get(SellPopupMenuHandler.class).uninstall();
        models.get(CharacterTreeCellRenderer.Handler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return new TabTitle(Tab.PURCHASE);
    }

    private List<EquipmentFacade> getMenuTargets(JTable table, MouseEvent e) {
        int row = table.rowAtPoint(e.getPoint());
        if (!table.isRowSelected(row) && 0 <= row && table.getRowCount() > row) {
            table.setRowSelectionInterval(row, row);
        }
        ArrayList<EquipmentFacade> targets = new ArrayList<EquipmentFacade>();
        for (int selRow : table.getSelectedRows()) {
            Object value = table.getModel().getValueAt(selRow, 0);
            if (!(value instanceof EquipmentFacade)) continue;
            targets.add((EquipmentFacade)value);
        }
        return targets;
    }

    private class CopyItemMenuItem
    extends JMenuItem
    implements ActionListener {
        private final CharacterFacade character;
        private final CharacterFacade destination;
        private final List<EquipmentFacade> targets;

        CopyItemMenuItem(CharacterFacade character, CharacterFacade destination, List<EquipmentFacade> targets) {
            super(destination.getNameRef().getReference());
            this.character = character;
            this.destination = destination;
            this.targets = targets;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (EquipmentFacade item : this.targets) {
                this.destination.addPurchasedEquipment(item, 1, false, true);
            }
        }
    }

    private class MoveItemMenuItem
    extends JMenuItem
    implements ActionListener {
        private final CharacterFacade character;
        private final CharacterFacade destination;
        private final List<EquipmentFacade> targets;

        MoveItemMenuItem(CharacterFacade character, CharacterFacade destination, List<EquipmentFacade> targets) {
            super(destination.getNameRef().getReference());
            this.character = character;
            this.destination = destination;
            this.targets = targets;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (EquipmentFacade item : this.targets) {
                this.character.removePurchasedEquipment(item, 1, true);
                this.destination.addPurchasedEquipment(item, 1, false, true);
            }
        }
    }

    private class AddNoteMenuItem
    extends JMenuItem
    implements ActionListener {
        private final CharacterFacade character;
        private final List<EquipmentFacade> targets;

        AddNoteMenuItem(CharacterFacade character, List<EquipmentFacade> targets) {
            super(LanguageBundle.getString("in_igAddNote"));
            this.character = character;
            this.targets = targets;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.addNote(this.targets);
        }
    }

    private class ModifyChargesMenuItem
    extends JMenuItem
    implements ActionListener {
        private final CharacterFacade character;
        private final List<EquipmentFacade> targets;

        ModifyChargesMenuItem(CharacterFacade character, List<EquipmentFacade> targets) {
            super(LanguageBundle.getString("in_igModifyCharges"));
            this.character = character;
            this.targets = targets;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.modifyCharges(this.targets);
        }
    }

    private class SellNumMenuItem
    extends JMenuItem
    implements ActionListener {
        public static final int SELL_ALL_QUANTITY = -5;
        private final int quantity;
        private final CharacterFacade character;
        private final List<EquipmentFacade> targets;

        SellNumMenuItem(CharacterFacade character, List<EquipmentFacade> targets, int quantity) {
            super(LanguageBundle.getFormattedString(quantity > 0 ? "in_igSellMenuCommand" : (quantity == -5 ? "in_igSellAll" : "in_igSellN"), quantity));
            this.character = character;
            this.targets = targets;
            this.quantity = quantity;
            if (quantity > 0) {
                this.setToolTipText(LanguageBundle.getFormattedString("in_igSellMenuDesc", quantity));
            } else if (quantity == -5) {
                this.setToolTipText(LanguageBundle.getString("in_igSellAllMenuDesc"));
            } else {
                this.setToolTipText(LanguageBundle.getString("in_igSellNMenuDesc"));
            }
            this.setIcon(Icons.Remove16.getImageIcon());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedValue;
            boolean sellAll = this.quantity == -5;
            int num = this.quantity;
            if (num == 0 && (selectedValue = JOptionPane.showInputDialog(null, LanguageBundle.getString("in_igBuyEnterQuantity"), "PCGen", 3)) != null) {
                try {
                    num = (int)Float.parseFloat(selectedValue);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (num > 0 || sellAll) {
                for (EquipmentFacade equip : this.targets) {
                    if (sellAll) {
                        num = this.character.getPurchasedEquipment().getQuantity(equip);
                    }
                    this.character.removePurchasedEquipment(equip, num, false);
                }
                PurchaseInfoTab.this.availableTable.refilter();
            }
        }
    }

    private class SellPopupMenuHandler
    extends PopupMouseAdapter {
        private final CharacterFacade character;

        SellPopupMenuHandler(CharacterFacade character) {
            this.character = character;
        }

        @Override
        public void showPopup(MouseEvent e) {
            List targets = PurchaseInfoTab.this.getMenuTargets(PurchaseInfoTab.this.purchasedTable, e);
            if (targets.isEmpty()) {
                return;
            }
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(new SellNumMenuItem(this.character, targets, 1));
            JMenu sellMenu = new JMenu(LanguageBundle.getString("in_igSellQuantity"));
            sellMenu.add(new SellNumMenuItem(this.character, targets, 2));
            sellMenu.add(new SellNumMenuItem(this.character, targets, 5));
            sellMenu.add(new SellNumMenuItem(this.character, targets, 10));
            sellMenu.add(new SellNumMenuItem(this.character, targets, 15));
            sellMenu.add(new SellNumMenuItem(this.character, targets, 20));
            sellMenu.add(new SellNumMenuItem(this.character, targets, 50));
            popupMenu.add(sellMenu);
            popupMenu.add(new SellNumMenuItem(this.character, targets, 0));
            popupMenu.add(new SellNumMenuItem(this.character, targets, -5));
            popupMenu.addSeparator();
            JMenu moveMenu = new JMenu(LanguageBundle.getString("in_igMoveItemMenuTitle"));
            moveMenu.setEnabled(false);
            for (CharacterFacade dest : CharacterManager.getCharacters()) {
                if (dest == this.character) continue;
                moveMenu.add(new MoveItemMenuItem(this.character, dest, targets));
                moveMenu.setEnabled(true);
            }
            popupMenu.add(moveMenu);
            JMenu copyMenu = new JMenu(LanguageBundle.getString("in_igCopyItemMenuTitle"));
            copyMenu.setEnabled(false);
            for (CharacterFacade dest : CharacterManager.getCharacters()) {
                if (dest == this.character) continue;
                copyMenu.add(new CopyItemMenuItem(this.character, dest, targets));
                copyMenu.setEnabled(true);
            }
            popupMenu.add(copyMenu);
            popupMenu.addSeparator();
            popupMenu.add(new ModifyChargesMenuItem(this.character, targets));
            popupMenu.add(new AddNoteMenuItem(this.character, targets));
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        public void install() {
            PurchaseInfoTab.this.purchasedTable.addMouseListener(this);
        }

        public void uninstall() {
            PurchaseInfoTab.this.purchasedTable.removeMouseListener(this);
        }
    }

    private class BuyNumMenuItem
    extends JMenuItem
    implements ActionListener {
        private final int quantity;
        private final CharacterFacade character;
        private final List<EquipmentFacade> targets;

        BuyNumMenuItem(CharacterFacade character, List<EquipmentFacade> targets, int quantity) {
            super(LanguageBundle.getFormattedString(quantity > 0 ? "in_igBuyMenuCommand" : "in_igBuyN", quantity));
            this.character = character;
            this.targets = targets;
            this.quantity = quantity;
            if (quantity > 0) {
                this.setToolTipText(LanguageBundle.getFormattedString("in_igBuyMenuDesc", quantity));
            } else {
                this.setToolTipText(LanguageBundle.getString("in_igBuyNMenuDesc"));
            }
            this.setIcon(Icons.Add16.getImageIcon());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedValue;
            int num = this.quantity;
            if (num == 0 && (selectedValue = JOptionPane.showInputDialog(null, LanguageBundle.getString("in_igBuyEnterQuantity"), "PCGen", 3)) != null) {
                try {
                    num = (int)Float.parseFloat(selectedValue);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (num > 0) {
                for (EquipmentFacade equip : this.targets) {
                    if (this.character.isAutoResize()) {
                        equip = this.character.getEquipmentSizedForCharacter(equip);
                    }
                    this.character.addPurchasedEquipment(equip, num, false, false);
                    PurchaseInfoTab.this.availableTable.refilter();
                }
            }
        }
    }

    private class BuyPopupMenuHandler
    extends PopupMouseAdapter {
        private final CharacterFacade character;

        BuyPopupMenuHandler(CharacterFacade character) {
            this.character = character;
        }

        @Override
        public void showPopup(MouseEvent e) {
            List targets = PurchaseInfoTab.this.getMenuTargets(PurchaseInfoTab.this.availableTable, e);
            if (targets.isEmpty()) {
                return;
            }
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(new BuyNumMenuItem(this.character, targets, 1));
            JMenu buyMenu = new JMenu(LanguageBundle.getString("in_igBuyQuantity"));
            buyMenu.add(new BuyNumMenuItem(this.character, targets, 2));
            buyMenu.add(new BuyNumMenuItem(this.character, targets, 5));
            buyMenu.add(new BuyNumMenuItem(this.character, targets, 10));
            buyMenu.add(new BuyNumMenuItem(this.character, targets, 15));
            buyMenu.add(new BuyNumMenuItem(this.character, targets, 20));
            buyMenu.add(new BuyNumMenuItem(this.character, targets, 50));
            popupMenu.add(buyMenu);
            popupMenu.add(new BuyNumMenuItem(this.character, targets, 0));
            popupMenu.addSeparator();
            popupMenu.add(new AddCustomAction(this.character));
            popupMenu.add(new DeleteCustomAction(this.character));
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        public void install() {
            PurchaseInfoTab.this.availableTable.addMouseListener(this);
        }

        public void uninstall() {
            PurchaseInfoTab.this.availableTable.removeMouseListener(this);
        }
    }

    private class EquipmentTransferHandler
    extends TransferHandler {
        private CharacterFacade character;

        public EquipmentTransferHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            PurchaseInfoTab.this.availableTable.setDragEnabled(true);
            PurchaseInfoTab.this.availableTable.setDropMode(DropMode.ON);
            PurchaseInfoTab.this.availableTable.setTransferHandler(this);
            PurchaseInfoTab.this.purchasedTable.setDragEnabled(true);
            PurchaseInfoTab.this.purchasedTable.setDropMode(DropMode.ON);
            PurchaseInfoTab.this.purchasedTable.setTransferHandler(this);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            List<Object> data = null;
            if (c == PurchaseInfoTab.this.availableTable) {
                data = PurchaseInfoTab.this.availableTable.getSelectedData();
            } else if (c == PurchaseInfoTab.this.purchasedTable) {
                data = PurchaseInfoTab.this.purchasedTable.getSelectedData();
            }
            if (data == null) {
                return null;
            }
            Iterator<Object> it = data.iterator();
            while (it.hasNext()) {
                if (it.next() instanceof EquipmentFacade) continue;
                it.remove();
            }
            if (data.isEmpty()) {
                return null;
            }
            EquipmentFacade[] equipArray = data.toArray(new EquipmentFacade[0]);
            return new EquipmentSelection(equipArray);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(EquipmentSelection.equipmentArrayFlavor)) {
                return false;
            }
            support.setShowDropLocation(false);
            return true;
        }

        private EquipmentFacade[] getEquipmentArray(TransferHandler.TransferSupport support) {
            EquipmentFacade[] equipmentArray = null;
            try {
                equipmentArray = (EquipmentFacade[])support.getTransferable().getTransferData(EquipmentSelection.equipmentArrayFlavor);
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return equipmentArray;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            if (!support.isDrop()) {
                return false;
            }
            EquipmentFacade[] equipmentArray = this.getEquipmentArray(support);
            if (support.getComponent() == PurchaseInfoTab.this.availableTable) {
                for (EquipmentFacade equipmentFacade : equipmentArray) {
                    this.character.removePurchasedEquipment(equipmentFacade, 1, false);
                }
            } else if (support.getComponent() == PurchaseInfoTab.this.purchasedTable) {
                for (EquipmentFacade equipmentFacade : equipmentArray) {
                    EquipmentFacade equip = this.character.getEquipmentSizedForCharacter(equipmentFacade);
                    this.character.addPurchasedEquipment(equip, 1, false, false);
                }
            }
            PurchaseInfoTab.this.availableTable.refilter();
            return true;
        }
    }

    private class PurchaseTransferHandler
    extends TransferHandler {
        private CharacterFacade character;

        public PurchaseTransferHandler(CharacterFacade character) {
            this.character = character;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            List<Object> data = PurchaseInfoTab.this.purchasedTable.getSelectedData();
            if (data == null) {
                return null;
            }
            Iterator<Object> it = data.iterator();
            while (it.hasNext()) {
                if (it.next() instanceof EquipmentFacade) continue;
                it.remove();
            }
            if (data.isEmpty()) {
                return null;
            }
            EquipmentFacade[] equipArray = data.toArray(new EquipmentFacade[0]);
            return new EquipmentSelection(equipArray);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(EquipmentSelection.equipmentArrayFlavor)) {
                return false;
            }
            support.setShowDropLocation(false);
            return true;
        }
    }

    private class EquipmentFilterHandler {
        private final CharacterFacade character;

        public EquipmentFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            PurchaseInfoTab.this.availableTable.setContext(this.character);
        }
    }

    private class EquipmentRenderer
    extends CharacterTreeCellRenderer {
        private EquipmentRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            Object equipObj = ((DefaultMutableTreeNode)value).getUserObject();
            if (equipObj instanceof EquipmentFacade && !this.character.isQualifiedFor((EquipmentFacade)equipObj)) {
                this.setForeground(UIPropertyContext.getNotQualifiedColor());
            }
            return this;
        }
    }

    private static enum EquipmentTreeView implements TreeView<EquipmentFacade>
    {
        NAME(LanguageBundle.getString("in_nameLabel")),
        TYPE_NAME(LanguageBundle.getString("in_typeName")),
        TYPE_SUBTYPE_NAME(LanguageBundle.getString("in_typeSubtypeName")),
        SOURCE_NAME(LanguageBundle.getString("in_sourceName"));

        private String name;

        private EquipmentTreeView(String name) {
            this.name = name;
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<EquipmentFacade>> getPaths(EquipmentFacade pobj) {
            switch (this) {
                case TYPE_SUBTYPE_NAME: {
                    List<String> types = pobj.getTypesForDisplay();
                    if (types != null && types.size() > 1) {
                        ArrayList<TreeViewPath<EquipmentFacade>> paths = new ArrayList<TreeViewPath<EquipmentFacade>>();
                        for (String type : types) {
                            if (!primaryTypes.contains(type)) continue;
                            for (String subType : types) {
                                if (type.equals(subType)) continue;
                                paths.add(new TreeViewPath<EquipmentFacade>(pobj, type, subType));
                            }
                        }
                        return paths;
                    }
                }
                case TYPE_NAME: {
                    List<String> types = pobj.getTypesForDisplay();
                    if (types != null && types.size() > 0) {
                        ArrayList<TreeViewPath<EquipmentFacade>> paths = new ArrayList<TreeViewPath<EquipmentFacade>>(types.size());
                        for (String type : types) {
                            if (!primaryTypes.contains(type)) continue;
                            paths.add(new TreeViewPath<EquipmentFacade>(pobj, (Object)type));
                        }
                        return paths;
                    }
                }
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<EquipmentFacade>(pobj));
                }
                case SOURCE_NAME: {
                    return Collections.singletonList(new TreeViewPath<EquipmentFacade>(pobj, (Object)pobj.getSourceForNodeDisplay()));
                }
            }
            throw new InternalError();
        }
    }

    private class PurchasedTreeViewModel
    implements TreeViewModel<EquipmentFacade>,
    DataView<EquipmentFacade>,
    EquipmentListFacade.EquipmentListListener {
        private final ListFacade<? extends TreeView<EquipmentFacade>> treeviews = new DefaultListFacade<EquipmentTreeView>(Arrays.asList(EquipmentTreeView.values()));
        private final List<DefaultDataViewColumn> columns = Arrays.asList(new DefaultDataViewColumn("in_igEqModelColCost", Float.class, true), new DefaultDataViewColumn("in_igEqModelColWeight", Float.class, false), new DefaultDataViewColumn("in_igEqModelColQty", Integer.class, true), new DefaultDataViewColumn("in_descrip", String.class, false));
        private final CharacterFacade character;
        private final EquipmentListFacade equipmentList;

        public PurchasedTreeViewModel(CharacterFacade character) {
            this.character = character;
            this.equipmentList = character.getPurchasedEquipment();
            this.equipmentList.addEquipmentListListener(this);
        }

        @Override
        public ListFacade<? extends TreeView<EquipmentFacade>> getTreeViews() {
            return this.treeviews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<EquipmentFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<EquipmentFacade> getDataModel() {
            return this.equipmentList;
        }

        @Override
        public List<?> getData(EquipmentFacade obj) {
            return Arrays.asList(Float.valueOf(this.character.getInfoFactory().getCost(obj)), Float.valueOf(this.character.getInfoFactory().getWeight(obj)), this.equipmentList.getQuantity(obj), this.character.getInfoFactory().getDescription(obj));
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        @Override
        public void quantityChanged(EquipmentListFacade.EquipmentListEvent equipment) {
            PurchaseInfoTab.this.purchasedTable.refreshModelData();
        }

        @Override
        public String getPrefsKey() {
            return "Purchased";
        }
    }

    private class AvailableTreeViewModel
    extends ConcurrentDataView<EquipmentFacade>
    implements TreeViewModel<EquipmentFacade> {
        private final ListFacade<? extends TreeView<EquipmentFacade>> treeviews = new DefaultListFacade<EquipmentTreeView>(Arrays.asList(EquipmentTreeView.values()));
        private final List<DefaultDataViewColumn> columns = Arrays.asList(new DefaultDataViewColumn("in_igEqModelColCost", Float.class, true), new DefaultDataViewColumn("in_igEqModelColWeight", Float.class, true), new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_igEqModelColSource", String.class, false));
        private final CharacterFacade character;
        private final ListFacade<EquipmentFacade> equipmentList;

        public AvailableTreeViewModel(CharacterFacade character) {
            this.character = character;
            this.equipmentList = character.getDataSet().getEquipment();
            if (primaryTypes.isEmpty()) {
                for (int i = 0; i < this.equipmentList.getSize(); ++i) {
                    EquipmentFacade eq = this.equipmentList.getElementAt(i);
                    List<String> types = eq.getTypesForDisplay();
                    if (types.size() <= 0) continue;
                    primaryTypes.add(types.get(0));
                }
            }
        }

        @Override
        public ListFacade<? extends TreeView<EquipmentFacade>> getTreeViews() {
            return this.treeviews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 2;
        }

        @Override
        public DataView<EquipmentFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<EquipmentFacade> getDataModel() {
            return this.equipmentList;
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        @Override
        public String getPrefsKey() {
            return "PurchaseAvail";
        }

        @Override
        protected List<?> getDataList(EquipmentFacade obj) {
            return Arrays.asList(Float.valueOf(this.character.getInfoFactory().getCost(obj)), Float.valueOf(this.character.getInfoFactory().getWeight(obj)), this.character.getInfoFactory().getDescription(obj), obj.getSource());
        }

        @Override
        protected void refreshTableData() {
            PurchaseInfoTab.this.availableTable.refreshModelData();
        }

        @Override
        public void install() {
            super.install();
            PurchaseInfoTab.this.availableTable.setTreeViewModel(this);
        }
    }

    private class CurrencyLabelHandler {
        private CharacterFacade character;

        public CurrencyLabelHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            String currencyDisplay = this.character.getDataSet().getGameMode().getCurrencyDisplay();
            for (JLabel label : PurchaseInfoTab.this.currencyLabels) {
                label.setText(currencyDisplay);
            }
        }
    }

    private class EquipInfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private String text;
        private List<EquipmentFacade> oldList;

        public EquipInfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
            this.oldList = null;
        }

        public void install() {
            PurchaseInfoTab.this.availableTable.getSelectionModel().addListSelectionListener(this);
            PurchaseInfoTab.this.purchasedTable.getSelectionModel().addListSelectionListener(this);
            PurchaseInfoTab.this.infoPane.setText(this.text);
        }

        public void uninstall() {
            PurchaseInfoTab.this.availableTable.getSelectionModel().removeListSelectionListener(this);
            PurchaseInfoTab.this.purchasedTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FilteredTreeViewTable target = PurchaseInfoTab.this.availableTable;
            if (PurchaseInfoTab.this.purchasedTable.getSelectionModel().equals(e.getSource())) {
                target = PurchaseInfoTab.this.purchasedTable;
            }
            if (!e.getValueIsAdjusting()) {
                int[] selectedRows = target.getSelectedRows();
                ArrayList<EquipmentFacade> newList = new ArrayList<EquipmentFacade>(selectedRows.length);
                for (int row : selectedRows) {
                    Object value;
                    if (row == -1 || !((value = ((JTable)target).getModel().getValueAt(row, 0)) instanceof EquipmentFacade)) continue;
                    newList.add((EquipmentFacade)value);
                }
                if (newList.isEmpty() || newList.equals(this.oldList)) {
                    return;
                }
                this.oldList = newList;
                StringBuilder sb = new StringBuilder(2000);
                for (EquipmentFacade equip : newList) {
                    sb.append(this.character.getInfoFactory().getHTMLInfo(equip));
                }
                this.text = "<html>" + sb.toString() + "</html>";
                PurchaseInfoTab.this.infoPane.setText(this.text);
            }
        }
    }

    private class AllowDebtAction
    extends AbstractAction {
        private CharacterFacade character;

        public AllowDebtAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_igAllowDebt"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.setAllowDebt(PurchaseInfoTab.this.allowDebt.isSelected());
        }

        public void install() {
            PurchaseInfoTab.this.allowDebt.setSelected(this.character.isAllowDebt());
        }
    }

    private class FundsSubtractAction
    extends AbstractAction {
        private CharacterFacade character;

        public FundsSubtractAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", new SignIcon(SignIcon.Sign.Minus));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object value = PurchaseInfoTab.this.goldModField.getValue();
            if (value == null) {
                return;
            }
            BigDecimal modVal = new BigDecimal(((Number)value).doubleValue() * -1.0);
            this.character.adjustFunds(modVal);
        }
    }

    private class FundsAddAction
    extends AbstractAction {
        private CharacterFacade character;

        public FundsAddAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", new SignIcon(SignIcon.Sign.Plus));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object value = PurchaseInfoTab.this.goldModField.getValue();
            if (value == null) {
                return;
            }
            BigDecimal modVal = new BigDecimal(((Number)value).doubleValue());
            this.character.adjustFunds(modVal);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private CharacterFacade character;

        public RemoveAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_ieRemEq"));
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = PurchaseInfoTab.this.purchasedTable.getSelectedData();
            if (data != null) {
                for (Object object : data) {
                    this.character.removePurchasedEquipment((EquipmentFacade)object, 1, false);
                }
                PurchaseInfoTab.this.availableTable.refilter();
            }
        }

        public void install() {
            PurchaseInfoTab.this.purchasedTable.addActionListener(this);
        }

        public void uninstall() {
            PurchaseInfoTab.this.purchasedTable.removeActionListener(this);
        }
    }

    private class UseAutoResizeAction
    extends AbstractAction {
        private CharacterFacade character;

        public UseAutoResizeAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_igAutoResize"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.setAutoResize(PurchaseInfoTab.this.autoResizeBox.isSelected());
        }

        public void install() {
            PurchaseInfoTab.this.autoResizeBox.setSelected(this.character.isAutoResize());
        }
    }

    private class DeleteCustomAction
    extends AbstractAction {
        private CharacterFacade character;

        public DeleteCustomAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_igDeleteCustom"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = PurchaseInfoTab.this.availableTable.getSelectedData();
            if (data != null) {
                for (Object object : data) {
                    if (!(object instanceof EquipmentFacade)) continue;
                    EquipmentFacade equip = (EquipmentFacade)object;
                    this.character.deleteCustomEquipment(equip);
                }
            }
        }
    }

    private class AddCustomAction
    extends AbstractAction {
        private CharacterFacade character;

        public AddCustomAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_igAddCustom"));
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = PurchaseInfoTab.this.availableTable.getSelectedData();
            if (data != null) {
                for (Object object : data) {
                    if (!(object instanceof EquipmentFacade)) continue;
                    EquipmentFacade equip = (EquipmentFacade)object;
                    if (this.character.isAutoResize()) {
                        equip = this.character.getEquipmentSizedForCharacter(equip);
                    }
                    this.character.addPurchasedEquipment(equip, 1, true, false);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private CharacterFacade character;

        public AddAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_ieAddEq"));
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = PurchaseInfoTab.this.availableTable.getSelectedData();
            if (data != null) {
                for (Object object : data) {
                    if (!(object instanceof EquipmentFacade)) continue;
                    EquipmentFacade equip = (EquipmentFacade)object;
                    if (this.character.isAutoResize()) {
                        equip = this.character.getEquipmentSizedForCharacter(equip);
                    }
                    this.character.addPurchasedEquipment(equip, 1, false, false);
                }
                PurchaseInfoTab.this.availableTable.refilter();
            }
        }

        public void install() {
            PurchaseInfoTab.this.availableTable.addActionListener(this);
        }

        public void uninstall() {
            PurchaseInfoTab.this.availableTable.removeActionListener(this);
        }
    }

    private class CurrencyFieldHandler {
        private final BigDecimalFieldHandler fundsHandler;
        private final BigDecimalFieldHandler wealthHandler;

        public CurrencyFieldHandler(final CharacterFacade character) {
            this.fundsHandler = new BigDecimalFieldHandler(PurchaseInfoTab.this.goldField, character.getFundsRef()){

                @Override
                protected void valueChanged(BigDecimal value) {
                    character.setFunds(value);
                    PurchaseInfoTab.this.availableTable.refilter();
                }
            };
            this.wealthHandler = new BigDecimalFieldHandler(PurchaseInfoTab.this.wealthLabel, character.getWealthRef()){

                @Override
                protected void valueChanged(BigDecimal value) {
                }
            };
        }

        public void install() {
            this.fundsHandler.install();
            this.wealthHandler.install();
        }

        public void uninstall() {
            this.fundsHandler.uninstall();
            this.wealthHandler.uninstall();
        }
    }
}

