/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.io.IOException;
import java.io.Writer;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.AbstractPrerequisiteWriter;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;

public class PrerequisiteMultWriter
extends AbstractPrerequisiteWriter
implements PrerequisiteWriterInterface {
    private boolean allSkillTot = false;

    @Override
    public String kindHandled() {
        return null;
    }

    @Override
    public PrerequisiteOperator[] operatorsHandled() {
        return new PrerequisiteOperator[]{PrerequisiteOperator.GTEQ, PrerequisiteOperator.LT, PrerequisiteOperator.EQ, PrerequisiteOperator.NEQ};
    }

    @Override
    public void write(Writer writer, Prerequisite prereq) throws PersistenceLayerException {
        this.checkValidOperator(prereq, this.operatorsHandled());
        try {
            if (this.isSpecialCase(prereq)) {
                this.handleSpecialCase(writer, prereq);
                return;
            }
            if (this.isNegatedPreability(prereq)) {
                this.handleNegatedPreAbility(writer, prereq);
                return;
            }
            if (prereq.getPrerequisiteCount() != 0) {
                Prerequisite subreq = prereq.getPrerequisites().get(0);
                PrerequisiteWriterInterface test = PrerequisiteWriterFactory.getInstance().getWriter(subreq.getKind());
                if (test != null && test instanceof AbstractPrerequisiteWriter && ((AbstractPrerequisiteWriter)((Object)test)).specialCase(writer, prereq)) {
                    return;
                }
            }
            if (prereq.getOperator().equals((Object)PrerequisiteOperator.LT)) {
                writer.write(33);
            }
            writer.write("PREMULT:");
            writer.write(prereq.getOperand());
            writer.write(44);
            int i = 0;
            for (Prerequisite pre : prereq.getPrerequisites()) {
                if (i > 0) {
                    writer.write(44);
                }
                writer.write(91);
                PrerequisiteWriterFactory factory = PrerequisiteWriterFactory.getInstance();
                PrerequisiteWriterInterface w = factory.getWriter(pre.getKind());
                if (w != null) {
                    w.write(writer, pre);
                } else {
                    writer.write("unrecognized kind:" + pre.getKind());
                }
                writer.write(93);
                ++i;
            }
        }
        catch (IOException e) {
            throw new PersistenceLayerException(e.getMessage());
        }
    }

    private void handleSpecialCase(Writer writer, Prerequisite prereq) throws IOException {
        if (this.allSkillTot) {
            if (prereq.getOperator().equals((Object)PrerequisiteOperator.LT)) {
                writer.write(33);
            }
            writer.write("PRESKILLTOT:");
            int i = 0;
            for (Prerequisite subreq : prereq.getPrerequisites()) {
                if (i > 0) {
                    writer.write(44);
                }
                writer.write(subreq.getKey());
                ++i;
            }
            writer.write(61);
            writer.write(prereq.getOperand());
        }
    }

    private boolean isSpecialCase(Prerequisite prereq) {
        this.allSkillTot = true;
        for (Prerequisite element : prereq.getPrerequisites()) {
            if (!this.allSkillTot) break;
            if ("skill".equalsIgnoreCase(element.getKind()) && element.isTotalValues()) continue;
            this.allSkillTot = false;
        }
        if (this.allSkillTot) {
            return this.allSkillTot;
        }
        return false;
    }

    private boolean isNegatedPreability(Prerequisite prereq) {
        if (prereq.getPrerequisites().isEmpty()) {
            return false;
        }
        boolean hasNegated = false;
        for (Prerequisite element : prereq.getPrerequisites()) {
            if (!"ability".equalsIgnoreCase(element.getKind())) {
                return false;
            }
            if (element.getOperator() != PrerequisiteOperator.LT || !"1".equals(element.getOperand())) continue;
            hasNegated = true;
        }
        return hasNegated;
    }

    private void handleNegatedPreAbility(Writer writer, Prerequisite prereq) throws IOException {
        writer.write("PREABILITY:");
        writer.write(String.valueOf(Integer.parseInt(prereq.getOperand()) - 1));
        writer.write(",");
        String cat = prereq.getPrerequisites().get(0).getCategoryName();
        if (cat == null) {
            writer.write("CATEGORY=ANY");
        } else {
            writer.write("CATEGORY=" + cat);
        }
        for (Prerequisite child : prereq.getPrerequisites()) {
            writer.write(",");
            if (child.getOperator() == PrerequisiteOperator.LT) {
                writer.write("[");
            }
            writer.write(child.getKey());
            if (child.getSubKey() != null) {
                writer.write(" (");
                writer.write(child.getSubKey());
                writer.write(")");
            }
            if (child.getOperator() != PrerequisiteOperator.LT) continue;
            writer.write("]");
        }
    }
}

