/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.util.TokenFamily;

public class TokenFamilyIterator<C>
implements Iterator<CDOMPrimaryToken<? super C>> {
    private static final Class<Object> OBJECT_CLASS = Object.class;
    private CDOMPrimaryToken<? super C> nextToken = null;
    private boolean needNewToken = true;
    private Class<?> actingClass;
    private Iterator<CDOMToken<?>> subIterator;
    private final Set<String> used = new HashSet<String>();

    public TokenFamilyIterator(Class<C> cl) {
        this.actingClass = cl;
        this.subIterator = TokenFamily.CURRENT.getTokens(cl).iterator();
    }

    @Override
    public CDOMPrimaryToken<? super C> next() {
        this.setNext();
        if (this.nextToken == null) {
            throw new NoSuchElementException();
        }
        this.needNewToken = true;
        return this.nextToken;
    }

    private void setNext() {
        if (this.needNewToken) {
            this.nextToken = this.getNext();
            if (this.nextToken != null) {
                String tokenName = this.nextToken.getTokenName();
                if (this.used.contains(tokenName)) {
                    this.needNewToken = true;
                    this.setNext();
                } else {
                    this.used.add(this.nextToken.getTokenName());
                }
            }
        }
    }

    private CDOMPrimaryToken<? super C> getNext() {
        this.needNewToken = false;
        while (this.subIterator.hasNext()) {
            CDOMToken<?> tok = this.subIterator.next();
            if (!(tok instanceof CDOMPrimaryToken)) continue;
            CDOMPrimaryToken pt = (CDOMPrimaryToken)tok;
            return pt;
        }
        if (OBJECT_CLASS.equals(this.actingClass)) {
            return null;
        }
        this.actingClass = this.actingClass.getSuperclass();
        this.subIterator = TokenFamily.CURRENT.getTokens(this.actingClass).iterator();
        return this.getNext();
    }

    @Override
    public boolean hasNext() {
        this.setNext();
        return this.nextToken != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator does not support remove");
    }
}

