/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.display.SkillDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SkillToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;

public class SkillSubsetToken
extends SkillToken {
    public static final String TOKEN_NAME = "SKILLSUBSET";

    @Override
    public String getTokenName() {
        return TOKEN_NAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        SkillToken.SkillDetails details = SkillSubsetToken.buildSkillDetails(tokenSource);
        if (details.getPropertyCount() < 2) {
            return "";
        }
        Skill aSkill = this.getSkill(tokenSource, pc, details, eh);
        return this.getSkillProperty(aSkill, details.getProperty(1), pc);
    }

    private Skill getSkill(String tokenSource, PlayerCharacter pc, SkillToken.SkillDetails details, ExportHandler eh) {
        int skillIndex;
        try {
            skillIndex = Integer.parseInt(details.getSkillId());
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Error replacing SKILLSUBSET." + tokenSource, exc);
            return null;
        }
        String skillPrefix = details.getProperty(0);
        int prefixLength = skillPrefix.length();
        ArrayList<Skill> skillSubset = new ArrayList<Skill>();
        List<Skill> skills = SkillDisplay.getSkillListInOutputOrder(pc, pc.getDisplay().getPartialSkillList(View.VISIBLE_EXPORT));
        for (Skill bSkill : skills) {
            if (!skillPrefix.regionMatches(true, 0, bSkill.getKeyName(), 0, prefixLength)) continue;
            skillSubset.add(bSkill);
        }
        if (skillIndex >= skillSubset.size() - 1 && eh != null && eh.getExistsOnly()) {
            eh.setNoMoreItems(true);
        }
        Skill aSkill = null;
        if (skillIndex <= skillSubset.size() - 1) {
            aSkill = (Skill)skillSubset.get(skillIndex);
        }
        return aSkill;
    }
}

