/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.NonInteractive;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class AddLst
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    @Override
    public String getTokenName() {
        return "ADD";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (obj instanceof NonInteractive) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Non-Interactive object type: " + obj.getClass().getSimpleName(), context);
        }
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            block11: {
                if (".CLEAR".equals(value)) {
                    if (obj instanceof PCClassLevel) {
                        ComplexParseResult cpr = new ComplexParseResult();
                        cpr.addErrorMessage("Warning: You performed an invalid .CLEAR in a ADD: Token");
                        cpr.addErrorMessage("  A non-level limited .CLEAR was used in a Class Level line in " + obj.getKeyName());
                        return cpr;
                    }
                } else {
                    if (value.startsWith(".CLEAR.LEVEL")) {
                        if (!(obj instanceof PCClassLevel)) {
                            ComplexParseResult cpr = new ComplexParseResult();
                            cpr.addErrorMessage("Warning: You performed an invalid .CLEAR in a ADD: Token");
                            cpr.addErrorMessage("  A level limited .CLEAR ( " + value + " ) was not used in a Class Level line in " + obj.getClass().getSimpleName() + " " + obj.getKeyName());
                            return cpr;
                        }
                        String levelString = value.substring(12);
                        try {
                            int level = Integer.parseInt(levelString);
                            if (level != obj.get(IntegerKey.LEVEL)) {
                                ComplexParseResult cpr = new ComplexParseResult();
                                cpr.addErrorMessage("Warning: You performed an invalid .CLEAR in a ADD: Token");
                                cpr.addErrorMessage("  A level limited .CLEAR ( " + value + " ) was used in a Class Level line");
                                cpr.addErrorMessage("  But was asked to clear a different Class Level ( " + level + " ) than the Class Level Line it appeared on: " + obj.getKeyName());
                                return cpr;
                            }
                            break block11;
                        }
                        catch (NumberFormatException e) {
                            ComplexParseResult cpr = new ComplexParseResult();
                            cpr.addErrorMessage("Warning: You performed an invalid .CLEAR in a ADD: Token");
                            cpr.addErrorMessage("  A level limited .CLEAR ( " + value + " ) was used in a Class Level line");
                            cpr.addErrorMessage("  But the level ( " + levelString + " ) was not an integer in: " + obj.getKeyName());
                            return cpr;
                        }
                    }
                    return new ParseResult.Fail(this.getTokenName() + " requires a SubToken and argument, found: " + value, context);
                }
            }
            context.getObjectContext().removeList(obj, ListKey.ADD);
            return ParseResult.SUCCESS;
        }
        return context.processSubToken(obj, this.getTokenName(), value.substring(0, pipeLoc), value.substring(pipeLoc + 1));
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        String[] unparsed = context.unparseSubtoken(obj, this.getTokenName());
        Changes<PersistentTransitionChoice<?>> changes = context.getObjectContext().getListChanges(obj, ListKey.ADD);
        if (changes.includesGlobalClear()) {
            String[] returnVal;
            if (unparsed == null) {
                returnVal = new String[1];
            } else {
                returnVal = new String[unparsed.length + 1];
                System.arraycopy(unparsed, 0, returnVal, 1, unparsed.length);
            }
            StringBuilder clearSB = new StringBuilder();
            clearSB.append(".CLEAR");
            if (obj instanceof PCClassLevel) {
                clearSB.append(".LEVEL");
                Integer lvl = obj.get(IntegerKey.LEVEL);
                clearSB.append(lvl);
            }
            returnVal[0] = clearSB.toString();
            unparsed = returnVal;
        }
        return unparsed;
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

