/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.content.ConditionalSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class EquipToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
ChooseSelectionActor<Equipment> {
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    public String getParentToken() {
        return "AUTO";
    }

    public String getTokenName() {
        return "EQUIP";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String equipItems;
        Prerequisite prereq = null;
        boolean isPre = false;
        if (value.indexOf("[") == -1) {
            equipItems = value;
            StringTokenizer tok = new StringTokenizer(equipItems, "|");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (!PreParserFactory.isPreReqString((String)token)) continue;
                if (isPre) {
                    String errorText = "Invalid " + this.getTokenName() + ": " + value + "  PRExxx must be at the END of the Token";
                    Logging.errorPrint((String)errorText);
                    return new ParseResult.Fail(errorText, context);
                }
                prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    return new ParseResult.Fail("Error generating Prerequisite " + prereq + " in " + this.getFullName(), context);
                }
                int preStart = value.indexOf(token) - 1;
                equipItems = value.substring(0, preStart);
                isPre = true;
            }
        } else {
            return new ParseResult.Fail("Use of [] for Prerequisites is no longer supported, please use | based standard", context);
        }
        ParseResult pr = this.checkForIllegalSeparator('|', equipItems);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer tok = new StringTokenizer(equipItems, "|");
        while (tok.hasMoreTokens()) {
            String aProf = tok.nextToken();
            if ("%LIST".equals(aProf)) {
                EquipToken cra;
                if (prereq == null) {
                    cra = this;
                } else {
                    ConditionalSelectionActor cca = new ConditionalSelectionActor((ChooseSelectionActor)this);
                    cca.addPrerequisite(prereq);
                    cra = cca;
                }
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, (Object)cra);
                continue;
            }
            CDOMReference ref = TokenUtilities.getTypeOrPrimitive((LoadContext)context, EQUIPMENT_CLASS, (String)aProf);
            if (ref == null) {
                return ParseResult.INTERNAL_ERROR;
            }
            context.getObjectContext().addToList(obj, ListKey.EQUIPMENT, (Object)new QualifiedObject((Object)ref, prereq));
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Collection listAdded;
        ArrayList<String> list = new ArrayList<String>();
        PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
        Changes listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.EQUIPMENT);
        Collection added = changes.getAdded();
        HashMapToList m = new HashMapToList();
        if (added != null) {
            for (QualifiedObject qo : added) {
                m.addToListFor((Object)qo.getPrerequisiteList(), qo.getRawObject());
            }
        }
        if ((listAdded = listChanges.getAdded()) != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor cra : listAdded) {
                if (!cra.getSource().equals(this.getTokenName())) continue;
                try {
                    list.add(cra.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
            }
        }
        for (List prereqs : m.getKeySet()) {
            List eq = m.getListFor((Object)prereqs);
            WeightedCollection refs = new WeightedCollection(ReferenceUtilities.REFERENCE_SORTER);
            refs.addAll((Collection)eq);
            String ab = ReferenceUtilities.joinLstFormat((Collection)refs, (String)"|");
            if (prereqs != null && !prereqs.isEmpty()) {
                if (prereqs.size() > 1) {
                    context.addWriteMessage("Error: " + obj.getClass().getSimpleName() + " had more than one Prerequisite for " + this.getFullName());
                    return null;
                }
                Prerequisite p = (Prerequisite)prereqs.get(0);
                StringWriter swriter = new StringWriter();
                try {
                    prereqWriter.write((Writer)swriter, p);
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
                ab = ab + '|' + swriter.toString();
            }
            list.add(ab);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(ChooseDriver obj, Equipment e, PlayerCharacter pc) {
        e = e.clone();
        e.setQty(1.0);
        e.setAutomatic(true);
        pc.addAutoEquipment(e, (Object)obj);
    }

    public void removeChoice(ChooseDriver obj, Equipment e, PlayerCharacter pc) {
        pc.removeAutoEquipment(e, (Object)obj);
    }

    public Class<Equipment> getChoiceClass() {
        return EQUIPMENT_CLASS;
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "%LIST";
    }
}

