/*
 * Decompiled with CFR 0.152.
 */
package plugin.qualifier.skill;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.converter.AddFilterConverter;
import pcgen.cdom.converter.NegateFilterConverter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.util.Logging;

public class ClassToken
implements QualifierToken<Skill>,
PrimitiveFilter<Skill> {
    private PrimitiveCollection<Skill> pcs = null;
    private boolean wasRestricted = false;
    private boolean negated = false;

    public String getTokenName() {
        return "CLASS";
    }

    public Class<Skill> getReferenceClass() {
        return Skill.class;
    }

    public String getLSTformat(boolean useAny) {
        StringBuilder sb = new StringBuilder();
        if (this.negated) {
            sb.append('!');
        }
        sb.append(this.getTokenName());
        if (this.wasRestricted) {
            sb.append('[').append(this.pcs.getLSTformat(useAny)).append(']');
        }
        return sb.toString();
    }

    public boolean initialize(LoadContext context, SelectionCreator<Skill> sc, String condition, String value, boolean negate) {
        if (condition != null) {
            Logging.addParseMessage((Level)Level.SEVERE, (String)("Cannot make " + this.getTokenName() + " into a conditional Qualifier, remove ="));
            return false;
        }
        this.negated = negate;
        if (value == null) {
            this.pcs = sc.getAllReference();
        } else {
            this.pcs = context.getPrimitiveChoiceFilter(sc, value);
            this.wasRestricted = true;
        }
        return this.pcs != null;
    }

    public GroupingState getGroupingState() {
        GroupingState gs = this.pcs == null ? GroupingState.ANY : this.pcs.getGroupingState().reduce();
        return this.negated ? gs.negate() : gs;
    }

    public int hashCode() {
        return this.pcs == null ? 0 : this.pcs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassToken) {
            ClassToken other = (ClassToken)o;
            if (this.negated == other.negated) {
                if (this.pcs == null) {
                    return other.pcs == null;
                }
                return this.pcs.equals(other.pcs);
            }
        }
        return false;
    }

    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Skill, R> c) {
        AddFilterConverter conv = new AddFilterConverter(c, (PrimitiveFilter)this);
        conv = this.negated ? new NegateFilterConverter((Converter)conv) : conv;
        return this.pcs.getCollection(pc, (Converter)conv);
    }

    public boolean allow(PlayerCharacter pc, Skill sk) {
        Set classlist = pc.getClassSet();
        for (PCClass cl : classlist) {
            if (!pc.isClassSkill(cl, sk)) continue;
            return true;
        }
        return false;
    }
}

