/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.io.SimpleFileFilter;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.FileMenuOpenMessage;
import gmgen.pluginmgr.messages.GMGenBeingClosedMessage;
import gmgen.pluginmgr.messages.RequestAddPreferencesPanelMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.Utility;
import pcgen.io.PCGFile;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.pluginmgr.messages.RequestOpenPlayerCharacterMessage;
import pcgen.system.LanguageBundle;
import plugin.notes.gui.NotesView;
import plugin.notes.gui.PreferencesNotesPanel;

public class NotesPlugin
implements InteractivePlugin {
    public static final String EXTENSION_NOTES = "gmn";
    public static final String LOG_NAME = "Notes";
    private static final String OPTION_NAME_SYSTEM = "Notes.System";
    private static final String OPTION_NAME_LOADORDER = "Notes.LoadOrder";
    private static final String OPTION_NAME_DATADIR = "Notes.DataDir";
    private JMenuItem notesToolsItem = new JMenuItem();
    private NotesView theView;
    private static final String NAME = "Notes";
    private static final String IN_NAME = "in_plugin_notes_name";
    private String version = "01.00.99.01.00";
    private PCGenMessageHandler messageHandler;

    public static FileFilter getFileType() {
        String[] fileExt = new String[]{EXTENSION_NOTES};
        return new SimpleFileFilter(fileExt, LanguageBundle.getString((String)"in_plugin_notes_file"));
    }

    public FileFilter[] getFileTypes() {
        FileFilter[] ff = new FileFilter[]{NotesPlugin.getFileType()};
        return ff;
    }

    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        String name = this.getPluginName();
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddPreferencesPanelMessage((Object)this, name, (PreferencesPanel)new PreferencesNotesPanel()));
        this.theView = new NotesView(this.getDataDirectory(), this);
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddTabToGMGenMessage((Object)this, name, (Component)this.getView()));
        this.initMenus();
    }

    public void stop() {
        this.messageHandler = null;
    }

    public int getPriority() {
        return SettingsHandler.getGMGenOption((String)OPTION_NAME_LOADORDER, (int)70);
    }

    public String getPluginName() {
        return "Notes";
    }

    public String getLocalizedName() {
        return LanguageBundle.getString((String)IN_NAME);
    }

    public boolean isRecognizedFileType(File launch) {
        return PCGFile.isPCGenCharacterOrPartyFile((File)launch);
    }

    public JPanel getView() {
        return this.theView;
    }

    public void handleMessage(PCGenMessage message) {
        if (message instanceof FocusOrStateChangeOccurredMessage) {
            this.handleStateChangedMessage((FocusOrStateChangeOccurredMessage)message);
        } else if (message instanceof GMGenBeingClosedMessage) {
            this.handleWindowClosedMessage();
        } else if (message instanceof FileMenuOpenMessage) {
            this.handleFileOpenMessage();
        }
    }

    public void loadRecognizedFileType(File launch) {
        this.messageHandler.handleMessage((PCGenMessage)new RequestOpenPlayerCharacterMessage((Object)this, launch, false));
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!(tp.getComponentAt(i) instanceof NotesView)) continue;
            tp.setSelectedIndex(i);
        }
    }

    private void handleFileOpenMessage() {
        if (this.isActive()) {
            this.theView.handleOpen();
        }
    }

    private void handleStateChangedMessage(FocusOrStateChangeOccurredMessage message) {
        FocusOrStateChangeOccurredMessage smessage = message;
        if (this.isActive()) {
            this.notesToolsItem.setEnabled(false);
            JMenu editMenu = smessage.getEditMenu();
            if (editMenu != null) {
                this.theView.initEditMenu(editMenu);
            }
            this.theView.refreshTree();
            try {
                GMGenSystem.inst.openFileItem.setEnabled(true);
            }
            catch (Exception e) {}
        } else {
            this.notesToolsItem.setEnabled(true);
            this.theView.refreshTree();
        }
    }

    private void handleWindowClosedMessage() {
        this.theView.windowClosed();
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor((Component)this.theView);
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.theView);
    }

    private void initMenus() {
        this.notesToolsItem.setMnemonic(LanguageBundle.getMnemonic((String)"in_mn_plugin_notes_name"));
        this.notesToolsItem.setText(this.getLocalizedName());
        this.notesToolsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesPlugin.this.toolMenuItem(evt);
            }
        });
        this.messageHandler.handleMessage((PCGenMessage)new AddMenuItemToGMGenToolsMenuMessage((Object)this, this.notesToolsItem));
    }

    public File getDataDirectory() {
        String notesDataDir = SettingsHandler.getGMGenOption((String)OPTION_NAME_DATADIR, (String)"");
        if (StringUtils.isEmpty((String)notesDataDir)) {
            return this.defaultDataDir();
        }
        return new File(notesDataDir);
    }

    public File defaultDataDir() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }
}

