/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.ChallengeRating;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Race;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;

public class CrToken
extends AbstractNonEmptyToken<Race>
implements CDOMPrimaryToken<Race>,
DeferredToken<Race> {
    public String getTokenName() {
        return "CR";
    }

    public ParseResult parseNonEmptyToken(LoadContext context, Race race, String value) {
        try {
            int intRating = Integer.parseInt(value.startsWith("1/") ? value.substring(2) : value);
            if (intRating < 0) {
                return new ParseResult.Fail(this.getTokenName() + " Challenge Rating cannot be negative", context);
            }
        }
        catch (NumberFormatException e) {
            return new ParseResult.Fail(this.getTokenName() + "Challenge Rating must be a positive integer i or 1/i", context);
        }
        Formula formula = FormulaFactory.getFormulaFor((String)value);
        if (!formula.isValid()) {
            return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + formula.toString(), context);
        }
        ChallengeRating cr = new ChallengeRating(formula);
        context.getObjectContext().put((CDOMObject)race, ObjectKey.CHALLENGE_RATING, (Object)cr);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Race race) {
        ChallengeRating cr = (ChallengeRating)context.getObjectContext().getObject((CDOMObject)race, ObjectKey.CHALLENGE_RATING);
        if (cr == null) {
            return null;
        }
        return new String[]{cr.getLSTformat()};
    }

    public Class<Race> getTokenClass() {
        return Race.class;
    }

    public boolean process(LoadContext context, Race race) {
        Formula levelAdjFormula = race.getSafe(FormulaKey.LEVEL_ADJUSTMENT);
        if (levelAdjFormula.isStatic()) {
            Number la = levelAdjFormula.resolveStatic();
            ChallengeRating cr = (ChallengeRating)race.get(ObjectKey.CHALLENGE_RATING);
            if (la.floatValue() != 0.0f && cr == null) {
                race.put(ObjectKey.CHALLENGE_RATING, (Object)new ChallengeRating(FormulaFactory.getFormulaFor((String)la.toString())));
            }
        }
        return true;
    }

    public Class<Race> getDeferredTokenClass() {
        return Race.class;
    }
}

