/*
 * Decompiled with CFR 0.152.
 */
package mill.scalalib;

import java.io.File;
import java.io.Serializable;
import mill.api.Ctx;
import mill.api.PathRef;
import mill.api.PathRef$;
import mill.api.Result;
import mill.api.Result$;
import mill.define.Cacher;
import mill.define.Caller;
import mill.define.Ctx$;
import mill.define.Target;
import mill.define.Target$;
import mill.define.TargetImpl;
import mill.main.client.Util;
import mill.moduledefs.Scaladoc;
import mill.package$;
import mill.scalalib.WithZincWorker;
import os.Inherit$;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathConvertible$StringConvertible$;
import os.ProcessInput;
import os.ProcessOutput;
import os.RelPath$;
import os.Shellable;
import os.Shellable$;
import os.exists$;
import os.proc;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;
import sourcecode.Enclosing;
import sourcecode.Line;
import upickle.default$;

@Scaladoc(value="/**\n * Provides a [[NativeImageModule.nativeImage task]] to build a native executable using [[https://www.graalvm.org/ Graal VM]].\n *\n * It is recommended to specify a custom JDK that includes the `native-image` Tool.\n * {{{\n * trait AppModule extends NativeImageModule {\n *   def zincWorker = ModuleRef(ZincWorkerGraalvm)\n *\n *   object ZincWorkerGraalvm extends ZincWorkerModule {\n *     def jvmId = \"graalvm-community:23.0.1\"\n *   }\n * }\n * }}}\n */")
@ScalaSignature(bytes="\u0006\u0005=4q\u0001C\u0005\u0011\u0002\u0007\u0005a\u0002C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003&\u0001\u0019\u0005a\u0005C\u0003?\u0001\u0019\u0005q\bC\u0003J\u0001\u0011\u0005!\nC\u0003W\u0001\u0011\u0005a\u0005C\u0003[\u0001\u0011\u00051\fC\u0003b\u0001\u0011\u0005!JA\tOCRLg/Z%nC\u001e,Wj\u001c3vY\u0016T!AC\u0006\u0002\u0011M\u001c\u0017\r\\1mS\nT\u0011\u0001D\u0001\u0005[&dGn\u0001\u0001\u0014\u0007\u0001y\u0011\u0004\u0005\u0002\u0011-9\u0011\u0011\u0003F\u0007\u0002%)\u00111cC\u0001\u0007I\u00164\u0017N\\3\n\u0005U\u0011\u0012AB'pIVdW-\u0003\u0002\u00181\tI!)Y:f\u00072\f7o\u001d\u0006\u0003+I\u0001\"AG\u000e\u000e\u0003%I!\u0001H\u0005\u0003\u001d]KG\u000f\u001b.j]\u000e<vN]6fe\u00061A%\u001b8ji\u0012\"\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG/\u0001\u0007sk:\u001cE.Y:ta\u0006$\b.F\u0001(!\rA\u0003g\r\b\u0003S9r!AK\u0017\u000e\u0003-R!\u0001L\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0011BA\u0018\f\u0003\u001d\u0001\u0018mY6bO\u0016L!!\r\u001a\u0003\u0003QS!aL\u0006\u0011\u0007QB4H\u0004\u00026o9\u0011!FN\u0005\u0002E%\u0011q&I\u0005\u0003si\u00121aU3r\u0015\ty\u0013\u0005\u0005\u0002)y%\u0011QH\r\u0002\b!\u0006$\bNU3g\u000391\u0017N\\1m\u001b\u0006Lgn\u00117bgN,\u0012\u0001\u0011\t\u0004QA\n\u0005C\u0001\"G\u001d\t\u0019E\t\u0005\u0002+C%\u0011Q)I\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002FC\u0005Ya.\u0019;jm\u0016LU.Y4f+\u0005Y\u0005c\u0001\u00151w!\"A!T*U!\tq\u0015+D\u0001P\u0015\t\u00016\"\u0001\u0006n_\u0012,H.\u001a3fMNL!AU(\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013!V\u0001\u0003`>R#F\u0003\u0011!A)\u00023l\u00175uiB\u001c(hL\u0018xo^tsM]1bYZlgf\u001c:h_1\fG/Z:u_I,g-\u001a:f]\u000e,W&\\1ok\u0006dwF\\1uSZ,W&[7bO\u0016|3E\u001a:p[6\nWf\u00197bgN\u0004#)^5mIN\u0004\u0013\r\t8bi&4X\rI3yK\u000e,H/\u00192mKvk\u0006EZ8sAQD\u0017n\u001d\u0006!A\u0001R\u0003%\\8ek2,\u0007e^5uQ\u0002Z6LZ5oC2l\u0015-\u001b8DY\u0006\u001c8/X/!CN\u0004C\u000f[3!CB\u0004H.[2bi&|g\u000eI3oiJL\b\u0005]8j]Rt#\u0002\t\u0011!U)\u0001\u0003\u0005\t\u0016!\u0001B\f'/Y7!CJ<7\u000fI!eI&$\u0018n\u001c8bY\u0002z\u0007\u000f^5p]N\u0004cm\u001c:!i\",\u0007\u0005\u00198bi&4X-L5nC\u001e,\u0007\r\t+p_2t\u0003%V:fA\u0019|'O\u0003\u0011!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002\u0003/Y:tS:<\u0007\u0005Z3ck\u001e\u0004s\u000e\u001d;j_:\u001c(\u0002\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0002\u0018m]:j]\u001e\u0004C/\u0019:hKR\u00043\u000f]3dS\u001aL7\rI8qi&|gn\u001d\u0006!A\u0001Rs&\u0001\u000boCRLg/Z%nC\u001e,7\t\\1tgB\fG\u000f\u001b\u0015\u0005\u000b5\u001b\u0006,I\u0001Z\u0003}{#F\u000b\u0006!A\u0001R\u0003\u0005\u00165fA\rd\u0017m]:qCRD\u0007\u0005^8!kN,\u0007\u0005^8!O\u0016tWM]1uK\u0002\"\b.\u001a\u0011oCRLg/\u001a\u0011j[\u0006<WM\f\u0011EK\u001a\fW\u000f\u001c;tAQ|\u0007eW.sk:\u001cE.Y:ta\u0006$\b.X//\u0015\u0001\u0002\u0003EK\u0018\u0002%9\fG/\u001b<f\u00136\fw-Z(qi&|gn]\u000b\u00029B\u0019\u0001\u0006M/\u0011\u0007QB\u0014\t\u000b\u0003\u0007\u001bN{\u0016%\u00011\u0002\u0003\u0013z#F\u000b\u0006!A\u0001R\u0003%\u00113eSRLwN\\1mA=\u0004H/[8og\u00022wN\u001d\u0011uQ\u0016\u0004\u0003M\\1uSZ,W&[7bO\u0016\u0004\u0007\u0005V8pY:R\u0001\u0005\t\u0011+\u0015\u0001\u0002\u0003E\u000b\u0011A]>$X\rI%uA%\u001c\bE]3d_6lWM\u001c3fI\u0002\"x\u000e\t:fgR\u0014\u0018n\u0019;!i\"L7\u000f\t7jgR\u0004Co\u001c\u0011paRLwN\\:!i\"\fG\u000fI2b]\u0002\u0012W\rI:iCJ,G\rI1de>\u001c8\u000f\t;be\u001e,Go\u001d\u0018\u000bA\u0001\u0002#fL\u0001\u0010]\u0006$\u0018N^3J[\u0006<W\rV8pY\"\"q!T*dC\u0005!\u0017Aa$0U)R\u0001\u0005\t\u0011+AA\u000bG\u000f\u001b\u0011u_\u0002\"\b.\u001a\u0011\\7\"$H\u000f]:;_=:xo\u001e\u0018he\u0006\fGN^7/_J<w\u0006\\1uKN$xF]3gKJ,gnY3.[\u0006tW/\u001970]\u0006$\u0018N^3.S6\fw-Z\u0018!A:\fG/\u001b<f[%l\u0017mZ3aAQ{w\u000e\\/^])\u0001\u0003\u0005\t\u0016!\t\u00164\u0017-\u001e7ug\u0002\"x\u000eI1!a\u0006$\b\u000e\t:fY\u0006$\u0018N^3!i>T\u0001\u0005\t\u0011+A\u0001j\u0003eW.[S:\u001cwk\u001c:lKJlu\u000eZ;mK:R\u0017M^1I_6,W,\u0018\u0017!S\u001a\u0004C-\u001a4j]\u0016$'\u0002\t\u0011!U\u0001\u0002S\u0006I3om&\u0014xN\\7f]R\u0004c/\u0019:jC\ndW\r\t1H%\u0006\u000bEJV'`\u0011>kU\t\u0019\u0017!S\u001a\u0004C-\u001a4j]\u0016$'\u0002\t\u0011!U)\u0001\u0003\u0005\t\u0016!\u0001:|G/\u001a\u0011UQ\u0016\u0004C/Y:lA\u0019\f\u0017\u000e\\:!S\u001a\u0004C\u000f[3!A:\fG/\u001b<f[%l\u0017mZ3aAQ{w\u000e\u001c\u0011jg\u0002rw\u000e\u001e\u0011g_VtGM\f\u0006!A\u0001Rs\u0006\u000b\u0003\u0001\u001bN3\u0017%A4\u0002\u0007\u000f{#F\u000b\u0006!U\u0001\u0002&o\u001c<jI\u0016\u001c\b%\u0019\u0011\\7:\u000bG/\u001b<f\u00136\fw-Z'pIVdWM\f8bi&4X-S7bO\u0016\u0004C/Y:l;v\u0003Co\u001c\u0011ck&dG\rI1!]\u0006$\u0018N^3!Kb,7-\u001e;bE2,\u0007%^:j]\u001e\u00043l\u00175uiB\u001c(hL\u0018xo^tsM]1bYZlgf\u001c:h_\u0001:%/Y1mAYkU,\u0018\u0018\u000bA)R\u0001E\u000b\u0011Ji\u0002J7\u000f\t:fG>lW.\u001a8eK\u0012\u0004Co\u001c\u0011ta\u0016\u001c\u0017NZ=!C\u0002\u001aWo\u001d;p[\u0002REi\u0013\u0011uQ\u0006$\b%\u001b8dYV$Wm\u001d\u0011uQ\u0016\u0004\u0003M\\1uSZ,W&[7bO\u0016\u0004\u0007\u0005V8pY:R\u0001E\u000b\u0011|wnT\u0001E\u000b\u0011ue\u0006LG\u000fI!qa6{G-\u001e7fA\u0015DH/\u001a8eg\u0002r\u0015\r^5wK&k\u0017mZ3N_\u0012,H.\u001a\u0011|\u0015\u0001R\u0003\u0005\t\u0011eK\u001a\u0004#0\u001b8d/>\u00148.\u001a:!{\u0001ju\u000eZ;mKJ+g\r\u000b.j]\u000e<vN]6fe\u001e\u0013\u0018-\u00197w[&R\u0001E\u000b\u0006!U\u0001\u0002\u0003e\u001c2kK\u000e$\bEW5oG^{'o[3s\u000fJ\f\u0017\r\u001c<nA\u0015DH/\u001a8eg\u0002R\u0016N\\2X_J\\WM]'pIVdW\rI>\u000bA)\u0002\u0003\u0005\t\u0011!I\u00164\u0007E\u001b<n\u0013\u0012\u0004S\b\t\u0012he\u0006\fGN^7.G>lW.\u001e8jifT$g\r\u00181]E\u0012#\u0002\t\u0016!A\u0001j(\u0002\t\u0016!{*\u0001#\u0006I?~{*\u0001#f\f\u0015\u0003\u0001%\u0004\"A[7\u000e\u0003-T!\u0001\\\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0002oW\naQ\r\u001f9fe&lWM\u001c;bY\u0002")
public interface NativeImageModule
extends WithZincWorker {
    public Target<Seq<PathRef>> runClasspath();

    public Target<String> finalMainClass();

    public static /* synthetic */ Target nativeImage$(NativeImageModule $this) {
        return $this.nativeImage();
    }

    @Scaladoc(value="/**\n   * [[https://www.graalvm.org/latest/reference-manual/native-image/#from-a-class Builds a native executable]] for this\n   * module with [[finalMainClass]] as the application entry point.\n   *\n   * @param args Additional options for the `native-image` Tool. Use for\n   *             - passing debug options\n   *             - passing target specific options\n   */")
    default public Target<PathRef> nativeImage() {
        return (Target)((Cacher)((Object)this)).cachedTarget((Function0<TargetImpl> & Serializable)() -> new TargetImpl(package$.MODULE$.Task().traverseCtx(new $colon$colon<Nothing$>((Nothing$)((Object)this.nativeImageTool()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.nativeImageOptions()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.nativeImageClasspath()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.finalMainClass()), Nil$.MODULE$)))), (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> Result$.MODULE$.create((Function0<PathRef> & Serializable)() -> {
            Path dest = package$.MODULE$.Task().dest((Ctx.Dest)ctx$macro$2);
            String executeableName = "native-executable";
            Seq command = (Seq)((Builder)scala.package$.MODULE$.Seq().newBuilder().$plus$eq(((PathRef)items$macro$1.apply(false)).path().toString()).$plus$plus$eq((Seq)items$macro$1.apply(true)).$plus$eq("-cp").$plus$eq(((Seq)items$macro$1.apply(2)).iterator().map((Function1<PathRef, Path> & Serializable)x$1 -> x$1.path()).mkString(File.pathSeparator)).$plus$eq((String)items$macro$1.apply(3)).$plus$eq(dest.$div(new PathChunk.StringPathChunk(executeableName)).toString())).result();
            proc qual$1 = new proc(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.IterableShellable(command, (Function1<String, Shellable> & Serializable)s -> Shellable$.MODULE$.StringShellable((String)s))}));
            Path x$3 = dest;
            Inherit$ x$4 = Inherit$.MODULE$;
            Map<String, String> x$5 = qual$1.call$default$2();
            ProcessInput x$6 = qual$1.call$default$3();
            ProcessOutput x$7 = qual$1.call$default$5();
            boolean x$8 = qual$1.call$default$6();
            long x$9 = qual$1.call$default$7();
            boolean x$10 = qual$1.call$default$8();
            boolean x$11 = qual$1.call$default$9();
            long x$12 = qual$1.call$default$10();
            boolean x$13 = qual$1.call$default$11();
            qual$1.call(x$3, x$5, x$6, x$4, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
            String ext = Util.isWindows ? ".exe" : "";
            Path executable = dest.$div(new PathChunk.StringPathChunk(new StringBuilder(0).append(executeableName).append(ext).toString()));
            Predef$.MODULE$.assert(exists$.MODULE$.apply(executable));
            return package$.MODULE$.PathRef().apply(executable, package$.MODULE$.PathRef().apply$default$2(), package$.MODULE$.PathRef().apply$default$3());
        })), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.NativeImageModule#nativeImage"), new Line(34), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new sourcecode.File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/NativeImageModule.scala"), new Caller(this)), PathRef$.MODULE$.jsonFormatter(), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false))), new Enclosing("mill.scalalib.NativeImageModule#nativeImage"));
    }

    public static /* synthetic */ Target nativeImageClasspath$(NativeImageModule $this) {
        return $this.nativeImageClasspath();
    }

    @Scaladoc(value="/**\n   * The classpath to use to generate the native image. Defaults to [[runClasspath]].\n   */")
    default public Target<Seq<PathRef>> nativeImageClasspath() {
        return (Target)((Cacher)((Object)this)).cachedTarget((Function0<TargetImpl> & Serializable)() -> new TargetImpl(package$.MODULE$.Task().traverseCtx(new $colon$colon<Nothing$>((Nothing$)((Object)this.runClasspath()), Nil$.MODULE$), (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> Result$.MODULE$.create((Function0<Seq> & Serializable)() -> (Seq)items$macro$1.apply(false))), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.NativeImageModule#nativeImageClasspath"), new Line(58), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new sourcecode.File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/NativeImageModule.scala"), new Caller(this)), default$.MODULE$.ReadWriter().join(default$.MODULE$.SeqLikeReader(PathRef$.MODULE$.jsonFormatter(), Seq$.MODULE$.iterableFactory()), default$.MODULE$.SeqLikeWriter(PathRef$.MODULE$.jsonFormatter())), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false))), new Enclosing("mill.scalalib.NativeImageModule#nativeImageClasspath"));
    }

    public static /* synthetic */ Target nativeImageOptions$(NativeImageModule $this) {
        return $this.nativeImageOptions();
    }

    @Scaladoc(value="/**\n   * Additional options for the `native-image` Tool.\n   *\n   * @note It is recommended to restrict this list to options that can be shared across targets.\n   */")
    default public Target<Seq<String>> nativeImageOptions() {
        return (Target)((Cacher)((Object)this)).cachedTarget((Function0<TargetImpl> & Serializable)() -> new TargetImpl(Target$.MODULE$.traverseCtx((Seq)Nil$.MODULE$, (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> Result$.MODULE$.create((Function0<Seq> & Serializable)() -> (Seq)scala.package$.MODULE$.Seq().empty())), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.NativeImageModule#nativeImageOptions"), new Line(67), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new sourcecode.File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/NativeImageModule.scala"), new Caller(this)), default$.MODULE$.ReadWriter().join(default$.MODULE$.SeqLikeReader(default$.MODULE$.StringReader(), Seq$.MODULE$.iterableFactory()), default$.MODULE$.SeqLikeWriter(default$.MODULE$.StringWriter())), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false))), new Enclosing("mill.scalalib.NativeImageModule#nativeImageOptions"));
    }

    public static /* synthetic */ Target nativeImageTool$(NativeImageModule $this) {
        return $this.nativeImageTool();
    }

    @Scaladoc(value="/**\n   * Path to the [[https://www.graalvm.org/latest/reference-manual/native-image/ `native-image` Tool]].\n   * Defaults to a path relative to\n   *  - [[ZincWorkerModule.javaHome]], if defined\n   *  - environment variable `GRAALVM_HOME`, if defined\n   *\n   * @note The task fails if the `native-image` Tool is not found.\n   */")
    default public Target<PathRef> nativeImageTool() {
        return (Target)((Cacher)((Object)this)).cachedTarget((Function0<TargetImpl> & Serializable)() -> new TargetImpl(package$.MODULE$.Task().traverseCtx(new $colon$colon<Nothing$>((Nothing$)((Object)this.zincWorker().apply().javaHome()), Nil$.MODULE$), (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> Result$.MODULE$.create((Function0<PathRef> & Serializable)() -> {
            Option option = ((Option)items$macro$1.apply(false)).map((Function1<PathRef, Path> & Serializable)x$2 -> x$2.path()).orElse((Function0<Option> & Serializable)() -> scala.sys.package$.MODULE$.env().get("GRAALVM_HOME").map((Function1<String, Path> & Serializable)x$3 -> Path$.MODULE$.apply(x$3, PathConvertible$StringConvertible$.MODULE$)));
            if (option instanceof Some) {
                Some some = (Some)option;
                Path home = (Path)some.value();
                String tool = Properties$.MODULE$.isWin() ? "native-image.cmd" : "native-image";
                Path path = home.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"bin"})))).$div(new PathChunk.StringPathChunk(tool));
                if (exists$.MODULE$.apply(path)) {
                    return package$.MODULE$.PathRef().apply(path, package$.MODULE$.PathRef().apply$default$2(), package$.MODULE$.PathRef().apply$default$3());
                }
                throw new RuntimeException(new StringBuilder(10).append(path).append(" not found").toString());
            }
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("ZincWorkerModule.javaHome/GRAALVM_HOME not defined");
            }
            throw new MatchError(option);
        })), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.NativeImageModule#nativeImageTool"), new Line(77), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new sourcecode.File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/NativeImageModule.scala"), new Caller(this)), PathRef$.MODULE$.jsonFormatter(), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false))), new Enclosing("mill.scalalib.NativeImageModule#nativeImageTool"));
    }

    public static void $init$(NativeImageModule $this) {
    }
}

