/*
 * Decompiled with CFR 0.152.
 */
package mill.util;

import fansi.Attrs$;
import fansi.ErrorMode$Sanitize$;
import fansi.Str;
import fansi.Str$;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import mill.moduledefs.Scaladoc;
import scala.Function0;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Scaladoc(value="/**\n * Prefixes the first and each new line with a dynamically provided prefix,\n * and buffers up each line in memory before writing to the [[out]] stream\n * to prevent individual lines from being mixed together\n *\n * @param linePrefix The function to provide the prefix.\n * @param out The underlying output stream.\n */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u000b\u0017\u0001mA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003?\u0001\u0011\u0005q\bC\u0003?\u0001\u0011\u0005Q\t\u0003\u0004I\u0001\u0001\u0006I!\u0013\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002)\t\rM\u0003\u0001\u0015)\u0003Q\u0011\u001d!\u0006A1A\u0005\u0002UCa!\u0017\u0001!\u0002\u00131\u0006b\u0002.\u0001\u0001\u0004%Ia\u0017\u0005\b?\u0002\u0001\r\u0011\"\u0003a\u0011\u0019\u0019\u0007\u0001)Q\u00059\")A\r\u0001C!K\"1\u0001\u000e\u0001Q\u0005\n%DQA\u001b\u0001\u0005\u0002%DQ\u0001\u001a\u0001\u0005B-DQ\u0001\u001a\u0001\u0005BQDQA\u001e\u0001\u0005B%DQa\u001e\u0001\u0005B%\u0014a\u0003T5oKB\u0013XMZ5y\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0006\u0003/a\tA!\u001e;jY*\t\u0011$\u0001\u0003nS2d7\u0001A\n\u0003\u0001q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u0005%|'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011!CR5mi\u0016\u0014x*\u001e;qkR\u001cFO]3b[\u0006QA.\u001b8f!J,g-\u001b=\u0011\u0005\u0019zcBA\u0014.!\tA3&D\u0001*\u0015\tQ#$\u0001\u0004=e>|GO\u0010\u0006\u0002Y\u0005)1oY1mC&\u0011afK\u0001\u0007!J,G-\u001a4\n\u0005A\n$AB*ue&twM\u0003\u0002/W\u0005\u0019q.\u001e;\u0011\u0005u!\u0014BA\u001b\u001f\u00051yU\u000f\u001e9viN#(/Z1n\u00031\u0011X\r]8siB\u0013XMZ5y!\rA\u0014hO\u0007\u0002W%\u0011!h\u000b\u0002\n\rVt7\r^5p]B\u0002\"\u0001\u000f\u001f\n\u0005uZ#\u0001B+oSR\fa\u0001P5oSRtD\u0003\u0002!C\u0007\u0012\u0003\"!\u0011\u0001\u000e\u0003YAQ\u0001\n\u0003A\u0002\u0015BQA\r\u0003A\u0002MBQA\u000e\u0003A\u0002]\"2\u0001\u0011$H\u0011\u0015!S\u00011\u0001&\u0011\u0015\u0011T\u00011\u00014\u0003=a\u0017N\\3Qe\u00164\u0017\u000e\u001f\"zi\u0016\u001c\bc\u0001\u001dK\u0019&\u00111j\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003q5K!AT\u0016\u0003\t\tKH/Z\u0001\u0013Y&tW\r\u0015:fM&Dhj\u001c8F[B$\u0018\u0010\u0005\u00029#&\u0011!k\u000b\u0002\b\u0005>|G.Z1o\u0003%I7OT3x\u0019&tW-\u0001\u0004ck\u001a4WM]\u000b\u0002-B\u0011QdV\u0005\u00031z\u0011QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.A\u0004ck\u001a4WM\u001d\u0011\u0002%\u0015tGm\u00144MCN$H*\u001b8f\u0007>dwN]\u000b\u00029B\u0011\u0001(X\u0005\u0003=.\u0012A\u0001T8oO\u00061RM\u001c3PM2\u000b7\u000f\u001e'j]\u0016\u001cu\u000e\\8s?\u0012*\u0017\u000f\u0006\u0002<C\"9!\rDA\u0001\u0002\u0004a\u0016a\u0001=%c\u0005\u0019RM\u001c3PM2\u000b7\u000f\u001e'j]\u0016\u001cu\u000e\\8sA\u0005)qO]5uKR\u00111H\u001a\u0005\u0006O:\u0001\r!S\u0001\u0002E\u0006QrO]5uK2Kg.\u001a)sK\u001aL\u00070\u00134OK\u000e,7o]1ssR\t1(\u0001\bxe&$XmT;u\u0005V4g-\u001a:\u0015\tmbWN\u001d\u0005\u0006OF\u0001\r!\u0013\u0005\u0006]F\u0001\ra\\\u0001\u0004_\u001a4\u0007C\u0001\u001dq\u0013\t\t8FA\u0002J]RDQa]\tA\u0002=\f1\u0001\\3o)\tYT\u000fC\u0003h%\u0001\u0007q.A\u0003gYV\u001c\b.A\u0003dY>\u001cX\rK\u0003\u0001s~\f\t\u0001\u0005\u0002{{6\t1P\u0003\u0002}1\u0005QQn\u001c3vY\u0016$WMZ:\n\u0005y\\(\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u0005\r\u0011Aa 0U)R\u0001E\u000b\u0011Qe\u00164\u0017\u000e_3tAQDW\r\t4jeN$\b%\u00198eA\u0015\f7\r\u001b\u0011oK^\u0004C.\u001b8fA]LG\u000f\u001b\u0011bA\u0011Lh.Y7jG\u0006dG.\u001f\u0011qe>4\u0018\u000eZ3eAA\u0014XMZ5yY)\u0001#\u0006I1oI\u0002\u0012WO\u001a4feN\u0004S\u000f\u001d\u0011fC\u000eD\u0007\u0005\\5oK\u0002Jg\u000eI7f[>\u0014\u0018\u0010\t2fM>\u0014X\rI<sSRLgn\u001a\u0011u_\u0002\"\b.\u001a\u0011\\7>,H/X/!gR\u0014X-Y7\u000bA)\u0002Co\u001c\u0011qe\u00164XM\u001c;!S:$\u0017N^5ek\u0006d\u0007\u0005\\5oKN\u0004cM]8nA\t,\u0017N\\4![&DX\r\u001a\u0011u_\u001e,G\u000f[3s\u0015\u0001R#\u0002\t\u0016!\u0001B\f'/Y7!Y&tW\r\u0015:fM&D\b\u0005\u00165fA\u0019,hn\u0019;j_:\u0004Co\u001c\u0011qe>4\u0018\u000eZ3!i\",\u0007\u0005\u001d:fM&DhF\u0003\u0011+A\u0001\u0003\u0018M]1nA=,H\u000f\t+iK\u0002*h\u000eZ3sYfLgn\u001a\u0011pkR\u0004X\u000f\u001e\u0011tiJ,\u0017-\u001c\u0018\u000bA)z\u0003")
public class LinePrefixOutputStream
extends FilterOutputStream {
    private final OutputStream out;
    private final Function0<BoxedUnit> reportPrefix;
    private final byte[] linePrefixBytes;
    private final boolean linePrefixNonEmpty;
    private boolean isNewLine;
    private final ByteArrayOutputStream buffer;
    private long endOfLastLineColor;

    public ByteArrayOutputStream buffer() {
        return this.buffer;
    }

    private long endOfLastLineColor() {
        return this.endOfLastLineColor;
    }

    private void endOfLastLineColor_$eq(long x$1) {
        this.endOfLastLineColor = x$1;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    private void writeLinePrefixIfNecessary() {
        if (this.isNewLine && this.linePrefixNonEmpty) {
            this.isNewLine = false;
            this.buffer().write(this.linePrefixBytes);
            if (this.linePrefixNonEmpty) {
                this.buffer().write(Attrs$.MODULE$.emitAnsiCodes(0L, this.endOfLastLineColor()).getBytes());
                return;
            }
            return;
        }
    }

    public void writeOutBuffer() {
        String bufferString;
        if (this.buffer().size() > 0) {
            this.reportPrefix.apply$mcV$sp();
        }
        if (this.linePrefixNonEmpty && (bufferString = this.buffer().toString()).length() > 0) {
            Str s = Str$.MODULE$.apply(bufferString, ErrorMode$Sanitize$.MODULE$);
            this.endOfLastLineColor_$eq(s.getColor(package$.MODULE$.max(0, s.length() - 1)));
        }
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.buffer().writeTo(this.out);
        }
        this.buffer().reset();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        int start = off;
        int i = off;
        int max = off + len;
        while (i < max) {
            this.writeLinePrefixIfNecessary();
            if (b[i] == 10) {
                this.buffer().write(b, start, ++i - start);
                this.isNewLine = true;
                start = i;
                this.writeOutBuffer();
                continue;
            }
            ++i;
        }
        if (package$.MODULE$.min(i, max) - start > 0) {
            this.writeLinePrefixIfNecessary();
            this.buffer().write(b, start, package$.MODULE$.min(i, max) - start);
            if (b[max - 1] == 10) {
                this.writeOutBuffer();
                return;
            }
            return;
        }
    }

    @Override
    public synchronized void write(int b) {
        this.writeLinePrefixIfNecessary();
        this.buffer().write(b);
        if (b == 10) {
            this.writeOutBuffer();
            this.isNewLine = true;
            return;
        }
    }

    @Override
    public synchronized void flush() {
        this.writeOutBuffer();
        this.out.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.out.close();
    }

    public LinePrefixOutputStream(String linePrefix, OutputStream out, Function0<BoxedUnit> reportPrefix) {
        this.out = out;
        this.reportPrefix = reportPrefix;
        super(out);
        this.linePrefixBytes = linePrefix.getBytes("UTF-8");
        this.linePrefixNonEmpty = this.linePrefixBytes.length != 0;
        this.isNewLine = true;
        this.buffer = new ByteArrayOutputStream();
        this.endOfLastLineColor = 0L;
    }

    public LinePrefixOutputStream(String linePrefix, OutputStream out) {
        this(linePrefix, out, (Function0<BoxedUnit>)((Object)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public final void apply$mcV$sp() {
            }
        }));
    }
}

