/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.java.plugin.util.ResourceManager;

public final class IoUtil {
    private static final String PACKAGE_NAME = "org.java.plugin.util";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (!file.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFile", file));
        }
        if (file2.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFolder", file2));
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2, false));
            try {
                IoUtil.copyStream(bufferedInputStream, bufferedOutputStream, 1024);
            }
            finally {
                bufferedOutputStream.close();
            }
        }
        finally {
            bufferedInputStream.close();
        }
        file2.setLastModified(file.lastModified());
    }

    public static void copyFolder(File file, File file2) throws IOException {
        IoUtil.copyFolder(file, file2, true, false);
    }

    public static void copyFolder(File file, File file2, boolean bl) throws IOException {
        IoUtil.copyFolder(file, file2, bl, false);
    }

    public static void copyFolder(File file, File file2, boolean bl, boolean bl2) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFolder", file));
        }
        if (file2.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFile", file2));
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantMakeFolder", file2));
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (file3.isDirectory()) {
                if (!bl) continue;
                IoUtil.copyFolder(file3, new File(file2, file3.getName()), bl, bl2);
                continue;
            }
            File file4 = new File(file2, file3.getName());
            if (bl2 && file4.isFile() && file4.lastModified() > file3.lastModified()) continue;
            IoUtil.copyFile(file3, file4);
        }
        file2.setLastModified(file.lastModified());
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static boolean emptyFolder(File file) {
        if (!file.isDirectory()) {
            return true;
        }
        File[] fileArray = file.listFiles();
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                if (IoUtil.emptyFolder(file2)) {
                    bl &= file2.delete();
                    continue;
                }
                bl = false;
                continue;
            }
            bl &= file2.delete();
        }
        return bl;
    }

    public static boolean compareFiles(File file, File file2) {
        if (!file.isFile() || !file2.isFile()) {
            return false;
        }
        if (!file.getName().equals(file2.getName())) {
            return false;
        }
        if (file.length() != file2.length()) {
            return false;
        }
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTime(new Date(file.lastModified()));
        calendar.set(14, 0);
        Date date = calendar.getTime();
        calendar.setTime(new Date(file2.lastModified()));
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        return date.equals(date2);
    }

    public static void synchronizeFolders(File file, File file2) throws IOException {
        File file3;
        if (!file.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFolder", file));
        }
        if (file2.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFile", file2));
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantMakeFolder", file2));
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file4 = fileArray[i];
            file3 = new File(file2, file4.getName());
            if (file4.isDirectory()) {
                if (file3.isFile() && !file3.delete()) {
                    throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantDeleteFile", file3));
                }
                IoUtil.synchronizeFolders(file4, file3);
                continue;
            }
            if (IoUtil.compareFiles(file4, file3)) continue;
            IoUtil.copyFile(file4, file3);
        }
        File[] fileArray2 = file2.listFiles();
        for (int i = 0; i < fileArray2.length; ++i) {
            file3 = fileArray2[i];
            if (new File(file, file3.getName()).exists()) continue;
            if (file3.isDirectory() && !IoUtil.emptyFolder(file3)) {
                throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantEmptyFolder", file3));
            }
            if (file3.delete()) continue;
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantDeleteFile", file3));
        }
        file2.setLastModified(file.lastModified());
    }

    public static boolean isResourceExists(URL uRL) {
        File file = IoUtil.url2file(uRL);
        if (file != null) {
            return file.canRead();
        }
        try {
            InputStream inputStream = uRL.openStream();
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static File url2file(URL uRL) {
        if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
            return null;
        }
        return new File(uRL.getFile().replaceAll("%20", " "));
    }

    public static URL file2url(File file) throws MalformedURLException {
        try {
            return file.getCanonicalFile().toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (IOException iOException) {
            throw new MalformedURLException(ResourceManager.getMessage(PACKAGE_NAME, "file2urlFailed", new Object[]{file, iOException}));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            try {
                return new URL("file://" + file.getCanonicalPath().replace('\\', '/').replaceAll(" ", "%20"));
            }
            catch (MalformedURLException malformedURLException) {
                throw malformedURLException;
            }
            catch (IOException iOException) {
                throw new MalformedURLException(ResourceManager.getMessage(PACKAGE_NAME, "file2urlFailed", new Object[]{file, iOException}));
            }
        }
    }

    private IoUtil() {
    }
}

