/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.ObjectFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.ApplicationInitializer;
import org.java.plugin.boot.ApplicationPlugin;
import org.java.plugin.boot.BootErrorHandler;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.boot.PluginsCollector;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.java.plugin.util.ResourceManager;

public class DefaultApplicationInitializer
implements ApplicationInitializer {
    protected static final String PARAM_APPLICATION_PLUGIN = "org.java.plugin.boot.applicationPlugin";
    protected static final String PARAM_INTEGRITY_CHECK_MODE = "org.java.plugin.boot.integrityCheckMode";
    protected static final String PARAM_PLUGINS_COLLECTOR = "org.java.plugin.boot.pluginsCollector";
    private Log log;
    private ExtendedProperties config;
    private String integrityCheckMode;
    private PluginsCollector collector;
    static /* synthetic */ Class class$org$java$plugin$boot$ApplicationPlugin;

    public void configure(ExtendedProperties extendedProperties) throws Exception {
        String string = "log4j.configuration";
        if (System.getProperty(string) == null) {
            if (extendedProperties.containsKey(string)) {
                System.setProperty(string, extendedProperties.getProperty(string));
            } else {
                File file = new File(extendedProperties.getProperty("applicationRoot") + File.separator + "log4j.properties");
                if (!file.isFile()) {
                    file = new File(extendedProperties.getProperty("applicationRoot") + File.separator + "log4j.xml");
                }
                if (file.isFile()) {
                    try {
                        System.setProperty(string, IoUtil.file2url(file).toExternalForm());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
        this.log = LogFactory.getLog(this.getClass());
        this.log.info((Object)"logging system initialized");
        this.log.info((Object)("application root is " + extendedProperties.getProperty("applicationRoot")));
        this.config = extendedProperties;
        this.integrityCheckMode = extendedProperties.getProperty(PARAM_INTEGRITY_CHECK_MODE, "full");
        this.collector = DefaultApplicationInitializer.getCollectorInstance(extendedProperties.getProperty(PARAM_PLUGINS_COLLECTOR));
        this.collector.configure(extendedProperties);
        this.log.debug((Object)("plug-ins collector is " + this.collector));
    }

    private static PluginsCollector getCollectorInstance(String string) {
        if (string != null) {
            try {
                return (PluginsCollector)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new DefaultPluginsCollector();
    }

    public Application initApplication(BootErrorHandler bootErrorHandler, String[] stringArray) throws Exception {
        Object object;
        this.log.debug((Object)"collecting plug-in locations");
        Collection collection = this.collector.collectPluginLocations();
        this.log.debug((Object)("collected " + collection.size() + " plug-in locations, running plug-in manager"));
        PluginManager pluginManager = ObjectFactory.newInstance(this.config).createManager();
        pluginManager.publishPlugins(collection.toArray(new PluginManager.PluginLocation[collection.size()]));
        if (!"off".equalsIgnoreCase(this.integrityCheckMode)) {
            this.log.debug((Object)"checking plug-ins set integrity");
            object = pluginManager.getRegistry().checkIntegrity("light".equalsIgnoreCase(this.integrityCheckMode) ? null : pluginManager.getPathResolver());
            this.log.info((Object)("integrity check done: errors - " + object.countErrors() + ", warnings - " + object.countWarnings()));
            if (object.countErrors() != 0) {
                this.log.info((Object)this.integrityCheckReport2str((IntegrityCheckReport)object));
                if (!bootErrorHandler.handleError(ResourceManager.getMessage("org.java.plugin.boot", "integrityCheckFailed"), (IntegrityCheckReport)object)) {
                    return null;
                }
            } else if (this.log.isDebugEnabled() && (object.countErrors() > 0 || object.countWarnings() > 0)) {
                this.log.debug((Object)this.integrityCheckReport2str((IntegrityCheckReport)object));
            }
        }
        object = this.config.getProperty(PARAM_APPLICATION_PLUGIN);
        this.log.info((Object)("application plug-in is " + (String)object));
        Plugin plugin = pluginManager.getPlugin((String)object);
        this.log.debug((Object)("got application plug-in " + plugin + ", initializing application"));
        if (!(plugin instanceof ApplicationPlugin)) {
            this.log.error((Object)("application plug-in class " + plugin.getClass().getName() + " doesn't assignable with " + (class$org$java$plugin$boot$ApplicationPlugin == null ? (class$org$java$plugin$boot$ApplicationPlugin = DefaultApplicationInitializer.class$("org.java.plugin.boot.ApplicationPlugin")) : class$org$java$plugin$boot$ApplicationPlugin).getName()));
            throw new ClassCastException(plugin.getClass().getName());
        }
        return ((ApplicationPlugin)plugin).initApplication(this.config.getSubset((String)object + "."), stringArray);
    }

    protected String integrityCheckReport2str(IntegrityCheckReport integrityCheckReport) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("integrity check report:\r\n");
        stringBuffer.append("-------------- REPORT BEGIN -----------------\r\n");
        Iterator iterator = integrityCheckReport.getItems().iterator();
        while (iterator.hasNext()) {
            IntegrityCheckReport.ReportItem reportItem = (IntegrityCheckReport.ReportItem)iterator.next();
            stringBuffer.append("\tseverity=").append(reportItem.getSeverity()).append("; code=").append(reportItem.getCode()).append("; message=").append(reportItem.getMessage()).append("; source=").append(reportItem.getSource()).append("\r\n");
        }
        stringBuffer.append("-------------- REPORT END -----------------");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

