/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.datastructure;

public class LongList {
    private static final int INITIAL_CAPACITY = 10;
    private static final int GROW = 10;
    private int _count;
    private long[] _list = new long[10];

    public LongList() {
        this(10);
    }

    public LongList(int capacity) {
    }

    public void add(long l) {
        this.ensureCapacity(this._count + 1);
        this._list[this._count] = l;
        ++this._count;
    }

    public long get(int i) {
        if (i < 0 || i >= this._count) {
            throw new IndexOutOfBoundsException("Invalid index " + i);
        }
        return this._list[i];
    }

    public void add(long l, int i) {
        if (i < 0 || i > this._count) {
            throw new IndexOutOfBoundsException("Invalid index " + i);
        }
        if (i == this._count) {
            this.add(l);
        } else {
            this.ensureCapacity(this._count + 1);
            for (int j = this._count; j > i; --j) {
                this._list[j] = this._list[j - 1];
            }
            ++this._count;
            this._list[i] = l;
        }
    }

    private void ensureCapacity(int size) {
        if (this._list.length < size) {
            long[] newlist = new long[this._list.length + 10];
            for (int i = 0; i < this._list.length; ++i) {
                newlist[i] = this._list[i];
            }
            this._list = newlist;
        }
    }

    public long remove(int i) {
        if (i < 0 || i >= this._count) {
            throw new IndexOutOfBoundsException("Invalid index " + i);
        }
        long save = this._list[i];
        for (int j = i; j < this._count - 2; --j) {
            this._list[j] = this._list[j + 1];
        }
        --this._count;
        return save;
    }

    public long first() {
        return this._list[0];
    }

    public long last() {
        return this._list[this._count - 1];
    }
}

