/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileUtils {
    private static final String FSLASH = "/";
    private static final String BSLASH = "\\";
    private static final String SEPARATOR = "/";

    private FileUtils() {
    }

    public static String concatFilePath(String[] args) {
        StringBuffer sb = new StringBuffer(args[0]);
        for (int i = 1; i < args.length; ++i) {
            FileUtils.concatFilePath(sb, args[i]);
        }
        return sb.toString();
    }

    public static String concatFilePath(String prefix, String suffix) {
        return FileUtils.concatFilePath(new StringBuffer(prefix), suffix);
    }

    private static String concatFilePath(StringBuffer prefix, String suffix) {
        String pf = prefix.toString();
        if (pf.endsWith("/") || pf.endsWith(BSLASH)) {
            if (suffix.startsWith("/") || suffix.startsWith(BSLASH)) {
                if (suffix.length() > 1) {
                    prefix.append(suffix.substring(1));
                }
            } else {
                prefix.append(suffix);
            }
        } else if (suffix.startsWith("/") || suffix.startsWith(BSLASH)) {
            prefix.append(suffix);
        } else {
            prefix.append("/");
            prefix.append(suffix);
        }
        return prefix.toString();
    }

    public static void copyStream(InputStream input, OutputStream output, int chunkSize) throws IOException {
        byte[] buffer = new byte[chunkSize];
        int n = input.read(buffer, 0, chunkSize);
        while (n != -1) {
            output.write(buffer, 0, n);
            n = input.read(buffer, 0, chunkSize);
        }
        output.flush();
    }
}

