/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.configuration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.registry.Version;
import org.java.plugin.tools.configuration.Util;
import org.java.plugin.util.IoUtil;

public final class PluginArchiver {
    private static final String DESCRIPTOR_ENTRY_NAME = "JPF-DESCRIPTOR";

    public static void pack(PluginDescriptor pluginDescriptor, PathResolver pathResolver, File file) throws IOException {
        PluginArchiver.pack(pathResolver.resolvePath(pluginDescriptor, "/"), "JPF plug-in " + pluginDescriptor.getId() + " of version " + pluginDescriptor.getVersion(), file);
    }

    public static void pack(PluginFragment pluginFragment, PathResolver pathResolver, File file) throws IOException {
        PluginArchiver.pack(pathResolver.resolvePath(pluginFragment, "/"), "JPF plug-in fragment " + pluginFragment.getId() + " of version " + pluginFragment.getVersion(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pack(URL uRL, String string, File file) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file, false)));
        try {
            zipOutputStream.setComment(string);
            File file2 = IoUtil.url2file(uRL);
            if (file2 == null) {
                throw new IOException("resolved URL " + uRL + " is not local file system location pointer");
            }
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                PluginArchiver.packEntry(zipOutputStream, null, fileArray[i]);
            }
        }
        finally {
            zipOutputStream.close();
        }
    }

    public static Collection pack(PluginRegistry pluginRegistry, PathResolver pathResolver, File file) throws IOException {
        return PluginArchiver.pack(pluginRegistry, pathResolver, file, new Filter(){

            public boolean accept(String string, Version version, boolean bl) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection pack(PluginRegistry pluginRegistry, PathResolver pathResolver, File file, Filter filter) throws IOException {
        Set set;
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file, false)));
        try {
            int n;
            File[] fileArray;
            File file2;
            URL uRL;
            UniqueIdentity uniqueIdentity;
            zipOutputStream.setComment("JPF plug-ins archive");
            ZipEntry zipEntry = new ZipEntry(DESCRIPTOR_ENTRY_NAME);
            zipEntry.setComment("JPF plug-ins archive descriptor");
            zipOutputStream.putNextEntry(zipEntry);
            set = PluginArchiver.writeDescripor(pluginRegistry, filter, new ObjectOutputStream(zipOutputStream));
            zipOutputStream.closeEntry();
            Iterator iterator = pluginRegistry.getPluginDescriptors().iterator();
            while (iterator.hasNext()) {
                uniqueIdentity = (PluginDescriptor)iterator.next();
                if (!set.contains(uniqueIdentity.getUniqueId())) continue;
                uRL = pathResolver.resolvePath(uniqueIdentity, "/");
                file2 = IoUtil.url2file(uRL);
                if (file2 == null) {
                    throw new IOException("resolved URL " + uRL + " is not local file system location pointer");
                }
                zipEntry = new ZipEntry(uniqueIdentity.getUniqueId() + "/");
                zipEntry.setComment("Content for JPF plug-in " + uniqueIdentity.getId() + " version " + uniqueIdentity.getVersion());
                zipEntry.setTime(file2.lastModified());
                zipOutputStream.putNextEntry(zipEntry);
                fileArray = file2.listFiles();
                for (n = 0; n < fileArray.length; ++n) {
                    PluginArchiver.packEntry(zipOutputStream, zipEntry, fileArray[n]);
                }
            }
            iterator = pluginRegistry.getPluginFragments().iterator();
            while (iterator.hasNext()) {
                uniqueIdentity = (PluginFragment)iterator.next();
                if (!set.contains(uniqueIdentity.getUniqueId())) continue;
                uRL = pathResolver.resolvePath(uniqueIdentity, "/");
                file2 = IoUtil.url2file(uRL);
                if (file2 == null) {
                    throw new IOException("resolved URL " + uRL + " is not local file system location pointer");
                }
                zipEntry = new ZipEntry(uniqueIdentity.getUniqueId() + "/");
                zipEntry.setComment("Content for JPF plug-in fragment " + uniqueIdentity.getId() + " version " + uniqueIdentity.getVersion());
                zipEntry.setTime(file2.lastModified());
                zipOutputStream.putNextEntry(zipEntry);
                fileArray = file2.listFiles();
                for (n = 0; n < fileArray.length; ++n) {
                    PluginArchiver.packEntry(zipOutputStream, zipEntry, fileArray[n]);
                }
            }
        }
        finally {
            zipOutputStream.close();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, File file) throws IOException {
        String string;
        String string2 = string = zipEntry == null ? "" : zipEntry.getName();
        if (file.isFile()) {
            ZipEntry zipEntry2 = new ZipEntry(string + file.getName());
            zipEntry2.setTime(file.lastModified());
            zipOutputStream.putNextEntry(zipEntry2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                IoUtil.copyStream(bufferedInputStream, zipOutputStream, 1024);
            }
            finally {
                bufferedInputStream.close();
            }
            return;
        }
        ZipEntry zipEntry3 = new ZipEntry(string + file.getName() + "/");
        zipEntry3.setTime(file.lastModified());
        zipOutputStream.putNextEntry(zipEntry3);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            PluginArchiver.packEntry(zipOutputStream, zipEntry3, fileArray[i]);
        }
    }

    public static Collection unpack(URL uRL, PluginRegistry pluginRegistry, File file) throws ManifestProcessingException, IOException, ClassNotFoundException {
        return PluginArchiver.unpack(uRL, pluginRegistry, file, new Filter(){

            public boolean accept(String string, Version version, boolean bl) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection unpack(URL uRL, PluginRegistry pluginRegistry, File file, Filter filter) throws IOException, ManifestProcessingException, ClassNotFoundException {
        Set set;
        int n = 0;
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry == null) {
                throw new IOException("invalid plug-ins archive, no entries found");
            }
            if (!DESCRIPTOR_ENTRY_NAME.equals(zipEntry.getName())) {
                throw new IOException("invalid plug-ins archive " + uRL + ", entry " + DESCRIPTOR_ENTRY_NAME + " not found as first ZIP entry in the archive file");
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(zipInputStream);
            set = PluginArchiver.readDescriptor(objectInputStream, pluginRegistry, file, filter);
            zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (string.endsWith("/") && string.lastIndexOf(47, string.length() - 2) == -1) {
                    String string2 = string.substring(0, string.length() - 1);
                    if (!set.contains(string2)) {
                        zipEntry = zipInputStream.getNextEntry();
                        continue;
                    }
                    ++n;
                } else {
                    int n2 = string.indexOf(47);
                    if (n2 == -1 || n2 == 0 || !set.contains(string.substring(0, n2))) {
                        zipEntry = zipInputStream.getNextEntry();
                        continue;
                    }
                }
                PluginArchiver.unpackEntry(zipInputStream, zipEntry, file);
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
        }
        if (set.size() != n) {
            throw new IOException("invalid plug-ins number (" + n + ") found in the archive, expected number according to " + "the archive descriptor is " + set.size());
        }
        return set;
    }

    public static Collection unpack(URL uRL, File file) throws ManifestProcessingException, IOException, ClassNotFoundException {
        return PluginArchiver.unpack(uRL, ObjectFactory.newInstance().createRegistry(), file);
    }

    public static Collection unpack(URL uRL, File file, Filter filter) throws ManifestProcessingException, IOException, ClassNotFoundException {
        return PluginArchiver.unpack(uRL, ObjectFactory.newInstance().createRegistry(), file, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpackEntry(ZipInputStream zipInputStream, ZipEntry zipEntry, File file) throws IOException {
        String string = zipEntry.getName();
        if (string.endsWith("/")) {
            File file2 = new File(file.getCanonicalPath() + "/" + string);
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("can't create folder " + file2);
            }
            file2.setLastModified(zipEntry.getTime());
            return;
        }
        File file3 = new File(file.getCanonicalPath() + "/" + string);
        File file4 = file3.getParentFile();
        if (!file4.exists() && !file4.mkdirs()) {
            throw new IOException("can't create folder " + file4);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3, false));
        try {
            IoUtil.copyStream(zipInputStream, bufferedOutputStream, 1024);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
        file3.setLastModified(zipEntry.getTime());
    }

    public static Collection readDescriptor(URL uRL, PluginRegistry pluginRegistry) throws IOException, ClassNotFoundException, ManifestProcessingException {
        return PluginArchiver.readDescriptor(uRL, pluginRegistry, new Filter(){

            public boolean accept(String string, Version version, boolean bl) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection readDescriptor(URL uRL, PluginRegistry pluginRegistry, Filter filter) throws IOException, ClassNotFoundException, ManifestProcessingException {
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry == null) {
                throw new IOException("invalid plug-ins archive, no entries found");
            }
            if (!DESCRIPTOR_ENTRY_NAME.equals(zipEntry.getName())) {
                throw new IOException("invalid plug-ins archive " + uRL + ", entry " + DESCRIPTOR_ENTRY_NAME + " not found as first ZIP entry in the archive file");
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(zipInputStream);
            Set set = PluginArchiver.readDescriptor(objectInputStream, pluginRegistry, Util.getTempFolder(), filter);
            return set;
        }
        finally {
            zipInputStream.close();
        }
    }

    private static Set writeDescripor(PluginRegistry pluginRegistry, Filter filter, ObjectOutputStream objectOutputStream) throws IOException {
        UniqueIdentity uniqueIdentity;
        HashMap<String, ArchiveDescriptorEntry> hashMap = new HashMap<String, ArchiveDescriptorEntry>();
        Iterator iterator = pluginRegistry.getPluginDescriptors().iterator();
        while (iterator.hasNext()) {
            uniqueIdentity = (PluginDescriptor)iterator.next();
            if (!filter.accept(uniqueIdentity.getId(), uniqueIdentity.getVersion(), false)) continue;
            hashMap.put(uniqueIdentity.getUniqueId(), new ArchiveDescriptorEntry(uniqueIdentity.getId(), uniqueIdentity.getVersion(), false, Util.readUrlContent(uniqueIdentity.getLocation())));
        }
        iterator = pluginRegistry.getPluginFragments().iterator();
        while (iterator.hasNext()) {
            uniqueIdentity = (PluginFragment)iterator.next();
            if (!filter.accept(uniqueIdentity.getId(), uniqueIdentity.getVersion(), true)) continue;
            hashMap.put(uniqueIdentity.getUniqueId(), new ArchiveDescriptorEntry(uniqueIdentity.getId(), uniqueIdentity.getVersion(), true, Util.readUrlContent(uniqueIdentity.getLocation())));
        }
        objectOutputStream.writeObject(hashMap.values().toArray(new ArchiveDescriptorEntry[hashMap.size()]));
        return hashMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set readDescriptor(ObjectInputStream objectInputStream, PluginRegistry pluginRegistry, File file, Filter filter) throws IOException, ClassNotFoundException, ManifestProcessingException {
        Iterator iterator;
        Object object;
        Object object2;
        ArchiveDescriptorEntry[] archiveDescriptorEntryArray = (ArchiveDescriptorEntry[])objectInputStream.readObject();
        HashSet<URL> hashSet = new HashSet<URL>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (int i = 0; i < archiveDescriptorEntryArray.length; ++i) {
            if (!filter.accept(archiveDescriptorEntryArray[i].getId(), archiveDescriptorEntryArray[i].getVersion(), archiveDescriptorEntryArray[i].isFragment())) continue;
            object2 = File.createTempFile("manifest.", null, file);
            ((File)object2).deleteOnExit();
            object = new BufferedOutputStream(new FileOutputStream((File)object2, false));
            try {
                ((OutputStream)object).write(archiveDescriptorEntryArray[i].getData());
            }
            finally {
                ((OutputStream)object).close();
            }
            hashSet2.add(object2);
            hashSet.add(IoUtil.file2url((File)object2));
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        try {
            object2 = pluginRegistry.register(hashSet.toArray(new URL[hashSet.size()])).values().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof PluginDescriptor) {
                    hashSet3.add(((PluginDescriptor)object).getUniqueId());
                    continue;
                }
                if (!(object instanceof PluginFragment)) continue;
                hashSet3.add(((PluginFragment)object).getUniqueId());
            }
            Object var12_12 = null;
            iterator = hashSet2.iterator();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            Iterator iterator2 = hashSet2.iterator();
            while (iterator2.hasNext()) {
                ((File)iterator2.next()).delete();
            }
            throw throwable;
        }
        while (iterator.hasNext()) {
            ((File)iterator.next()).delete();
        }
        return hashSet3;
    }

    private PluginArchiver() {
    }

    private static class ArchiveDescriptorEntry
    implements Serializable {
        private static final long serialVersionUID = 8749937247555974932L;
        private final String id;
        private final Version version;
        private final boolean isFragment;
        private final byte[] data;

        protected ArchiveDescriptorEntry(String string, Version version, boolean bl, byte[] byArray) {
            this.id = string;
            this.version = version;
            this.isFragment = bl;
            this.data = byArray;
        }

        protected String getId() {
            return this.id;
        }

        protected Version getVersion() {
            return this.version;
        }

        protected boolean isFragment() {
            return this.isFragment;
        }

        protected byte[] getData() {
            return this.data;
        }
    }

    public static interface Filter {
        public boolean accept(String var1, Version var2, boolean var3);
    }
}

