/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "State.h"

State::State(){
	init();
}

State::~State(){
	delete ball;
	free(contextual_info->msg);
	free(contextual_info);
	delete team[HOME];
	delete team[VISITOR];
	if(selection) delete selection;
	if(old_selected_player) delete old_selected_player;
	if(location_square) delete location_square;
	if(selected_player) delete selected_player;
	if(player_to_place) delete player_to_place;
	if(audience) delete audience;
	if(path) delete path;
	if(target) delete target;
	if(push_square) delete push_square;
	
	int i=0;
	for(i=0;i<MAX_PUSH_SQUARE;i++)
		if(push_squares[i]) delete push_squares[i];
	
	if(indirect_push_square) delete indirect_push_square;
	
	for(i=0;i<MAX_PUSH_SQUARE;i++)
		if(indirect_push_squares[i]) delete indirect_push_squares[i];

	if(double_indirect_push_square) delete double_indirect_push_square;
	
	for(i=0;i<MAX_PUSH_SQUARE;i++)
		if(double_indirect_push_squares[i]) delete double_indirect_push_squares[i];

	for(i=0;i<MAX_PLAYER_ON_PLAYGROUND;i++)
		if(interception_squares[i]) delete interception_squares[i];
	if(interception_square) delete interception_square;

	for(i=0;i<MAX_NEIGHBOUR;i++)
		if(transmit_squares[i]) delete transmit_squares[i];

	if(transmit_square) delete transmit_square;
	if(team_mate) delete team_mate;
	if(selection_save) delete selection_save;
	if(player_save) delete player_save;
}

void State::init(){
  reserve_page[HOME] = 0;
  reserve_page[VISITOR] = 0;
  reserve_page_count[HOME] = 0;
  reserve_page_count[VISITOR] = 0;
  kick_off_anim = false;
  throw_team_mate_anim = false;
  actions_menu_throw_team_mate = false;
  actions_menu_leap = false;
  debug = false;
  old_formation_id = -1;
  corridor_count[HOME][0] = 0;
  corridor_count[VISITOR][0] = 0;
  corridor_count[HOME][1] = 0;
  corridor_count[VISITOR][1] = 0;
  current_action = ACTIONS_NONE;
  current_mode = MODE_NONE;
  player_to_place = NULL;
  location_square = NULL;
  dices_roll = /*RM6 false*/true /*RM6*/;
  kick_off_team = NONE;
  first_half_kick_off_team = NONE;
  team_in_placement = NONE;
  half = FIRST_HALF;
  old_ball_owner_team = NONE;
  select_throw_target = false;
  x_push = 0;
  y_push = 0;
  push_square = NULL;
  push_square_count = 0;
  direct_push = true;
  x_indirect_push = 0;
  y_indirect_push = 0;
  indirect_push_square = NULL;
  indirect_push_square_count = 0;
  direct_indirect_push = true;
  x_double_indirect_push = 0;
  y_double_indirect_push = 0;
  double_indirect_push_square = NULL;
  double_indirect_push_square_count = 0;
  direct_double_indirect_push = true;
  old_x_square = -1;
  old_y_square = -1;
  throw_in_anim = false;
  active_team = NONE;
  old_active_team = NONE;
  turn_begining_time = 0;
  pause_begining_time = 0;
  autocenter_anim = false;
  pass_anim = false;
  target_anim = false;
  perfect_pass = false;
  transmit_square = NULL;
  transmit_square_count = 0;
  interception_square = NULL;
  interception_square_count = 0;
  interception_attempt = false;
  x_dock=DOCK_X;
  y_dock=DOCK_Y;
  drag_dock = false;
  pause = false;
  frame=0;
  tackle_zone_drawing_mode = NONE;
  ticks_drawing_mode = true;
  number_drawing_mode = true;
  grab_mouse_mode = false;
  path = NULL;
  player_is_moving = false;
  target = NULL;
  x_menu_clic = 0;
  y_menu_clic = 0;
  x_player_clic = 0;
  y_player_clic = 0;
  player_to_place_x = 0;
  player_to_place_y = 0;
  zoom_mode = false;
  autocenter_mode = true;
  freeze_interaction = false;
  selected_player = NULL;
  old_selected_player = NULL;
  team_mate = NULL;
  throw_team_mate_fumble = false;
  contextual_info = (contextual_info_t*)malloc(sizeof(contextual_info_t));
  contextual_info->msg = (char*)malloc( CHAR_256 );
  remaining_time = 0;
  freeze_time = false;
  // Ragnar Modif4
  is_a_skull_and_star = false;
  need_a_winner = false;
  /////////////////////////////////
  is_a_dump_off = false;
  is_a_blitz_dump_off = false;
  selection_save = NULL;
  player_save = NULL;
  selection = NULL;
  max_victims = false;
  int i;
  for(i=0;i<MAX_PUSH_SQUARE;i++)
	push_squares[i] = NULL;
  for(i=0;i<MAX_PUSH_SQUARE;i++)
	indirect_push_squares[i] = NULL;
  for(i=0;i<MAX_PUSH_SQUARE;i++)
	double_indirect_push_squares[i] = NULL;
  for(i=0;i<MAX_PLAYER_ON_PLAYGROUND;i++)
	interception_squares[i] = NULL;
  for(i=0;i<MAX_NEIGHBOUR;i++)
	transmit_squares[i] = NULL;
}

void State::save_state(FILE *fd, int depth){
	char format[10];
	memset(format,0,10);

	int i=0;
	for(i=0;i<depth;i++)
		format[i] = ' ';
	format[depth-1] = '\0';

	time_t t = time(NULL);
	char* ts = ctime(&t);

	ts[strlen(ts)-1] = '\0';

	fprintf(fd,"%s<state date=\"%s\">\n",format,ts);
    fprintf(fd,"%s<debug>%i</debug>\n",format,debug);
	fprintf(fd,"%s<dices_roll>%i</dices_roll>\n",format,dices_roll);
	if(ball) {fprintf(fd,"%s<ball>\n",format); ball->save_state(fd,depth+1);fprintf(fd,"%s</ball>\n",format); }
	if(selection) {fprintf(fd,"%s<selection>\n",format); selection->save_state(fd,depth+1); fprintf(fd,"%s</selection>\n",format);}
	if(old_selected_player) {fprintf(fd,"%s<old_selected_player>\n",format); old_selected_player->save_state(fd,depth+1); fprintf(fd,"%s</old_selected_player>\n",format);}
	if(location_square) {fprintf(fd,"%s<location_square x=\"%i\" y=\"%i\"></location_square>\n",format,location_square->get_x(),location_square->get_y());}
	fprintf(fd,"%s<player_to_place_x>%i</player_to_place_x>\n",format,player_to_place_x);
	fprintf(fd,"%s<player_to_place_y>%i</player_to_place_y>\n",format,player_to_place_y);
	fprintf(fd,"%s<tackle_zone_drawing_mode>%i</tackle_zone_drawing_mode>\n",format,tackle_zone_drawing_mode);
	fprintf(fd,"%s<number_drawing_mode>%i</number_drawing_mode>\n",format,number_drawing_mode);
	fprintf(fd,"%s<ticks_drawing_mode>%i</ticks_drawing_mode>\n",format,ticks_drawing_mode);
	fprintf(fd,"%s<grab_mouse_mode>%i</grab_mouse_mode>\n",format,grab_mouse_mode);
	fprintf(fd,"%s<current_action>%i</current_action>\n",format,current_action);
	fprintf(fd,"%s<current_mode>%i</current_mode>\n",format,current_mode);
	if(team[0]) {fprintf(fd,"%s<home_team>\n",format); team[0]->save_state(fd,depth+1); fprintf(fd,"%s</home_team>\n",format); }
	if(team[1]) {fprintf(fd,"%s<visitor_team>\n",format); team[1]->save_state(fd,depth+1); fprintf(fd,"%s</visitor_team>\n",format);} 
	if(audience) {fprintf(fd,"%s<audience>\n",format); audience->save_state(fd,depth+1); fprintf(fd,"%s</audience>\n",format); }
	if(path) {fprintf(fd,"%s<path>\n",format); path->save_state(fd,depth+1); fprintf(fd,"%s</path>\n",format); }
	fprintf(fd,"%s<player_is_moving>%i</player_is_moving>\n",format,player_is_moving);
	if(target) {fprintf(fd,"%s<target x=\"%i\" y=\"%i\"></target>\n",format,target->get_x(),target->get_y()); }
	fprintf(fd,"%s<x_menu_clic>%i</x_menu_clic>\n",format,x_menu_clic);
	fprintf(fd,"%s<y_menu_clic>%i</y_menu_clic>\n",format,y_menu_clic);
	fprintf(fd,"%s<x_player_clic>%i</x_player_clic>\n",format,x_player_clic);
	fprintf(fd,"%s<y_player_clic>%i</y_player_clic>\n",format,y_player_clic);
	fprintf(fd,"%s<zoom_mode>%i</zoom_mode>\n",format,zoom_mode);
	fprintf(fd,"%s<autocenter_mode>%i</autocenter_mode>\n",format,autocenter_mode);
	fprintf(fd,"%s<freeze_interaction>%i</freeze_interaction>\n",format,freeze_interaction);
	fprintf(fd,"%s<select_throw_target>%i</select_throw_target>\n",format,select_throw_target);
	fprintf(fd,"%s<throw_team_mate_anim>%i</throw_team_mate_anim>\n",format,throw_team_mate_anim);
	fprintf(fd,"%s<x_push>%i</x_push>\n",format,x_push);
	fprintf(fd,"%s<y_push>%i</y_push>\n",format,y_push);
	if(push_square) {fprintf(fd,"%s<push_square x=\"%i\" y=\"%i\"></push_square>\n",format,push_square->get_x(),push_square->get_y()); }
	fprintf(fd,"%s<push_square_count>%i</push_square_count>\n",format,push_square_count);
	
	for(i=0;i<push_square_count;i++)
		if(push_squares[i]) {	fprintf(fd,"%s<push_squares id=\"%i\" x=\"%i\" y=\"%i\"></push_squares>\n",format,i,push_squares[i]->get_x(),push_squares[i]->get_y()); }
	
	fprintf(fd,"%s<direct_push>%i</direct_push>\n",format,direct_push);
	fprintf(fd,"%s<x_indirect_push>%i</x_indirect_push>\n",format,x_indirect_push);
	fprintf(fd,"%s<y_indirect_push>%i</y_indirect_push>\n",format,y_indirect_push);
	if(indirect_push_square) {fprintf(fd,"%s<indirect_push_square x=\"%i\" y=\"%i\"></indirect_push_square>\n",format,indirect_push_square->get_x(),indirect_push_square->get_y()); }
	fprintf(fd,"%s<indirect_push_square_count>%i</indirect_push_square_count>\n",format,indirect_push_square_count);
	
	for(i=0;i<indirect_push_square_count;i++)
		if(indirect_push_squares[i]) {	fprintf(fd,"%s<indirect_push_squares id=\"%i\" x=\"%i\" y=\"%i\"></indirect_push_squares>\n",format,i,indirect_push_squares[i]->get_x(),indirect_push_squares[i]->get_y()); }
	
	fprintf(fd,"%s<direct_indirect_push>%i</direct_indirect_push>\n",format,direct_indirect_push);
	
	fprintf(fd,"%s<x_double_indirect_push>%i</x_double_indirect_push>\n",format,x_double_indirect_push);
	fprintf(fd,"%s<y_double_indirect_push>%i</y_double_indirect_push>\n",format,y_double_indirect_push);
	if(double_indirect_push_square) {fprintf(fd,"%s<double_indirect_push_square x=\"%i\" y=\"%i\"></double_indirect_push_square>\n",format,double_indirect_push_square->get_x(),double_indirect_push_square->get_y()); }
	fprintf(fd,"%s<double_indirect_push_square_count>%i</double_indirect_push_square_count>\n",format,double_indirect_push_square_count);
	
	for(i=0;i<double_indirect_push_square_count;i++)
		if(double_indirect_push_squares[i]) {	fprintf(fd,"%s<double_indirect_push_squares id=\"%i\" x=\"%i\" y=\"%i\"></double_indirect_push_squares>\n",format,i,double_indirect_push_squares[i]->get_x(),double_indirect_push_squares[i]->get_y()); }
	
	fprintf(fd,"%s<direct_double_indirect_push>%i</direct_double_indirect_push>\n",format,direct_double_indirect_push);
	
	fprintf(fd,"%s<old_x_square>%i</old_x_square>\n",format,old_x_square);
	fprintf(fd,"%s<old_y_square>%i</old_y_square>\n",format,old_y_square);
	fprintf(fd,"%s<throw_in_anim>%i</throw_in_anim>\n",format,throw_in_anim);
	fprintf(fd,"%s<active_team>%i</active_team>\n",format,active_team);
	fprintf(fd,"%s<old_active_team>%i</old_active_team>\n",format,old_active_team);
	fprintf(fd,"%s<turn_begining_time>%i</turn_begining_time>\n",format,turn_begining_time);
	fprintf(fd,"%s<pause_begining_time>%i</pause_begining_time>\n",format,pause_begining_time);
	fprintf(fd,"%s<autocenter_anim>%i</autocenter_anim>\n",format,autocenter_anim);
	fprintf(fd,"%s<pass_anim>%i</pass_anim>\n",format,pass_anim);
	fprintf(fd,"%s<target_anim>%i</target_anim>\n",format,target_anim);
	fprintf(fd,"%s<perfect_pass>%i</perfect_pass>\n",format,perfect_pass);
	fprintf(fd,"%s<interception_square_count>%i</interception_square_count>\n",format,interception_square_count);
	if(interception_square) {fprintf(fd,"%s<interception_square x=\"%i\" y=\"%i\"></interception_square>\n",format,interception_square->get_x(),interception_square->get_y()); }
	
	for(i=0;i<interception_square_count;i++)
		if(interception_squares[i]) {	fprintf(fd,"%s<interception_squares id=\"%i\" x=\"%i\" y=\"%i\"></interception_squares>\n",format,i,interception_squares[i]->get_x(),interception_squares[i]->get_y()); }
	
	fprintf(fd,"%s<interception_attempt>%i</interception_attempt>\n",format,interception_attempt);
	fprintf(fd,"%s<x_dock>%i</x_dock>\n",format,x_dock);
	fprintf(fd,"%s<y_dock>%i</y_dock>\n",format,y_dock);
	fprintf(fd,"%s<drag_dock>%i</drag_dock>\n",format,drag_dock);
	fprintf(fd,"%s<drag_playground>%i</drag_playground>\n",format,drag_playground);
	fprintf(fd,"%s<pause>%i</pause>\n",format,pause);
	fprintf(fd,"%s<update_time>%i</update_time>\n",format,update_time);
	fprintf(fd,"%s<remaining_time>%i</remaining_time>\n",format,remaining_time);
	fprintf(fd,"%s<max_victims>%i</max_victims>\n",format,max_victims);
	fprintf(fd,"%s<old_ball_owner_team>%i</old_ball_owner_team>\n",format,old_ball_owner_team);
	fprintf(fd,"%s<transmit_square_count>%i</transmit_square_count>\n",format,transmit_square_count);	
	if(transmit_square) {fprintf(fd,"%s<transmit_square x=\"%i\" y=\"%i\"></transmit_square>\n",format,transmit_square->get_x(),transmit_square->get_y()); }
	
	for(i=0;i<transmit_square_count;i++) 
		if(transmit_squares[i]) {fprintf(fd,"%s<transmit_squares id=\"%i\" x=\"%i\" y=\"%i\"></transmit_squares>\n",format,i,transmit_squares[i]->get_x(),transmit_squares[i]->get_y()); }
	
	fprintf(fd,"%s<reserve_page_0_>%i</reserve_page_0_>\n",format,reserve_page[0]);
	fprintf(fd,"%s<reserve_page_1_>%i</reserve_page_1_>\n",format,reserve_page[1]);
	fprintf(fd,"%s<reserve_page_count_0_>%i</reserve_page_count_0_>\n",format,reserve_page_count[0]);
	fprintf(fd,"%s<reserve_page_count_1_>%i</reserve_page_count_1_>\n",format,reserve_page_count[1]);
	fprintf(fd,"%s<corridor_count_0__0_>%i</corridor_count_0__0_>\n",format,corridor_count[0][0]);
	fprintf(fd,"%s<corridor_count_0__1_>%i</corridor_count_0__1_>\n",format,corridor_count[0][1]);
	fprintf(fd,"%s<corridor_count_1__0_>%i</corridor_count_1__0_>\n",format,corridor_count[1][0]);
	fprintf(fd,"%s<corridor_count_1__1_>%i</corridor_count_1__1_>\n",format,corridor_count[1][1]);
	fprintf(fd,"%s<kick_off_result>%i</kick_off_result>\n",format,kick_off_result);
	fprintf(fd,"%s<kick_off_team>%i</kick_off_team>\n",format,kick_off_team);
	fprintf(fd,"%s<first_half_kick_off_team>%i</first_half_kick_off_team>\n",format,first_half_kick_off_team);
	fprintf(fd,"%s<team_in_placement>%i</team_in_placement>\n",format,team_in_placement);
	fprintf(fd,"%s<half>%i</half>\n",format,half);
	fprintf(fd,"%s<t0>%i</t0>\n",format,t0);
	fprintf(fd,"%s<freeze_time>%i</freeze_time>\n",format,freeze_time);
	fprintf(fd,"%s<weather>%i</weather>\n",format,weather);
	fprintf(fd,"%s<is_a_skull_and_star>%i</is_a_skull_and_star>\n",format,is_a_skull_and_star);
	
	if(selected_player) {fprintf(fd,"%s<selected_player id=\"%i\" number=\"%i\"></selected_player>\n",format,selected_player->get_team(), selected_player->get_number() );}
	if(player_to_place) {fprintf(fd,"%s<player_to_place id=\"%i\" number=\"%i\"></player_to_place>\n",format,player_to_place->get_team(), player_to_place->get_number());}
	if(team_mate) {fprintf(fd,"%s<team_mate id=\"%i\" number=\"%i\"></team_mate>\n",format,team_mate->get_team(), player_to_place->get_number());}

	fprintf(fd,"%s<need_a_winner>%i</need_a_winner>\n",format,need_a_winner);
	fprintf(fd,"%s<is_a_dump_off>%i</is_a_dump_off>\n",format,is_a_dump_off);
	fprintf(fd,"%s<is_a_blitz_dump_off>%i</is_a_blitz_dump_off>\n",format,is_a_blitz_dump_off);

	if(selection_save) {fprintf(fd,"%s<selection_save x=\"%i\" y=\"%i\"></selection_save>\n",format,selection_save->get_x(),selection_save->get_y()); }
	if(player_save) {fprintf(fd,"%s<player_save id=\"%i\" number=\"%i\"></player_save>\n",format,player_save->get_team(), player_save->get_number() );}

	fprintf(fd,"%s</state>\n",format);
}

