/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.ConventionReportTask;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.internal.serialization.Cached;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractProjectBasedReportTask<T>
extends ConventionReportTask {
    private final Cached<ProjectBasedReportModel<T>> reportModels = Cached.of(this::calculateReportModel);

    private ProjectBasedReportModel<T> calculateReportModel() {
        LinkedHashMap<ProjectDetails, T> map = new LinkedHashMap<ProjectDetails, T>();
        for (Project project : this.getProjects()) {
            map.put(ProjectDetails.of(project), this.calculateReportModelFor(project));
        }
        return new ProjectBasedReportModel(map);
    }

    protected abstract T calculateReportModelFor(Project var1);

    protected abstract void generateReportFor(ProjectDetails var1, T var2);

    @TaskAction
    void action() {
        this.reportGenerator().generateReport(((ProjectBasedReportModel)this.reportModels.get()).modelsByProjectDetails.entrySet(), Map.Entry::getKey, entry -> {
            this.generateReportFor((ProjectDetails)entry.getKey(), entry.getValue());
            this.logClickableOutputFileUrl();
        });
    }

    private static class ProjectBasedReportModel<T> {
        private final Map<ProjectDetails, T> modelsByProjectDetails;

        private ProjectBasedReportModel(Map<ProjectDetails, T> modelsByProjectDetails) {
            this.modelsByProjectDetails = modelsByProjectDetails;
        }
    }
}

