/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.yura.lobby.client.LobbyCom;

public abstract class SocketClient
extends Thread {
    public static final Logger logger = Logger.getLogger(LobbyCom.class.getName());
    private static final int HEADER_SIZE = 4;
    private ByteBuffer headerBuffer = ByteBuffer.allocateDirect(4);
    private SocketChannel socketChannel;
    private volatile Selector poll;
    private boolean connected;
    private String server;
    private int port;
    private InetAddress ipAddr;

    public SocketClient() {
        super(null, null, "LobbyCom -- Main Thread", 100000000L);
    }

    public void connect(String sev, int p) {
        this.server = sev;
        this.port = p;
        this.start();
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            this.ipAddr = InetAddress.getByName(this.server);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        while (true) {
            try {
                this.log("Trying to connect to: " + this.ipAddr + ":" + this.port);
                this.poll = Selector.open();
                this.socketChannel = SocketChannel.open();
                this.socketChannel.configureBlocking(false);
                this.socketChannel.connect(new InetSocketAddress(this.ipAddr, this.port));
                this.socketChannel.register(this.poll, 8);
                this.log("Pending Connection");
                block9: while (true) {
                    if (this.poll.select() == 0) {
                        continue;
                    }
                    iterator = this.poll.selectedKeys().iterator();
                    while (true) {
                        if (iterator.hasNext()) ** break;
                        continue block9;
                        key = iterator.next();
                        if (key.isConnectable()) {
                            sock = (SocketChannel)key.channel();
                            result = sock.finishConnect();
                            this.log("Finished Connecting " + result);
                            this.poll = Selector.open();
                            sock.register(this.poll, 1);
                            this.connected = true;
                            this.log("Initializing Handshake");
                            this.connected();
                        }
                        if (key.isReadable()) {
                            sock = (SocketChannel)key.channel();
                            try {
                                this.analyzeMessage(sock);
                            }
                            catch (IOException e) {
                                key.cancel();
                                throw e;
                            }
                        }
                        iterator.remove();
                    }
                    break;
                }
            }
            catch (IOException e) {
                SocketClient.logger.log(Level.INFO, "lobby com error", e);
                this.connected = false;
                this.disconnected();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception var2_4) {
                }
                continue;
            }
            break;
        }
    }

    public void sendToNetwork(byte[] bytes) {
        try {
            ByteBuffer[] writeBuffers = new ByteBuffer[]{ByteBuffer.allocate(4), null};
            writeBuffers[0].putInt(bytes.length);
            writeBuffers[0].flip();
            writeBuffers[1] = ByteBuffer.wrap(bytes);
            long bytesToWrite = writeBuffers[0].limit() + writeBuffers[1].limit();
            for (long bytesWritten = 0L; bytesWritten < bytesToWrite; bytesWritten += this.socketChannel.write(writeBuffers)) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void analyzeMessage(SocketChannel sc) throws IOException {
        sc.read(this.headerBuffer);
        if (this.headerBuffer.position() == 0) {
            throw new IOException("Read 0 bytes");
        }
        this.headerBuffer.flip();
        int messageLen = this.headerBuffer.getInt();
        this.headerBuffer.clear();
        ByteBuffer messageBuffer = ByteBuffer.allocate(messageLen);
        for (int read = 0; read != messageLen; read += sc.read(messageBuffer)) {
        }
        messageBuffer.flip();
        this.gotMessage(messageBuffer.array());
    }

    abstract void log(String var1);

    abstract void connected();

    abstract void disconnected();

    abstract void gotMessage(byte[] var1);
}

