/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.guishared.PicturePanel;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.domination.ui.flashgui.MainMenu;
import net.yura.domination.ui.swinggui.CardsDialog;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.mobile.util.Url;
import net.yura.swing.JTable;

public class TestPanel
extends JPanel
implements ActionListener,
SwingGUITab {
    private Risk myrisk;
    private JToolBar toolbar;
    private AbstractTableModel countriesModel;
    private AbstractTableModel continentsModel;
    private AbstractTableModel cardsModel;
    private AbstractTableModel cardsModel2;
    private AbstractTableModel playersModel;
    private AbstractTableModel gameInfo;
    private AbstractTableModel commands;
    private PicturePanel pp;

    public TestPanel(Risk r, PicturePanel p) {
        this.myrisk = r;
        this.pp = p;
        this.setName("Testing");
        this.setOpaque(false);
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        JButton refresh = new JButton("Refresh");
        refresh.setActionCommand("refresh");
        refresh.addActionListener(this);
        this.toolbar.add(refresh);
        JButton allcards = new JButton("All Cards");
        allcards.setActionCommand("allcards");
        allcards.addActionListener(this);
        this.toolbar.add(allcards);
        this.toolbar.addSeparator();
        JButton flash = new JButton("Run FlashGUI with current backend");
        flash.setActionCommand("flash");
        flash.addActionListener(this);
        this.toolbar.add(flash);
        this.toolbar.addSeparator();
        JButton changeaiwait = new JButton("Change AI wait");
        changeaiwait.setActionCommand("aiwait");
        changeaiwait.addActionListener(this);
        this.toolbar.add(changeaiwait);
        this.toolbar.addSeparator();
        JButton mapServerNameChack = new JButton("Check MapServer");
        mapServerNameChack.setActionCommand("checkMapServer");
        mapServerNameChack.addActionListener(this);
        this.toolbar.add(mapServerNameChack);
        this.countriesModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"Color/No.", "ID", "Name", "x", "y", "Continent", "Owner", "Armies", "No. Neighbours", "in", "con"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Country[] countries;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (countries = game.getCountries()) != null) {
                    return countries.length;
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Country country = TestPanel.this.myrisk.getGame().getCountries()[row];
                switch (col) {
                    case 0: {
                        return new Integer(country.getColor());
                    }
                    case 1: {
                        return country.getIdString();
                    }
                    case 2: {
                        return country.getName();
                    }
                    case 3: {
                        return new Integer(country.getX());
                    }
                    case 4: {
                        return new Integer(country.getY());
                    }
                    case 5: {
                        return country.getContinent();
                    }
                    case 6: {
                        return country.getOwner();
                    }
                    case 7: {
                        return new Integer(country.getArmies());
                    }
                    case 8: {
                        Vector neighbours = country.getNeighbours();
                        if (neighbours == null) {
                            return null;
                        }
                        return new Integer(neighbours.size());
                    }
                    case 9: {
                        List<Country> neighbours = country.getIncomingNeighbours();
                        if (neighbours == null) {
                            return null;
                        }
                        return new Integer(neighbours.size());
                    }
                    case 10: {
                        List<Country> neighbours = country.getCrossContinentNeighbours();
                        if (neighbours == null) {
                            return null;
                        }
                        return new Integer(neighbours.size());
                    }
                }
                throw new RuntimeException();
            }
        };
        this.continentsModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"No.", "ID", "Name", "Army Value", "No. Countries", "Color"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Continent[] continents;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (continents = game.getContinents()) != null) {
                    return continents.length;
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Continent continent = TestPanel.this.myrisk.getGame().getContinents()[row];
                switch (col) {
                    case 0: {
                        return new Integer(row + 1);
                    }
                    case 1: {
                        return continent.getIdString();
                    }
                    case 2: {
                        return continent.getName();
                    }
                    case 3: {
                        return new Integer(continent.getArmyValue());
                    }
                    case 4: {
                        return new Integer(continent.getTerritoriesContained().size());
                    }
                    case 5: {
                        return ColorUtil.getStringForColor(continent.getColor());
                    }
                }
                throw new RuntimeException();
            }
        };
        this.cardsModel = new CardsTableModel(){

            List getCards() {
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null) {
                    Vector l = game.getCards();
                    return l == null ? Collections.EMPTY_LIST : l;
                }
                return Collections.EMPTY_LIST;
            }
        };
        this.cardsModel2 = new CardsTableModel(){

            List getCards() {
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null) {
                    Vector l = game.getUsedCards();
                    return l == null ? Collections.EMPTY_LIST : l;
                }
                return Collections.EMPTY_LIST;
            }
        };
        this.playersModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"Name", "Color", "Type", "Extra Armies", "No. Cards", "No. Countries", "No. Player Eliminated", "Capital", "Mission", "Address", "autodefend", "autoendgo"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Vector players;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (players = game.getPlayers()) != null) {
                    return players.size();
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Player player = (Player)TestPanel.this.myrisk.getGame().getPlayers().elementAt(row);
                switch (col) {
                    case 0: {
                        return player.getName();
                    }
                    case 1: {
                        return ColorUtil.getStringForColor(player.getColor());
                    }
                    case 2: {
                        return TestPanel.this.myrisk.getType(player.getType());
                    }
                    case 3: {
                        return new Integer(player.getExtraArmies());
                    }
                    case 4: {
                        return new Integer(player.getCards().size());
                    }
                    case 5: {
                        return new Integer(player.getNoTerritoriesOwned());
                    }
                    case 6: {
                        return new Integer(player.getPlayersEliminated().size());
                    }
                    case 7: {
                        return player.getCapital();
                    }
                    case 8: {
                        return player.getMission();
                    }
                    case 9: {
                        return player.getAddress();
                    }
                    case 10: {
                        return new Boolean(player.getAutoDefend());
                    }
                    case 11: {
                        return new Boolean(player.getAutoEndGo());
                    }
                }
                throw new RuntimeException();
            }

            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 0: 
                    case 2: 
                    case 9: {
                        return true;
                    }
                }
                return false;
            }

            public void setValueAt(Object aValue, int row, int col) {
                Player player = (Player)TestPanel.this.myrisk.getGame().getPlayers().elementAt(row);
                try {
                    String address;
                    int type;
                    String name;
                    String string = name = col == 0 ? String.valueOf(aValue) : player.getName();
                    if (name.equals("")) {
                        throw new IllegalArgumentException("no empty name");
                    }
                    int n = type = col == 2 ? TestPanel.this.myrisk.getType(String.valueOf(aValue)) : player.getType();
                    if (type == -1) {
                        throw new IllegalArgumentException("bad type " + aValue);
                    }
                    String string2 = address = col == 9 ? String.valueOf(aValue) : player.getAddress();
                    if (address.equals("")) {
                        throw new IllegalArgumentException("no empty address");
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("oldName", player.getName());
                    map.put("newName", name);
                    map.put("newType", type);
                    map.put("newAddress", address);
                    TestPanel.this.myrisk.parserFromNetwork("RENAME " + Url.toQueryString((Hashtable)RiskUtil.asHashtable(map)));
                }
                catch (Exception ex) {
                    System.out.println("error " + ex);
                }
            }
        };
        this.gameInfo = new ObjectTableModel(){

            public Object getObject() {
                return TestPanel.this.myrisk.getGame();
            }
        };
        this.commands = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"No", "Command"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Vector players;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (players = game.getCommands()) != null) {
                    return players.size();
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Object command = TestPanel.this.myrisk.getGame().getCommands().elementAt(row);
                switch (col) {
                    case 0: {
                        return String.valueOf(row);
                    }
                    case 1: {
                        return String.valueOf(command);
                    }
                }
                throw new RuntimeException();
            }
        };
        JTabbedPane views = new JTabbedPane();
        views.add("Countries", new JScrollPane(new JTable(this.countriesModel)));
        views.add("Continents", new JScrollPane(new JTable(this.continentsModel)));
        views.add("Cards", new JScrollPane(new JTable(this.cardsModel)));
        views.add("Spent Cards", new JScrollPane(new JTable(this.cardsModel2)));
        views.add("Players", new JScrollPane(new JTable(this.playersModel)));
        views.add("Game", new JScrollPane(new JTable(this.gameInfo)));
        JTable commandsTable = new JTable(this.commands);
        commandsTable.setCellSelectionEnabled(true);
        views.add("Commands", new JScrollPane(commandsTable));
        this.setLayout(new BorderLayout());
        this.add(views);
    }

    public void actionPerformed(ActionEvent a) {
        String command = a.getActionCommand();
        if ("refresh".equals(command)) {
            this.countriesModel.fireTableDataChanged();
            this.continentsModel.fireTableDataChanged();
            this.cardsModel.fireTableDataChanged();
            this.cardsModel2.fireTableDataChanged();
            this.playersModel.fireTableDataChanged();
            this.gameInfo.fireTableDataChanged();
            this.commands.fireTableDataChanged();
            this.repaint();
        } else if ("flash".equals(command)) {
            MainMenu.newMainMenuFrame(this.myrisk, 2);
        } else if ("aiwait".equals(command)) {
            Object[] options;
            Object[] message = new Object[]{new JLabel("AI wait time (in milliseconds):"), new JSpinner(new SpinnerNumberModel(AIManager.getWait(), 0, 10000, 100))};
            int result = JOptionPane.showOptionDialog(this, message, "AI Options", 2, -1, null, options = new String[]{"OK", "cancel"}, options[0]);
            if (result == 0) {
                AIManager.setWait((Integer)((JSpinner)message[1]).getValue());
            }
        } else if ("allcards".equals(command)) {
            if (this.myrisk.getGame() != null && this.myrisk.getGame().getState() != 0 && this.myrisk.getGame().getCards() != null) {
                Frame frame = RiskUIUtil.findParentFrame(this);
                CardsDialog cardsDialog = new CardsDialog(frame, this.pp, false, this.myrisk, false);
                Dimension frameSize = frame.getSize();
                Dimension aboutSize = cardsDialog.getPreferredSize();
                int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
                int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                cardsDialog.setLocation(x, y);
                cardsDialog.populate(this.myrisk.getGame().getCards());
                cardsDialog.setVisible(true);
            }
        } else if ("checkMapServer".equals(command)) {
            List maps = MapUpdateService.getMaps(MapChooser.MAP_PAGE, Collections.EMPTY_LIST);
            HashSet<String> ids = new HashSet<String>();
            HashSet<String> errors = new HashSet<String>();
            for (Map map : maps) {
                String fileUID = RiskUtil.replaceAll(MapChooser.getFileUID(map.getMapUrl()), " ", "").toLowerCase();
                if (ids.contains(fileUID)) {
                    errors.add(fileUID);
                    continue;
                }
                ids.add(fileUID);
            }
            if (errors.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No errors found.");
            } else {
                JOptionPane.showMessageDialog(this, "Error found with map: " + errors);
            }
        } else {
            throw new RuntimeException("TestTab: unknown command found: " + command);
        }
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public JMenu getMenu() {
        return null;
    }

    abstract class CardsTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"No.", "Type", "Country"};

        CardsTableModel() {
        }

        abstract List getCards();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.getCards().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Card card = (Card)this.getCards().get(row);
            switch (col) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return card.getName();
                }
                case 2: {
                    return card.getCountry();
                }
            }
            throw new RuntimeException();
        }
    }

    abstract class ObjectTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Name", "Value"};
        private Field[] fields;

        ObjectTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            Object game = this.getObject();
            if (game != null) {
                if (this.fields == null) {
                    Field[] fs = game.getClass().getDeclaredFields();
                    ArrayList<Field> result = new ArrayList<Field>();
                    for (int c = 0; c < fs.length; ++c) {
                        if (Modifier.isStatic(fs[c].getModifiers())) continue;
                        try {
                            fs[c].setAccessible(true);
                            result.add(fs[c]);
                            continue;
                        }
                        catch (Exception ex) {
                            System.out.println("can not setAccessible " + fs[c] + " " + ex);
                        }
                    }
                    this.fields = result.toArray(new Field[result.size()]);
                }
                return this.fields.length;
            }
            return 0;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Object game = this.getObject();
            switch (col) {
                case 0: {
                    return this.fields[row].getName();
                }
                case 1: {
                    try {
                        return String.valueOf(this.fields[row].get(game));
                    }
                    catch (Exception ex) {
                        return ex.toString();
                    }
                }
            }
            throw new RuntimeException();
        }

        public abstract Object getObject();
    }
}

