/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.rc.tasks;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilerBuilder;
import org.gradle.language.rc.internal.DefaultWindowsResourceCompileSpec;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class WindowsResourceCompile
extends DefaultTask {
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;
    private File outputDir;
    private ConfigurableFileCollection includes;
    private ConfigurableFileCollection source;
    private Map<String, String> macros = new LinkedHashMap<String, String>();
    private final ListProperty<String> compilerArgs;
    private final IncrementalCompilerBuilder.IncrementalCompiler incrementalCompiler;

    public WindowsResourceCompile() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.includes = this.getProject().files(new Object[0]);
        this.source = this.getProject().files(new Object[0]);
        this.compilerArgs = this.getProject().getObjects().listProperty(String.class);
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
        this.incrementalCompiler = this.getIncrementalCompilerBuilder().newCompiler((TaskInternal)this, (FileCollection)this.source, (FileCollection)this.includes, this.macros, (Provider<Boolean>)Providers.FALSE);
        this.getInputs().property("outputType", (Object)new Callable<String>(){

            @Override
            public String call() {
                NativeToolChainInternal nativeToolChain = (NativeToolChainInternal)WindowsResourceCompile.this.toolChain.get();
                NativePlatformInternal nativePlatform = (NativePlatformInternal)WindowsResourceCompile.this.targetPlatform.get();
                return NativeToolChainInternal.Identifier.identify((NativeToolChainInternal)nativeToolChain, (NativePlatformInternal)nativePlatform);
            }
        });
    }

    @Inject
    public IncrementalCompilerBuilder getIncrementalCompilerBuilder() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void compile(InputChanges inputs) {
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        DefaultWindowsResourceCompileSpec spec = new DefaultWindowsResourceCompileSpec();
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(this.getOutputDir());
        spec.include((Iterable)this.getIncludes());
        spec.source((Iterable)this.getSource());
        spec.setMacros(this.getMacros());
        spec.args((List)this.getCompilerArgs().get());
        spec.setIncrementalCompile(inputs.isIncremental());
        spec.setOperationLogger(operationLogger);
        NativeToolChainInternal nativeToolChain = (NativeToolChainInternal)this.toolChain.get();
        NativePlatformInternal nativePlatform = (NativePlatformInternal)this.targetPlatform.get();
        PlatformToolProvider platformToolProvider = nativeToolChain.select(nativePlatform);
        WorkResult result = this.doCompile(spec, platformToolProvider);
        this.setDidWork(result.getDidWork());
    }

    private <T extends NativeCompileSpec> WorkResult doCompile(T spec, PlatformToolProvider platformToolProvider) {
        Class specType = (Class)Cast.uncheckedCast(spec.getClass());
        Compiler baseCompiler = platformToolProvider.newCompiler(specType);
        Compiler incrementalCompiler = this.incrementalCompiler.createCompiler(baseCompiler);
        Compiler loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap(incrementalCompiler);
        return CompilerUtil.castCompiler((Compiler)loggingCompiler).execute(spec);
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getIncludes() {
        return this.includes;
    }

    public void includes(Object includeRoots) {
        this.includes.from(new Object[]{includeRoots});
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(new Object[]{sourceFiles});
    }

    @Input
    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    @Input
    public ListProperty<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    protected FileCollection getHeaderDependencies() {
        return this.incrementalCompiler.getHeaderFiles();
    }
}

