/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.UncheckedXPathException;
import org.apache.commons.io.FileUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.RewriteRule;
import org.dita.dost.module.XmlFilterModule;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.dita.dost.writer.LinkFilter;
import org.dita.dost.writer.MapCleanFilter;
import org.dita.dost.writer.TopicCleanFilter;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLFilter;
import org.xmlresolver.Resolver;

public class CleanPreprocessModule
extends AbstractPipelineModuleImpl {
    private static final String PARAM_USE_RESULT_FILENAME = "use-result-filename";
    private final LinkFilter linkFilter = new LinkFilter();
    private final MapCleanFilter mapFilter = new MapCleanFilter();
    private final TopicCleanFilter topicFilter = new TopicCleanFilter();
    private boolean useResultFilename;
    private XsltTransformer rewriteTransformer;
    private RewriteRule rewriteClass;

    private void init(Map<String, String> input) {
        this.useResultFilename = Optional.ofNullable(input.get(PARAM_USE_RESULT_FILENAME)).map(Boolean::parseBoolean).orElse(false);
        Resolver catalogResolver = this.xmlUtils.getCatalogResolver();
        this.rewriteTransformer = Optional.ofNullable(input.get("result.rewrite-rule.xsl")).map(file -> {
            try {
                return catalogResolver.resolve(URLUtils.toURI(file).toString(), null);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }).map(f -> {
            try {
                Processor processor = this.xmlUtils.getProcessor();
                XsltCompiler xsltCompiler = processor.newXsltCompiler();
                xsltCompiler.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
                XsltExecutable xsltExecutable = xsltCompiler.compile(f);
                return xsltExecutable.load();
            }
            catch (UncheckedXPathException e) {
                throw new RuntimeException("Failed to compile XSLT: " + e.getXPathException().getMessageAndLocation(), e);
            }
            catch (SaxonApiException e) {
                throw new RuntimeException("Failed to compile XSLT: " + e.getMessage(), e);
            }
        }).orElse(null);
        this.rewriteClass = Optional.ofNullable(input.get("result.rewrite-rule.class")).map(c -> {
            try {
                Class<?> cls = Class.forName(c);
                return (RewriteRule)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
        this.linkFilter.setLogger(this.logger);
        this.mapFilter.setLogger(this.logger);
        this.topicFilter.setLogger(this.logger);
    }

    @Override
    public AbstractPipelineOutput execute(Map<String, String> input) throws DITAOTException {
        this.init(input);
        URI base = this.job.getResultBaseDir();
        if (this.useResultFilename) {
            Collection<Job.FileInfo> original = this.extractFileInfos(base);
            Collection<Job.FileInfo> rewritten = this.rewriteFileInfos(original);
            this.moveFiles(rewritten, base);
        }
        this.job.setProperty("uplevels", this.getUplevels(base));
        this.job.setInputDir(base);
        this.writeInputMapList();
        try {
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException();
        }
        return null;
    }

    @Deprecated
    private void writeInputMapList() {
        Job.FileInfo start = this.job.getFileInfo(f -> f.isInput).iterator().next();
        if (start != null) {
            this.job.setInputMap(start.uri);
            File inputfile = new File(this.job.tempDir, "usr.input.file.list");
            try {
                Files.writeString(inputfile.toPath(), (CharSequence)start.file.getPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void moveFiles(Collection<Job.FileInfo> rewritten, URI base) throws DITAOTException {
        Job tempJob = new Job(this.job, Collections.emptyMap(), rewritten);
        this.linkFilter.setJob(tempJob);
        this.mapFilter.setJob(tempJob);
        this.topicFilter.setJob(tempJob);
        for (Job.FileInfo fi : rewritten) {
            try {
                assert (!fi.result.isAbsolute());
                if (fi.format != null && (fi.format.equals("coderef") || fi.format.equals("image"))) {
                    this.logger.debug("Skip format " + fi.format);
                } else {
                    File srcFile = new File(this.job.tempDirURI.resolve(fi.uri));
                    if (this.job.getStore().exists(srcFile.toURI())) {
                        File destFile = new File(this.job.tempDirURI.resolve(fi.result));
                        List<XMLFilter> processingPipe = this.getProcessingPipe(fi, srcFile, destFile);
                        if (!processingPipe.isEmpty()) {
                            this.logger.info("Processing " + String.valueOf(srcFile.toURI()) + " to " + String.valueOf(destFile.toURI()));
                            this.job.getStore().transform(srcFile.toURI(), destFile.toURI(), processingPipe);
                            if (!srcFile.equals(destFile)) {
                                this.logger.debug("Deleting " + String.valueOf(srcFile.toURI()));
                                FileUtils.deleteQuietly((File)srcFile);
                            }
                        } else if (!srcFile.equals(destFile)) {
                            this.logger.info("Moving " + String.valueOf(srcFile.toURI()) + " to " + String.valueOf(destFile.toURI()));
                            FileUtils.moveFile((File)srcFile, (File)destFile);
                        }
                    }
                }
                Job.FileInfo res = Job.FileInfo.builder(fi).uri(fi.result).result(base.resolve(fi.result)).build();
                this.job.add(res);
            }
            catch (IOException e) {
                this.logger.error("Failed to clean " + String.valueOf(this.job.tempDirURI.resolve(fi.uri)) + ": " + e.getMessage(), e);
            }
        }
    }

    private Collection<Job.FileInfo> extractFileInfos(URI base) {
        Collection original = this.job.getFileInfo().stream().filter(fi -> fi.result != null).map(fi -> Job.FileInfo.builder(fi).result(base.relativize(fi.result)).build()).collect(Collectors.toList());
        original.forEach(fi -> this.job.remove((Job.FileInfo)fi));
        return original;
    }

    private Collection<Job.FileInfo> rewriteFileInfos(Collection<Job.FileInfo> fis) throws DITAOTException {
        if (this.rewriteClass != null) {
            return this.rewriteClass.rewrite(fis);
        }
        if (this.rewriteTransformer != null) {
            try {
                DOMSource source = new DOMSource(this.serialize(fis));
                HashMap<URI, Job.FileInfo> files = new HashMap<URI, Job.FileInfo>();
                SAXDestination result = new SAXDestination((ContentHandler)new Job.JobHandler(new HashMap<String, Object>(), files));
                this.rewriteTransformer.setSource((Source)source);
                this.rewriteTransformer.setDestination((Destination)result);
                this.rewriteTransformer.transform();
                return files.values();
            }
            catch (IOException | SaxonApiException e) {
                throw new DITAOTException(e);
            }
        }
        return fis;
    }

    private Document serialize(Collection<Job.FileInfo> fis) throws IOException {
        try {
            Document doc = this.xmlUtils.newDocument();
            DOMResult result = new DOMResult(doc);
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(result);
            this.job.serialize(out, Collections.emptyMap(), fis);
            return (Document)result.getNode();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to serialize job file: " + e.getMessage());
        }
    }

    String getUplevels(URI base) {
        URI rel = base.relativize(this.job.getInputFile());
        int count = rel.toString().split("/").length - 1;
        return IntStream.range(0, count).boxed().map(i -> "../").collect(Collectors.joining(""));
    }

    private List<XMLFilter> getProcessingPipe(Job.FileInfo fi, File srcFile, File destFile) {
        ArrayList<XMLFilter> res = new ArrayList<XMLFilter>();
        if (DitaUtils.isDitaFormat(fi) || DitaUtils.isDitaMap(fi)) {
            this.linkFilter.setCurrentFile(srcFile.toURI());
            this.linkFilter.setDestFile(destFile.toURI());
            res.add(this.linkFilter);
        }
        if (DitaUtils.isDitaFormat(fi)) {
            this.topicFilter.setFileInfo(fi);
            res.add(this.topicFilter);
        } else if (DitaUtils.isDitaMap(fi)) {
            this.mapFilter.setFileInfo(fi);
            res.add(this.mapFilter);
        }
        for (XmlFilterModule.FilterPair p : this.filters) {
            if (!p.predicate.test(fi)) continue;
            AbstractXMLFilter f = p.newInstance();
            this.logger.debug("Configure filter " + f.getClass().getCanonicalName());
            f.setCurrentFile(srcFile.toURI());
            f.setJob(this.job);
            f.setLogger(this.logger);
            res.add(f);
        }
        return res;
    }
}

