#ifndef _forumsearch_page_
#define _forumsearch_page_

#include "forumpage.h"

#include <Poco/DateTime.h>

class ForumSearchPage:public ForumTemplatePage
{
public:
	ForumSearchPage(SQLite3DB::DB *db, const HTMLTemplateHandler &templatehandler):ForumTemplatePage(db,templatehandler,"forumsearch.htm")	{}

	IPageHandler *New()	{ return new ForumSearchPage(m_db,m_templatehandler); }

private:
	const std::string GenerateContent(const std::string &method, const std::map<std::string,QueryVar> &queryvars);

	const std::string CreateForumDropDown(const std::string &name, const int selectedforumid) const;
	const std::string CreateSortByDropDown(const std::string &name, const std::string &selecteditem) const;
	const std::string CreateSortOrderDropDown(const std::string &name, const std::string &selecteditem) const;

	struct searchitem
	{
		std::string m_phrase;
		bool m_include;
		int m_group;
	};

	struct searchfields
	{
		searchfields():m_querystring(""),m_subject(""),m_author(""),m_boardid(-1),m_threadid(-1),m_hasstartdate(false),m_hasenddate(false),m_sortby("Date"),m_sortorder("DESC"),m_maxmessageid(-1),m_startrow(0)	{}
		std::string m_querystring;
		std::string m_subject;
		std::string m_author;
		int m_boardid;
		int m_threadid;
		bool m_hasstartdate;
		Poco::DateTime m_startdate;
		bool m_hasenddate;
		Poco::DateTime m_enddate;
		std::string m_sortby;
		std::string m_sortorder;
		int m_maxmessageid;
		int m_startrow;
	};

	void SeparateSearchItems(const std::string &querystring, std::vector<searchitem> &searchitems);
	const std::string CreateSQLCriteriaClause(const std::vector<searchitem> &searchitems, const std::string &fieldname) const;
	const std::string CreateHiddenFormFields(const searchfields &sf, const std::string &viewstateid, bool withstartrow=false, const bool withpagenum=false);

};

#endif	// _forumsearch_page_
