/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.SourceInfo;
import tim.prune.gui.GuiGridLayout;
import tim.prune.load.BabelFileFormats;
import tim.prune.load.BabelLoadFunction;
import tim.prune.load.babel.BabelFilterPanel;

public class BabelLoadFromFile
extends BabelLoadFunction {
    private JFileChooser _fileChooser = null;
    private File _inputFile = null;
    private JLabel _inputFileLabel = null;
    private JComboBox<String> _formatDropdown = null;
    private String _lastSuffix = null;

    public BabelLoadFromFile(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.importwithgpsbabel";
    }

    @Override
    protected String getFilePath() {
        return this._inputFile.getAbsolutePath();
    }

    @Override
    protected SourceInfo getSourceInfo() {
        return new SourceInfo(this._inputFile, SourceInfo.FILE_TYPE.GPSBABEL);
    }

    @Override
    protected String getInputFormat() {
        return BabelFileFormats.getFormat(this._formatDropdown.getSelectedIndex());
    }

    @Override
    protected boolean isInputOk() {
        return this._inputFile.exists() && this._inputFile.canRead();
    }

    @Override
    public void begin() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            String string = Config.getConfigString("prune.trackdirectory");
            if (string == null) {
                string = Config.getConfigString("prune.photodirectory");
            }
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
            this._fileChooser.setMultiSelectionEnabled(false);
        }
        if (this._fileChooser.showOpenDialog(this._parentFrame) == 0) {
            this._inputFile = this._fileChooser.getSelectedFile();
            if (this._inputFile != null && this.isInputOk()) {
                super.begin();
            }
        }
    }

    public void beginWithFile(File file) {
        this._inputFile = file;
        super.begin();
    }

    @Override
    protected JPanel makeDialogComponents(JButton jButton) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel3);
        JLabel jLabel = new JLabel(I18nManager.getText("details.track.file"));
        guiGridLayout.add(jLabel);
        this._inputFileLabel = new JLabel("------------");
        guiGridLayout.add(this._inputFileLabel);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.gpsload.format"));
        guiGridLayout.add(jLabel2);
        this._formatDropdown = new JComboBox<String>(BabelFileFormats.getDescriptions());
        guiGridLayout.add(this._formatDropdown);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        jPanel2.add(jPanel3);
        ChangeListener changeListener = changeEvent -> this.enableOkButton();
        this._waypointCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.getwaypoints"), true);
        this._waypointCheckbox.addChangeListener(changeListener);
        this._waypointCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._waypointCheckbox);
        this._trackCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.gettracks"), true);
        this._trackCheckbox.addChangeListener(changeListener);
        this._trackCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._trackCheckbox);
        this._saveCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.save"));
        this._saveCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._saveCheckbox);
        this._filterPanel = new BabelFilterPanel(this._parentFrame);
        String string = Config.getConfigString("prune.gpsbabelfilter");
        if (string != null) {
            this._filterPanel.setFilterString(string);
        }
        jPanel2.add(this._filterPanel);
        this._progressBar = new JProgressBar(0, 10);
        jPanel2.add(this._progressBar);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> {
            this._cancelled = true;
            this._dialog.dispose();
        });
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private String getSelectedSuffix() {
        String string = this._inputFile.getName();
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(n) : "";
    }

    @Override
    protected void initDialog() {
        this._inputFileLabel.setText(this._inputFile.getName());
        String string = this.getSelectedSuffix();
        if (this._lastSuffix == null || !string.equalsIgnoreCase(this._lastSuffix)) {
            int n = BabelFileFormats.getIndexForFileSuffix(string);
            if (n < 0) {
                n = Config.getConfigInt("prune.lastimportfileformat");
            }
            if (n >= 0) {
                this._formatDropdown.setSelectedIndex(n);
            }
        }
        this._lastSuffix = string;
    }

    @Override
    protected void saveConfigValues() {
        String string = this._filterPanel.getFilterString();
        Config.setConfigString("prune.gpsbabelfilter", string);
        int n = BabelFileFormats.getIndexForFileSuffix(this.getSelectedSuffix());
        if (n < 0) {
            Config.setConfigInt("prune.lastimportfileformat", this._formatDropdown.getSelectedIndex());
        }
    }
}

